/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.oracleclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to Oracle Database.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OracleConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.oracleclient.OracleConnection.class)
public class OracleConnection extends io.vertx.rxjava3.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OracleConnection that = (OracleConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OracleConnection> __TYPE_ARG = new TypeArg<>(    obj -> new OracleConnection((io.vertx.oracleclient.OracleConnection) obj),
    OracleConnection::getDelegate
  );

  private final io.vertx.oracleclient.OracleConnection delegate;
  
  public OracleConnection(io.vertx.oracleclient.OracleConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OracleConnection(Object delegate) {
    super((io.vertx.oracleclient.OracleConnection)delegate);
    this.delegate = (io.vertx.oracleclient.OracleConnection)delegate;
  }

  public io.vertx.oracleclient.OracleConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to Oracle with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.oracleclient.OracleConnection> connect(io.vertx.rxjava3.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.oracleclient.OracleConnection> ret = rxConnect(vertx, connectOptions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Create a connection to Oracle with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.oracleclient.OracleConnection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.oracleclient.OracleConnection.connect(vertx.getDelegate(), connectOptions, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.oracleclient.OracleConnection.newInstance((io.vertx.oracleclient.OracleConnection)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.oracleclient.OracleConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.oracleclient.OracleConnection> connect(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.oracleclient.OracleConnection> ret = rxConnect(vertx, connectionUri);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.oracleclient.OracleConnection#connect} with options built from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.oracleclient.OracleConnection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.oracleclient.OracleConnection.connect(vertx.getDelegate(), connectionUri, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.oracleclient.OracleConnection.newInstance((io.vertx.oracleclient.OracleConnection)event))));
    });
  }

  /**
   * 
   * @param s 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> prepare(java.lang.String s) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> ret = rxPrepare(s);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * 
   * @param s 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> rxPrepare(java.lang.String s) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.prepare(s, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava3.oracleclient.OracleConnection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava3.oracleclient.OracleConnection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Cast a  to {@link io.vertx.rxjava3.oracleclient.OracleConnection}.
   * <p>
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.rxjava3.oracleclient.OracleConnection instance}
   */
  public static io.vertx.rxjava3.oracleclient.OracleConnection cast(io.vertx.rxjava3.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.rxjava3.oracleclient.OracleConnection ret = io.vertx.rxjava3.oracleclient.OracleConnection.newInstance((io.vertx.oracleclient.OracleConnection)io.vertx.oracleclient.OracleConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static OracleConnection newInstance(io.vertx.oracleclient.OracleConnection arg) {
    return arg != null ? new OracleConnection(arg) : null;
  }

}
