/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpc.common;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A generic gRPC message
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpc.common.GrpcMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpc.common.GrpcMessage.class)
public class GrpcMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcMessage that = (GrpcMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcMessage> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcMessage((io.vertx.grpc.common.GrpcMessage) obj),
    GrpcMessage::getDelegate
  );

  private final io.vertx.grpc.common.GrpcMessage delegate;
  
  public GrpcMessage(io.vertx.grpc.common.GrpcMessage delegate) {
    this.delegate = delegate;
  }

  public GrpcMessage(Object delegate) {
    this.delegate = (io.vertx.grpc.common.GrpcMessage)delegate;
  }

  public io.vertx.grpc.common.GrpcMessage getDelegate() {
    return delegate;
  }

  /**
   * @param encoding 
   * @param payload 
   * @return a new message
   */
  public static io.vertx.rxjava3.grpc.common.GrpcMessage message(java.lang.String encoding, io.vertx.rxjava3.core.buffer.Buffer payload) { 
    io.vertx.rxjava3.grpc.common.GrpcMessage ret = io.vertx.rxjava3.grpc.common.GrpcMessage.newInstance((io.vertx.grpc.common.GrpcMessage)io.vertx.grpc.common.GrpcMessage.message(encoding, payload.getDelegate()));
    return ret;
  }

  /**
   * @return the message encoding
   */
  public java.lang.String encoding() { 
    java.lang.String ret = delegate.encoding();
    return ret;
  }

  /**
   * @return the message payload, usually in Protobuf format encoded in the {@link io.vertx.rxjava3.grpc.common.GrpcMessage#encoding} format
   */
  public io.vertx.rxjava3.core.buffer.Buffer payload() { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.payload());
    return ret;
  }

  public static GrpcMessage newInstance(io.vertx.grpc.common.GrpcMessage arg) {
    return arg != null ? new GrpcMessage(arg) : null;
  }

}
