/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.openapi;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An authentication handler factory. This class will hold factories for creating 
 * objects.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.openapi.SecurityScheme original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.openapi.SecurityScheme.class)
public class SecurityScheme {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SecurityScheme that = (SecurityScheme) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SecurityScheme> __TYPE_ARG = new TypeArg<>(    obj -> new SecurityScheme((io.vertx.ext.web.openapi.SecurityScheme) obj),
    SecurityScheme::getDelegate
  );

  private final io.vertx.ext.web.openapi.SecurityScheme delegate;
  
  public SecurityScheme(io.vertx.ext.web.openapi.SecurityScheme delegate) {
    this.delegate = delegate;
  }

  public SecurityScheme(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.SecurityScheme)delegate;
  }

  public io.vertx.ext.web.openapi.SecurityScheme getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.ext.web.openapi.RouterBuilder> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.ext.web.openapi.RouterBuilder>(o1 -> io.vertx.rxjava3.ext.web.openapi.RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)o1), o1 -> o1.getDelegate());

  public io.vertx.rxjava3.ext.web.openapi.RouterBuilder bindBlocking(java.util.function.Function<io.vertx.core.json.JsonObject,io.vertx.rxjava3.ext.web.handler.AuthenticationHandler> factory) { 
    io.vertx.rxjava3.ext.web.openapi.RouterBuilder ret = io.vertx.rxjava3.ext.web.openapi.RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)delegate.bindBlocking(new Function<io.vertx.core.json.JsonObject,io.vertx.ext.web.handler.AuthenticationHandler>() {
      public io.vertx.ext.web.handler.AuthenticationHandler apply(io.vertx.core.json.JsonObject arg) {
        io.vertx.rxjava3.ext.web.handler.AuthenticationHandler ret = factory.apply(arg);
        return ret.getDelegate();
      }
    }));
    return ret;
  }

  public io.vertx.core.Future<io.vertx.rxjava3.ext.web.openapi.RouterBuilder> bind(java.util.function.Function<io.vertx.core.json.JsonObject,io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.web.handler.AuthenticationHandler>> factory) { 
    io.vertx.core.Future<io.vertx.rxjava3.ext.web.openapi.RouterBuilder> ret = delegate.bind(new Function<io.vertx.core.json.JsonObject,io.vertx.core.Future<io.vertx.ext.web.handler.AuthenticationHandler>>() {
      public io.vertx.core.Future<io.vertx.ext.web.handler.AuthenticationHandler> apply(io.vertx.core.json.JsonObject arg) {
        io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.web.handler.AuthenticationHandler> ret = factory.apply(arg);
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    }).map(val -> io.vertx.rxjava3.ext.web.openapi.RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)val));
    return ret;
  }

  public static SecurityScheme newInstance(io.vertx.ext.web.openapi.SecurityScheme arg) {
    return arg != null ? new SecurityScheme(arg) : null;
  }

}
