/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler.graphql;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent.class)
public class ApolloWSConnectionInitEvent extends io.vertx.rxjava3.core.Promise<java.lang.Object> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ApolloWSConnectionInitEvent that = (ApolloWSConnectionInitEvent) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ApolloWSConnectionInitEvent> __TYPE_ARG = new TypeArg<>(    obj -> new ApolloWSConnectionInitEvent((io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent) obj),
    ApolloWSConnectionInitEvent::getDelegate
  );

  private final io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent delegate;
  
  public ApolloWSConnectionInitEvent(io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ApolloWSConnectionInitEvent(Object delegate) {
    super((io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent)delegate);
    this.delegate = (io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent)delegate;
  }

  public io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent getDelegate() {
    return delegate;
  }


  /**
   * Set the result. Any handler will be called, if there is one, and the promise will be marked as completed.
   * <p/>
   * Any handler set on the associated promise will be called.
   * @param result the result
   */
  @Deprecated()
  public void complete(java.lang.Object result) { 
    delegate.complete(result);
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Promise#complete} but returns <code>false</code> when the promise is already completed instead of throwing
   * an {@link java.lang.IllegalStateException}, it returns <code>true</code> otherwise.
   * @param result the result
   * @return <code>false</code> when the future is already completed
   */
  @Deprecated()
  public boolean tryComplete(java.lang.Object result) { 
    boolean ret = delegate.tryComplete(result);
    return ret;
  }

  /**
   * @return the  associated with this promise, it can be used to be aware of the promise completion
   */
  @Deprecated()
  public io.vertx.core.Future<java.lang.Object> future() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.Future<java.lang.Object> ret = delegate.future().map(val -> (Object) val);
    cached_0 = ret;
    return ret;
  }

  /**
   * Provides  message content.
   * @return message
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage message() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage ret = io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage.newInstance((io.vertx.ext.web.handler.graphql.ApolloWSMessage)delegate.message());
    cached_1 = ret;
    return ret;
  }

  private io.vertx.core.Future<java.lang.Object> cached_0;
  private io.vertx.rxjava3.ext.web.handler.graphql.ApolloWSMessage cached_1;
  public static ApolloWSConnectionInitEvent newInstance(io.vertx.ext.web.handler.graphql.ApolloWSConnectionInitEvent arg) {
    return arg != null ? new ApolloWSConnectionInitEvent(arg) : null;
  }

}
