/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.api.validation;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface that define methods for deserialization of array and objects
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.ContainerDeserializer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.validation.ContainerDeserializer.class)
public class ContainerDeserializer {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ContainerDeserializer that = (ContainerDeserializer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ContainerDeserializer> __TYPE_ARG = new TypeArg<>(    obj -> new ContainerDeserializer((io.vertx.ext.web.api.validation.ContainerDeserializer) obj),
    ContainerDeserializer::getDelegate
  );

  private final io.vertx.ext.web.api.validation.ContainerDeserializer delegate;
  
  public ContainerDeserializer(io.vertx.ext.web.api.validation.ContainerDeserializer delegate) {
    this.delegate = delegate;
  }

  public ContainerDeserializer(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.validation.ContainerDeserializer)delegate;
  }

  public io.vertx.ext.web.api.validation.ContainerDeserializer getDelegate() {
    return delegate;
  }


  @Deprecated()
  public java.util.List<java.lang.String> deserializeArray(java.lang.String serialized) { 
    java.util.List<java.lang.String> ret = delegate.deserializeArray(serialized);
    return ret;
  }

  @Deprecated()
  public java.util.Map<java.lang.String,java.lang.String> deserializeObject(java.lang.String serialized) { 
    java.util.Map<java.lang.String,java.lang.String> ret = delegate.deserializeObject(serialized);
    return ret;
  }

  public static ContainerDeserializer newInstance(io.vertx.ext.web.api.validation.ContainerDeserializer arg) {
    return arg != null ? new ContainerDeserializer(arg) : null;
  }

}
