/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.db2client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to DB2 server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.db2client.DB2Connection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.db2client.DB2Connection.class)
public class DB2Connection extends io.vertx.rxjava3.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DB2Connection that = (DB2Connection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DB2Connection> __TYPE_ARG = new TypeArg<>(    obj -> new DB2Connection((io.vertx.db2client.DB2Connection) obj),
    DB2Connection::getDelegate
  );

  private final io.vertx.db2client.DB2Connection delegate;
  
  public DB2Connection(io.vertx.db2client.DB2Connection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public DB2Connection(Object delegate) {
    super((io.vertx.db2client.DB2Connection)delegate);
    this.delegate = (io.vertx.db2client.DB2Connection)delegate;
  }

  public io.vertx.db2client.DB2Connection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to DB2 server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.db2client.DB2Connection> connect(io.vertx.rxjava3.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.db2client.DB2Connection> ret = rxConnect(vertx, connectOptions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Create a connection to DB2 server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.db2client.DB2Connection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.db2client.DB2Connection.connect(vertx.getDelegate(), connectOptions, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)event))));
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.db2client.DB2Connection#connect} with options build
   * from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.db2client.DB2Connection> connect(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.db2client.DB2Connection> ret = rxConnect(vertx, connectionUri);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.db2client.DB2Connection#connect} with options build
   * from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.db2client.DB2Connection> rxConnect(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri) { 
    return AsyncResultSingle.toSingle( handler -> {
      io.vertx.db2client.DB2Connection.connect(vertx.getDelegate(), connectionUri, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)event))));
    });
  }

  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> prepare(java.lang.String sql) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> ret = rxPrepare(sql);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.PreparedStatement> rxPrepare(java.lang.String sql) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.prepare(sql, new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  public io.vertx.rxjava3.db2client.DB2Connection exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.db2client.DB2Connection closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable ping() { 
    io.reactivex.rxjava3.core.Completable ret = rxPing();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxPing() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.ping(handler);
    });
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable debug() { 
    io.reactivex.rxjava3.core.Completable ret = rxDebug();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Completable rxDebug() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.debug(handler);
    });
  }

  /**
   * Cast a  to {@link io.vertx.rxjava3.db2client.DB2Connection}.
   *
   * This is mostly useful for Vert.x generated APIs like RxJava/Mutiny.
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.rxjava3.db2client.DB2Connection instance}
   */
  public static io.vertx.rxjava3.db2client.DB2Connection cast(io.vertx.rxjava3.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.rxjava3.db2client.DB2Connection ret = io.vertx.rxjava3.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)io.vertx.db2client.DB2Connection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static DB2Connection newInstance(io.vertx.db2client.DB2Connection arg) {
    return arg != null ? new DB2Connection(arg) : null;
  }

}
