/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.http;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an file upload from an HTML FORM.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerFileUpload original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpServerFileUpload.class)
public class HttpServerFileUpload implements io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerFileUpload that = (HttpServerFileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpServerFileUpload> __TYPE_ARG = new TypeArg<>(    obj -> new HttpServerFileUpload((io.vertx.core.http.HttpServerFileUpload) obj),
    HttpServerFileUpload::getDelegate
  );

  private final io.vertx.core.http.HttpServerFileUpload delegate;
  
  public HttpServerFileUpload(io.vertx.core.http.HttpServerFileUpload delegate) {
    this.delegate = delegate;
  }

  public HttpServerFileUpload(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServerFileUpload)delegate;
  }

  public io.vertx.core.http.HttpServerFileUpload getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.core.buffer.Buffer> observable;
  private io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.core.buffer.Buffer> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public io.vertx.rxjava3.core.http.HttpServerFileUpload exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.core.http.HttpServerFileUpload handler(io.vertx.core.Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.rxjava3.core.http.HttpServerFileUpload endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava3.core.http.HttpServerFileUpload pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.core.http.HttpServerFileUpload resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.core.http.HttpServerFileUpload fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * Stream the content of this upload to the given file on storage.
   * @param filename the name of the file
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable streamToFileSystem(java.lang.String filename) { 
    io.reactivex.rxjava3.core.Completable ret = rxStreamToFileSystem(filename);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Stream the content of this upload to the given file on storage.
   * @param filename the name of the file
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxStreamToFileSystem(java.lang.String filename) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.streamToFileSystem(filename, handler);
    });
  }

  /**
   * Try to cancel the file system streaming, the streamed file will be deleted.
   * @return <code>true</code> when the stream is cancelled, otherwise it means that stream is finished
   */
  public boolean cancelStreamToFileSystem() { 
    boolean ret = delegate.cancelStreamToFileSystem();
    return ret;
  }

  /**
   * @return the filename which was used when upload the file.
   */
  public java.lang.String filename() { 
    java.lang.String ret = delegate.filename();
    return ret;
  }

  /**
   * @return the name of the attribute
   */
  public java.lang.String name() { 
    java.lang.String ret = delegate.name();
    return ret;
  }

  /**
   * @return the content type for the upload
   */
  public java.lang.String contentType() { 
    java.lang.String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the contentTransferEncoding for the upload
   */
  public java.lang.String contentTransferEncoding() { 
    java.lang.String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset for the upload
   */
  public java.lang.String charset() { 
    java.lang.String ret = delegate.charset();
    return ret;
  }

  /**
   * The size of the upload may not be available until it is all read.
   * Check {@link io.vertx.rxjava3.core.http.HttpServerFileUpload#isSizeAvailable} to determine this
   * @return the size of the upload (in bytes)
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return <code>true</code> if the size of the upload can be retrieved via {@link io.vertx.rxjava3.core.http.HttpServerFileUpload#size}.
   */
  public boolean isSizeAvailable() { 
    boolean ret = delegate.isSizeAvailable();
    return ret;
  }

  /**
   * @return the async uploaded file when {@link io.vertx.rxjava3.core.http.HttpServerFileUpload#streamToFileSystem} has been used and the file is available
   */
  public io.vertx.rxjava3.core.file.AsyncFile file() { 
    io.vertx.rxjava3.core.file.AsyncFile ret = io.vertx.rxjava3.core.file.AsyncFile.newInstance((io.vertx.core.file.AsyncFile)delegate.file());
    return ret;
  }

  public static HttpServerFileUpload newInstance(io.vertx.core.http.HttpServerFileUpload arg) {
    return arg != null ? new HttpServerFileUpload(arg) : null;
  }

}
