/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.buffer;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Most data is shuffled around inside Vert.x using buffers.
 * <p>
 * A buffer is a sequence of zero or more bytes that can read from or written to and which expands automatically as
 * necessary to accommodate any bytes written to it. You can perhaps think of a buffer as smart byte array.
 * <p>
 * Please consult the documentation for more information on buffers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.buffer.Buffer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.buffer.Buffer.class)
public class Buffer implements io.vertx.core.shareddata.impl.ClusterSerializable {

  @Override
  public void writeToBuffer(io.vertx.core.buffer.Buffer buffer) {
    delegate.writeToBuffer(buffer);
  }

  @Override
  public int readFromBuffer(int pos, io.vertx.core.buffer.Buffer buffer) {
    return delegate.readFromBuffer(pos, buffer);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Buffer that = (Buffer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Buffer> __TYPE_ARG = new TypeArg<>(    obj -> new Buffer((io.vertx.core.buffer.Buffer) obj),
    Buffer::getDelegate
  );

  private final io.vertx.core.buffer.Buffer delegate;
  
  public Buffer(io.vertx.core.buffer.Buffer delegate) {
    this.delegate = delegate;
  }

  public Buffer(Object delegate) {
    this.delegate = (io.vertx.core.buffer.Buffer)delegate;
  }

  public io.vertx.core.buffer.Buffer getDelegate() {
    return delegate;
  }

  /**
   * Create a new, empty buffer.
   * @return the buffer
   */
  public static io.vertx.rxjava3.core.buffer.Buffer buffer() { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer());
    return ret;
  }

  /**
   * Create a new buffer given the initial size hint.
   * <p>
   * If you know the buffer will require a certain size, providing the hint can prevent unnecessary re-allocations
   * as the buffer is written to and resized.
   * @param initialSizeHint the hint, in bytes
   * @return the buffer
   */
  public static io.vertx.rxjava3.core.buffer.Buffer buffer(int initialSizeHint) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(initialSizeHint));
    return ret;
  }

  /**
   * Create a new buffer from a string. The string will be UTF-8 encoded into the buffer.
   * @param string the string
   * @return the buffer
   */
  public static io.vertx.rxjava3.core.buffer.Buffer buffer(java.lang.String string) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(string));
    return ret;
  }

  /**
   * Create a new buffer from a string and using the specified encoding.
   * The string will be encoded into the buffer using the specified encoding.
   * @param string the string
   * @param enc 
   * @return the buffer
   */
  public static io.vertx.rxjava3.core.buffer.Buffer buffer(java.lang.String string, java.lang.String enc) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(string, enc));
    return ret;
  }

  /**
   * Returns a <code>String</code> representation of the Buffer with the <code>UTF-8</code>encoding
   * @return 
   */
  public java.lang.String toString() { 
    java.lang.String ret = delegate.toString();
    return ret;
  }

  /**
   * Returns a <code>String</code> representation of the Buffer with the encoding specified by <code>enc</code>
   * @param enc 
   * @return 
   */
  public java.lang.String toString(java.lang.String enc) { 
    java.lang.String ret = delegate.toString(enc);
    return ret;
  }

  /**
   * Returns a Json object representation of the Buffer.
   * @return 
   */
  public io.vertx.core.json.JsonObject toJsonObject() { 
    io.vertx.core.json.JsonObject ret = delegate.toJsonObject();
    return ret;
  }

  /**
   * Returns a Json array representation of the Buffer.
   * @return 
   */
  public io.vertx.core.json.JsonArray toJsonArray() { 
    io.vertx.core.json.JsonArray ret = delegate.toJsonArray();
    return ret;
  }

  /**
   * Returns a Json representation of the Buffer.
   * @return a JSON element which can be a , , {@link java.lang.String}, ...etc if the buffer contains an array, object, string, ...etc
   */
  public java.lang.Object toJson() { 
    java.lang.Object ret = (Object) delegate.toJson();
    return ret;
  }

  /**
   * Returns the <code>byte</code> at position <code>pos</code> in the Buffer.
   * @param pos 
   * @return 
   */
  public byte getByte(int pos) { 
    byte ret = delegate.getByte(pos);
    return ret;
  }

  /**
   * Returns the unsigned <code>byte</code> at position <code>pos</code> in the Buffer, as a <code>short</code>.
   * @param pos 
   * @return 
   */
  public short getUnsignedByte(int pos) { 
    short ret = delegate.getUnsignedByte(pos);
    return ret;
  }

  /**
   * Returns the <code>int</code> at position <code>pos</code> in the Buffer.
   * @param pos 
   * @return 
   */
  public int getInt(int pos) { 
    int ret = delegate.getInt(pos);
    return ret;
  }

  /**
   * Gets a 32-bit integer at the specified absolute <code>index</code> in this buffer with Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public int getIntLE(int pos) { 
    int ret = delegate.getIntLE(pos);
    return ret;
  }

  /**
   * Returns the unsigned <code>int</code> at position <code>pos</code> in the Buffer, as a <code>long</code>.
   * @param pos 
   * @return 
   */
  public long getUnsignedInt(int pos) { 
    long ret = delegate.getUnsignedInt(pos);
    return ret;
  }

  /**
   * Returns the unsigned <code>int</code> at position <code>pos</code> in the Buffer, as a <code>long</code> in Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public long getUnsignedIntLE(int pos) { 
    long ret = delegate.getUnsignedIntLE(pos);
    return ret;
  }

  /**
   * Returns the <code>long</code> at position <code>pos</code> in the Buffer.
   * @param pos 
   * @return 
   */
  public long getLong(int pos) { 
    long ret = delegate.getLong(pos);
    return ret;
  }

  /**
   * Gets a 64-bit long integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public long getLongLE(int pos) { 
    long ret = delegate.getLongLE(pos);
    return ret;
  }

  /**
   * Returns the <code>double</code> at position <code>pos</code> in the Buffer.
   * @param pos 
   * @return 
   */
  public double getDouble(int pos) { 
    double ret = delegate.getDouble(pos);
    return ret;
  }

  /**
   * Returns the <code>float</code> at position <code>pos</code> in the Buffer.
   * @param pos 
   * @return 
   */
  public float getFloat(int pos) { 
    float ret = delegate.getFloat(pos);
    return ret;
  }

  /**
   * Returns the <code>short</code> at position <code>pos</code> in the Buffer.
   * @param pos 
   * @return 
   */
  public short getShort(int pos) { 
    short ret = delegate.getShort(pos);
    return ret;
  }

  /**
   * Gets a 16-bit short integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public short getShortLE(int pos) { 
    short ret = delegate.getShortLE(pos);
    return ret;
  }

  /**
   * Returns the unsigned <code>short</code> at position <code>pos</code> in the Buffer, as an <code>int</code>.
   * @param pos 
   * @return 
   */
  public int getUnsignedShort(int pos) { 
    int ret = delegate.getUnsignedShort(pos);
    return ret;
  }

  /**
   * Gets an unsigned 16-bit short integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public int getUnsignedShortLE(int pos) { 
    int ret = delegate.getUnsignedShortLE(pos);
    return ret;
  }

  /**
   * Gets a 24-bit medium integer at the specified absolute <code>index</code> in this buffer.
   * @param pos 
   * @return 
   */
  public int getMedium(int pos) { 
    int ret = delegate.getMedium(pos);
    return ret;
  }

  /**
   * Gets a 24-bit medium integer at the specified absolute <code>index</code> in this buffer in the Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public int getMediumLE(int pos) { 
    int ret = delegate.getMediumLE(pos);
    return ret;
  }

  /**
   * Gets an unsigned 24-bit medium integer at the specified absolute <code>index</code> in this buffer.
   * @param pos 
   * @return 
   */
  public int getUnsignedMedium(int pos) { 
    int ret = delegate.getUnsignedMedium(pos);
    return ret;
  }

  /**
   * Gets an unsigned 24-bit medium integer at the specified absolute <code>index</code> in this buffer in Little Endian Byte Order.
   * @param pos 
   * @return 
   */
  public int getUnsignedMediumLE(int pos) { 
    int ret = delegate.getUnsignedMediumLE(pos);
    return ret;
  }

  /**
   * Returns a copy of a sub-sequence the Buffer as a {@link io.vertx.rxjava3.core.buffer.Buffer} starting at position <code>start</code>
   * and ending at position <code>end - 1</code>
   * @param start 
   * @param end 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer getBuffer(int start, int end) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.getBuffer(start, end));
    return ret;
  }

  /**
   * Returns a copy of a sub-sequence the Buffer as a <code>String</code> starting at position <code>start</code>
   * and ending at position <code>end - 1</code> interpreted as a String in the specified encoding
   * @param start 
   * @param end 
   * @param enc 
   * @return 
   */
  public java.lang.String getString(int start, int end, java.lang.String enc) { 
    java.lang.String ret = delegate.getString(start, end, enc);
    return ret;
  }

  /**
   * Returns a copy of a sub-sequence the Buffer as a <code>String</code> starting at position <code>start</code>
   * and ending at position <code>end - 1</code> interpreted as a String in UTF-8 encoding
   * @param start 
   * @param end 
   * @return 
   */
  public java.lang.String getString(int start, int end) { 
    java.lang.String ret = delegate.getString(start, end);
    return ret;
  }

  /**
   * Appends the specified <code>Buffer</code> to the end of this Buffer. The buffer will expand as necessary to accommodate
   * any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param buff 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendBuffer(io.vertx.rxjava3.core.buffer.Buffer buff) { 
    delegate.appendBuffer(buff.getDelegate());
    return this;
  }

  /**
   * Appends the specified <code>Buffer</code> starting at the <code>offset</code> using <code>len</code> to the end of this Buffer. The buffer will expand as necessary to accommodate
   * any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param buff 
   * @param offset 
   * @param len 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendBuffer(io.vertx.rxjava3.core.buffer.Buffer buff, int offset, int len) { 
    delegate.appendBuffer(buff.getDelegate(), offset, len);
    return this;
  }

  /**
   * Appends the specified <code>byte</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendByte(byte b) { 
    delegate.appendByte(b);
    return this;
  }

  /**
   * Appends the specified unsigned <code>byte</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendUnsignedByte(short b) { 
    delegate.appendUnsignedByte(b);
    return this;
  }

  /**
   * Appends the specified <code>int</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendInt(int i) { 
    delegate.appendInt(i);
    return this;
  }

  /**
   * Appends the specified <code>int</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendIntLE(int i) { 
    delegate.appendIntLE(i);
    return this;
  }

  /**
   * Appends the specified unsigned <code>int</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendUnsignedInt(long i) { 
    delegate.appendUnsignedInt(i);
    return this;
  }

  /**
   * Appends the specified unsigned <code>int</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendUnsignedIntLE(long i) { 
    delegate.appendUnsignedIntLE(i);
    return this;
  }

  /**
   * Appends the specified 24bit <code>int</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendMedium(int i) { 
    delegate.appendMedium(i);
    return this;
  }

  /**
   * Appends the specified 24bit <code>int</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendMediumLE(int i) { 
    delegate.appendMediumLE(i);
    return this;
  }

  /**
   * Appends the specified <code>long</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param l 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendLong(long l) { 
    delegate.appendLong(l);
    return this;
  }

  /**
   * Appends the specified <code>long</code> to the end of the Buffer in the Little Endian Byte Order. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param l 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendLongLE(long l) { 
    delegate.appendLongLE(l);
    return this;
  }

  /**
   * Appends the specified <code>short</code> to the end of the Buffer.The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendShort(short s) { 
    delegate.appendShort(s);
    return this;
  }

  /**
   * Appends the specified <code>short</code> to the end of the Buffer in the Little Endian Byte Order.The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendShortLE(short s) { 
    delegate.appendShortLE(s);
    return this;
  }

  /**
   * Appends the specified unsigned <code>short</code> to the end of the Buffer.The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendUnsignedShort(int s) { 
    delegate.appendUnsignedShort(s);
    return this;
  }

  /**
   * Appends the specified unsigned <code>short</code> to the end of the Buffer in the Little Endian Byte Order.The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendUnsignedShortLE(int s) { 
    delegate.appendUnsignedShortLE(s);
    return this;
  }

  /**
   * Appends the specified <code>float</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param f 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendFloat(float f) { 
    delegate.appendFloat(f);
    return this;
  }

  /**
   * Appends the specified <code>double</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param d 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendDouble(double d) { 
    delegate.appendDouble(d);
    return this;
  }

  /**
   * Appends the specified <code>String</code> to the end of the Buffer with the encoding as specified by <code>enc</code>.<p>
   * The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.<p>
   * @param str 
   * @param enc 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendString(java.lang.String str, java.lang.String enc) { 
    delegate.appendString(str, enc);
    return this;
  }

  /**
   * Appends the specified <code>String str</code> to the end of the Buffer with UTF-8 encoding.<p>
   * The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together<p>
   * @param str 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendString(java.lang.String str) { 
    delegate.appendString(str);
    return this;
  }

  /**
   * Sets the <code>byte</code> at position <code>pos</code> in the Buffer to the value <code>b</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setByte(int pos, byte b) { 
    delegate.setByte(pos, b);
    return this;
  }

  /**
   * Sets the unsigned <code>byte</code> at position <code>pos</code> in the Buffer to the value <code>b</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setUnsignedByte(int pos, short b) { 
    delegate.setUnsignedByte(pos, b);
    return this;
  }

  /**
   * Sets the <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setInt(int pos, int i) { 
    delegate.setInt(pos, i);
    return this;
  }

  /**
   * Sets the <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code> in the Little Endian Byte Order.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setIntLE(int pos, int i) { 
    delegate.setIntLE(pos, i);
    return this;
  }

  /**
   * Sets the unsigned <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setUnsignedInt(int pos, long i) { 
    delegate.setUnsignedInt(pos, i);
    return this;
  }

  /**
   * Sets the unsigned <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code> in the Little Endian Byte Order.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setUnsignedIntLE(int pos, long i) { 
    delegate.setUnsignedIntLE(pos, i);
    return this;
  }

  /**
   * Sets the 24bit <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setMedium(int pos, int i) { 
    delegate.setMedium(pos, i);
    return this;
  }

  /**
   * Sets the 24bit <code>int</code> at position <code>pos</code> in the Buffer to the value <code>i</code>. in the Little Endian Byte Order<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param i 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setMediumLE(int pos, int i) { 
    delegate.setMediumLE(pos, i);
    return this;
  }

  /**
   * Sets the <code>long</code> at position <code>pos</code> in the Buffer to the value <code>l</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param l 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setLong(int pos, long l) { 
    delegate.setLong(pos, l);
    return this;
  }

  /**
   * Sets the <code>long</code> at position <code>pos</code> in the Buffer to the value <code>l</code> in the Little Endian Byte Order.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param l 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setLongLE(int pos, long l) { 
    delegate.setLongLE(pos, l);
    return this;
  }

  /**
   * Sets the <code>double</code> at position <code>pos</code> in the Buffer to the value <code>d</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param d 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setDouble(int pos, double d) { 
    delegate.setDouble(pos, d);
    return this;
  }

  /**
   * Sets the <code>float</code> at position <code>pos</code> in the Buffer to the value <code>f</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param f 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setFloat(int pos, float f) { 
    delegate.setFloat(pos, f);
    return this;
  }

  /**
   * Sets the <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setShort(int pos, short s) { 
    delegate.setShort(pos, s);
    return this;
  }

  /**
   * Sets the <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code> in the Little Endian Byte Order.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setShortLE(int pos, short s) { 
    delegate.setShortLE(pos, s);
    return this;
  }

  /**
   * Sets the unsigned <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setUnsignedShort(int pos, int s) { 
    delegate.setUnsignedShort(pos, s);
    return this;
  }

  /**
   * Sets the unsigned <code>short</code> at position <code>pos</code> in the Buffer to the value <code>s</code> in the Little Endian Byte Order.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param s 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setUnsignedShortLE(int pos, int s) { 
    delegate.setUnsignedShortLE(pos, s);
    return this;
  }

  /**
   * Sets the bytes at position <code>pos</code> in the Buffer to the bytes represented by the <code>Buffer b</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setBuffer(int pos, io.vertx.rxjava3.core.buffer.Buffer b) { 
    delegate.setBuffer(pos, b.getDelegate());
    return this;
  }

  /**
   * Sets the bytes at position <code>pos</code> in the Buffer to the bytes represented by the <code>Buffer b</code> on the given <code>offset</code> and <code>len</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @param offset 
   * @param len 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setBuffer(int pos, io.vertx.rxjava3.core.buffer.Buffer b, int offset, int len) { 
    delegate.setBuffer(pos, b.getDelegate(), offset, len);
    return this;
  }

  /**
   * Sets the bytes at position <code>pos</code> in the Buffer to the value of <code>str</code> encoded in UTF-8.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param str 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setString(int pos, java.lang.String str) { 
    delegate.setString(pos, str);
    return this;
  }

  /**
   * Sets the bytes at position <code>pos</code> in the Buffer to the value of <code>str</code> encoded in encoding <code>enc</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param str 
   * @param enc 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setString(int pos, java.lang.String str, java.lang.String enc) { 
    delegate.setString(pos, str, enc);
    return this;
  }

  /**
   * Returns the length of the buffer, measured in bytes.
   * All positions are indexed from zero.
   * @return 
   */
  public int length() { 
    int ret = delegate.length();
    return ret;
  }

  /**
   * Returns a copy of the entire Buffer.
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer copy() { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.copy());
    return ret;
  }

  /**
   * Returns a slice of this buffer. Modifying the content
   * of the returned buffer or this buffer affects each other's content
   * while they maintain separate indexes and marks.
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer slice() { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.slice());
    return ret;
  }

  /**
   * Returns a slice of this buffer. Modifying the content
   * of the returned buffer or this buffer affects each other's content
   * while they maintain separate indexes and marks.
   * @param start 
   * @param end 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer slice(int start, int end) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.slice(start, end));
    return ret;
  }

  /**
   * Create a new buffer from a byte[]. The byte[] will be copied to form the buffer.
   * @param bytes the byte array
   * @return the buffer
   */
  public static io.vertx.rxjava3.core.buffer.Buffer buffer(byte[] bytes) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(bytes));
    return ret;
  }

  /**
   * <p>
   * Create a new buffer from a Netty <code>ByteBuf</code>.
   * <i>Note that</i> the returned buffer is backed by given Netty ByteBuf,
   * so changes in the returned buffer are reflected in given Netty ByteBuf, and vice-versa.
   * </p>
   * <p>
   * For example, both buffers in the code below share their data:
   * </p>
   * <pre>
   *   Buffer src = Buffer.buffer();
   *   Buffer clone = Buffer.buffer(src.getByteBuf());
   * </pre>
   * @param byteBuf the Netty ByteBuf
   * @return the buffer
   */
  @Deprecated()
  public static io.vertx.rxjava3.core.buffer.Buffer buffer(io.netty.buffer.ByteBuf byteBuf) { 
    io.vertx.rxjava3.core.buffer.Buffer ret = io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)io.vertx.core.buffer.Buffer.buffer(byteBuf));
    return ret;
  }

  /**
   * Returns a <code>String</code> representation of the Buffer with the encoding specified by <code>enc</code>
   * @param enc 
   * @return 
   */
  public java.lang.String toString(java.nio.charset.Charset enc) { 
    java.lang.String ret = delegate.toString(enc);
    return ret;
  }

  /**
   * Returns a copy of the entire Buffer as a <code>byte[]</code>
   * @return 
   */
  public byte[] getBytes() { 
    byte[] ret = delegate.getBytes();
    return ret;
  }

  /**
   * Returns a copy of a sub-sequence the Buffer as a <code>byte[]</code> starting at position <code>start</code>
   * and ending at position <code>end - 1</code>
   * @param start 
   * @param end 
   * @return 
   */
  public byte[] getBytes(int start, int end) { 
    byte[] ret = delegate.getBytes(start, end);
    return ret;
  }

  /**
   * Transfers the content of the Buffer into a <code>byte[]</code>.
   * @param dst the destination byte array
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer getBytes(byte[] dst) { 
    delegate.getBytes(dst);
    return this;
  }

  /**
   * Transfers the content of the Buffer into a <code>byte[]</code> at the specific destination.
   * @param dst the destination byte array
   * @param dstIndex 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer getBytes(byte[] dst, int dstIndex) { 
    delegate.getBytes(dst, dstIndex);
    return this;
  }

  /**
   * Transfers the content of the Buffer starting at position <code>start</code> and ending at position <code>end - 1</code>
   * into a <code>byte[]</code>.
   * @param start 
   * @param end 
   * @param dst the destination byte array
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer getBytes(int start, int end, byte[] dst) { 
    delegate.getBytes(start, end, dst);
    return this;
  }

  /**
   * Transfers the content of the Buffer starting at position <code>start</code> and ending at position <code>end - 1</code>
   * into a <code>byte[]</code> at the specific destination.
   * @param start 
   * @param end 
   * @param dst the destination byte array
   * @param dstIndex 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer getBytes(int start, int end, byte[] dst, int dstIndex) { 
    delegate.getBytes(start, end, dst, dstIndex);
    return this;
  }

  /**
   * Appends the specified <code>byte[]</code> to the end of the Buffer. The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param bytes 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendBytes(byte[] bytes) { 
    delegate.appendBytes(bytes);
    return this;
  }

  /**
   * Appends the specified number of bytes from <code>byte[]</code> to the end of the Buffer, starting at the given offset.
   * The buffer will expand as necessary to accommodate any bytes written.<p>
   * Returns a reference to <code>this</code> so multiple operations can be appended together.
   * @param bytes 
   * @param offset 
   * @param len 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer appendBytes(byte[] bytes, int offset, int len) { 
    delegate.appendBytes(bytes, offset, len);
    return this;
  }

  /**
   * Sets the bytes at position <code>pos</code> in the Buffer to the bytes represented by the <code>ByteBuffer b</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setBytes(int pos, java.nio.ByteBuffer b) { 
    delegate.setBytes(pos, b);
    return this;
  }

  /**
   * Sets the bytes at position <code>pos</code> in the Buffer to the bytes represented by the <code>byte[] b</code>.<p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setBytes(int pos, byte[] b) { 
    delegate.setBytes(pos, b);
    return this;
  }

  /**
   * Sets the given number of bytes at position <code>pos</code> in the Buffer to the bytes represented by the <code>byte[] b</code>.<p></p>
   * The buffer will expand as necessary to accommodate any value written.
   * @param pos 
   * @param b 
   * @param offset 
   * @param len 
   * @return 
   */
  public io.vertx.rxjava3.core.buffer.Buffer setBytes(int pos, byte[] b, int offset, int len) { 
    delegate.setBytes(pos, b, offset, len);
    return this;
  }

  /**
   * Returns the Buffer as a Netty <code>ByteBuf</code>.
   *
   * <p> The returned buffer is a duplicate that maintain its own indices.
   * @return 
   */
  @Deprecated()
  public io.netty.buffer.ByteBuf getByteBuf() { 
    io.netty.buffer.ByteBuf ret = delegate.getByteBuf();
    return ret;
  }

  public static Buffer newInstance(io.vertx.core.buffer.Buffer arg) {
    return arg != null ? new Buffer(arg) : null;
  }

}
