/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.oracleclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a pool of connection to interact with an Oracle database.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OraclePool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.oracleclient.OraclePool.class)
public class OraclePool extends io.vertx.rxjava3.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OraclePool that = (OraclePool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OraclePool> __TYPE_ARG = new TypeArg<>(    obj -> new OraclePool((io.vertx.oracleclient.OraclePool) obj),
    OraclePool::getDelegate
  );

  private final io.vertx.oracleclient.OraclePool delegate;
  
  public OraclePool(io.vertx.oracleclient.OraclePool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OraclePool(Object delegate) {
    super((io.vertx.oracleclient.OraclePool)delegate);
    this.delegate = (io.vertx.oracleclient.OraclePool)delegate;
  }

  public io.vertx.oracleclient.OraclePool getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava3.oracleclient.OraclePool pool(io.vertx.oracleclient.OracleConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.oracleclient.OraclePool ret = io.vertx.rxjava3.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.oracleclient.OraclePool#pool} with a specific  instance.
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.oracleclient.OraclePool pool(io.vertx.rxjava3.core.Vertx vertx, io.vertx.oracleclient.OracleConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.oracleclient.OraclePool ret = io.vertx.rxjava3.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.oracleclient.OraclePool#pool} but connection options are created from the provided <code>connectionUri</code>.
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.oracleclient.OraclePool pool(java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.oracleclient.OraclePool ret = io.vertx.rxjava3.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.oracleclient.OraclePool#pool} with a specific  instance.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava3.oracleclient.OraclePool pool(io.vertx.rxjava3.core.Vertx vertx, java.lang.String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava3.oracleclient.OraclePool ret = io.vertx.rxjava3.oracleclient.OraclePool.newInstance((io.vertx.oracleclient.OraclePool)io.vertx.oracleclient.OraclePool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  public io.vertx.rxjava3.oracleclient.OraclePool connectHandler(io.vertx.core.Handler<io.vertx.rxjava3.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava3.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.rxjava3.oracleclient.OraclePool connectionProvider(java.util.function.Function<io.vertx.rxjava3.core.Context,io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.sqlclient.SqlConnection> ret = provider.apply(io.vertx.rxjava3.core.Context.newInstance((io.vertx.core.Context)arg));
        return io.vertx.rxjava3.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  public static OraclePool newInstance(io.vertx.oracleclient.OraclePool arg) {
    return arg != null ? new OraclePool(arg) : null;
  }

}
