/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mysqlclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An interface to define MySQL specific constants or behaviors.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mysqlclient.MySQLClient.class)
public class MySQLClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLClient that = (MySQLClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MySQLClient> __TYPE_ARG = new TypeArg<>(    obj -> new MySQLClient((io.vertx.mysqlclient.MySQLClient) obj),
    MySQLClient::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLClient delegate;
  
  public MySQLClient(io.vertx.mysqlclient.MySQLClient delegate) {
    this.delegate = delegate;
  }

  public MySQLClient(Object delegate) {
    this.delegate = (io.vertx.mysqlclient.MySQLClient)delegate;
  }

  public io.vertx.mysqlclient.MySQLClient getDelegate() {
    return delegate;
  }

  /**
   * SqlResult  for MySQL last_insert_id.<br>
   * The property kind can be used to fetch the auto incremented id of the last row when executing inserting or updating operations.
   * The property name is <code>last-inserted-id</code>.
   */
  public static final io.vertx.rxjava3.sqlclient.PropertyKind<java.lang.Long> LAST_INSERTED_ID = io.vertx.rxjava3.sqlclient.PropertyKind.newInstance((io.vertx.sqlclient.PropertyKind)io.vertx.mysqlclient.MySQLClient.LAST_INSERTED_ID, TypeArg.unknown());
  public static MySQLClient newInstance(io.vertx.mysqlclient.MySQLClient arg) {
    return arg != null ? new MySQLClient(arg) : null;
  }

}
