/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating OAuth2 based {@link io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.OAuth2Auth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth extends io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2Auth that = (OAuth2Auth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg<>(    obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth) obj),
    OAuth2Auth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;
  
  public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OAuth2Auth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
  }

  public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2 auth provider.
   * @param vertx the Vertx instance
   * @return the auth provider
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @param config the config
   * @return the auth provider
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2Options config) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Retrieve the public server JSON Web Key (JWK) required to verify the authenticity
   * of issued ID and access tokens. The provider will refresh the keys according to:
   * https://openid.net/specs/openid-connect-core-1_0.html#RotateEncKeys
   *
   * This means that the provider will look at the cache headers and will refresh when
   * the max-age is reached. If the server does not return any cache headers it shall
   * be up to the end user to call this method to refresh.
   *
   * To avoid the refresh to happen too late, this means that they keys will be invalid,
   * if the {@link io.vertx.ext.auth.oauth2.OAuth2Options} {@link io.vertx.ext.auth.JWTOptions} config contains a
   * positive leeway, it will be used to request the refresh ahead of time.
   *
   * Key rotation can be controled by {@link io.vertx.ext.auth.oauth2.OAuth2Options}.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Completable jWKSet() { 
    io.reactivex.rxjava3.core.Completable ret = rxJWKSet();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Retrieve the public server JSON Web Key (JWK) required to verify the authenticity
   * of issued ID and access tokens. The provider will refresh the keys according to:
   * https://openid.net/specs/openid-connect-core-1_0.html#RotateEncKeys
   *
   * This means that the provider will look at the cache headers and will refresh when
   * the max-age is reached. If the server does not return any cache headers it shall
   * be up to the end user to call this method to refresh.
   *
   * To avoid the refresh to happen too late, this means that they keys will be invalid,
   * if the {@link io.vertx.ext.auth.oauth2.OAuth2Options} {@link io.vertx.ext.auth.JWTOptions} config contains a
   * positive leeway, it will be used to request the refresh ahead of time.
   *
   * Key rotation can be controled by {@link io.vertx.ext.auth.oauth2.OAuth2Options}.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Completable rxJWKSet() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.jWKSet(handler);
    });
  }

  /**
   * Handled to be called when a key (mentioned on a JWT) is missing from the current config.
   * Users are advised to call {@link io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth#jWKSet} but being careful to implement
   * some rate limiting function.
   *
   * This method isn't generic for several reasons. The provider is not aware of the capabilities
   * of the backend IdP in terms of max allowed API calls. Some validation could be done at the
   * key id, which only the end user is aware of.
   *
   * A base implementation for this handler is:
   *
   * <pre><code>// are we already updating the jwks?
   private final AtomicBoolean updating = new AtomicBoolean(false);

   // default missing key handler, will try to reload with debounce
   oauth2.missingKeyHandler(keyId -> {
     if (updating.compareAndSet(false, true)) {
       // Refreshing JWKs due missing key
       jWKSet(done -> {
         updating.compareAndSet(true, false);
         if (done.failed()) {
           done.cause().printStackTrace();</code>
   *       });
   *     }
   *   });
   * }</pre>
   *
   * This handler will purely debounce calls and allow only a single request to {@link io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth#jWKSet}
   * at a time. No special handling is done to avoid requests on wrong key ids or prevent to many
   * requests to the IdP server. Users should probably also account for the number of errors to
   * present DDoS the IdP.
   * @param handler 
   * @return Future result.
   */
  public io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth missingKeyHandler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.missingKeyHandler(handler);
    return this;
  }

  /**
   * The client sends the end-user's browser to this endpoint to request their
   * authentication and consent. This endpoint is used in the code and implicit
   * OAuth 2.0 flows which require end-user interaction.
   * @param params extra params to be included in the final URL.
   * @return the url to be used to authorize the user.
   */
  public java.lang.String authorizeURL(io.vertx.core.json.JsonObject params) { 
    java.lang.String ret = delegate.authorizeURL(params);
    return ret;
  }

  /**
   * Refresh the current User (access token).
   * @param user the user (access token) to be refreshed.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.User> refresh(io.vertx.rxjava3.ext.auth.User user) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.User> ret = rxRefresh(user);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Refresh the current User (access token).
   * @param user the user (access token) to be refreshed.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.User> rxRefresh(io.vertx.rxjava3.ext.auth.User user) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.refresh(user.getDelegate(), new io.vertx.lang.rx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.rxjava3.ext.auth.User.newInstance((io.vertx.ext.auth.User)event))));
    });
  }

  /**
   * Revoke an obtained access or refresh token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
   * @param user the user (access token) to revoke.
   * @param tokenType the token type (either access_token or refresh_token).
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Completable revoke(io.vertx.rxjava3.ext.auth.User user, java.lang.String tokenType) { 
    io.reactivex.rxjava3.core.Completable ret = rxRevoke(user, tokenType);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Revoke an obtained access or refresh token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
   * @param user the user (access token) to revoke.
   * @param tokenType the token type (either access_token or refresh_token).
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Completable rxRevoke(io.vertx.rxjava3.ext.auth.User user, java.lang.String tokenType) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.revoke(user.getDelegate(), tokenType, handler);
    });
  }

  /**
   * Revoke an obtained access token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
   * @param user the user (access token) to revoke.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Completable revoke(io.vertx.rxjava3.ext.auth.User user) { 
    io.reactivex.rxjava3.core.Completable ret = rxRevoke(user);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Revoke an obtained access token. More info <a href="https://tools.ietf.org/html/rfc7009">https://tools.ietf.org/html/rfc7009</a>.
   * @param user the user (access token) to revoke.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Completable rxRevoke(io.vertx.rxjava3.ext.auth.User user) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.revoke(user.getDelegate(), handler);
    });
  }

  /**
   * Retrieve profile information and other attributes for a logged-in end-user. More info <a href="https://openid.net/specs/openid-connect-core-1_0.html#UserInfo">https://openid.net/specs/openid-connect-core-1_0.html#UserInfo</a>
   * @param user the user (access token) to fetch the user info.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.core.json.JsonObject> userInfo(io.vertx.rxjava3.ext.auth.User user) { 
    io.reactivex.rxjava3.core.Single<io.vertx.core.json.JsonObject> ret = rxUserInfo(user);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Retrieve profile information and other attributes for a logged-in end-user. More info <a href="https://openid.net/specs/openid-connect-core-1_0.html#UserInfo">https://openid.net/specs/openid-connect-core-1_0.html#UserInfo</a>
   * @param user the user (access token) to fetch the user info.
   * @return fluent self.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.core.json.JsonObject> rxUserInfo(io.vertx.rxjava3.ext.auth.User user) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.userInfo(user.getDelegate(), handler);
    });
  }

  /**
   * The logout (end-session) endpoint is specified in OpenID Connect Session Management 1.0.
   * More info: <a href="https://openid.net/specs/openid-connect-session-1_0.html">https://openid.net/specs/openid-connect-session-1_0.html</a>.
   * @param user the user to generate the url for
   * @param params extra parameters to apply to the url
   * @return the url to end the session.
   */
  public java.lang.String endSessionURL(io.vertx.rxjava3.ext.auth.User user, io.vertx.core.json.JsonObject params) { 
    java.lang.String ret = delegate.endSessionURL(user.getDelegate(), params);
    return ret;
  }

  /**
   * The logout (end-session) endpoint is specified in OpenID Connect Session Management 1.0.
   * More info: <a href="https://openid.net/specs/openid-connect-session-1_0.html">https://openid.net/specs/openid-connect-session-1_0.html</a>.
   * @param user the user to generate the url for
   * @return the url to end the session.
   */
  public java.lang.String endSessionURL(io.vertx.rxjava3.ext.auth.User user) { 
    java.lang.String ret = delegate.endSessionURL(user.getDelegate());
    return ret;
  }

  /**
   * Releases any resources or timers used by this instance. Users are expected to call this method when the provider
   * isn't needed any more to return the used resources back to the platform.
   */
  public void close() { 
    delegate.close();
  }

  public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
    return arg != null ? new OAuth2Auth(arg) : null;
  }

}
