/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An executor for executing blocking code in Vert.x .<p>
 *
 * It provides the same <code>executeBlocking</code> operation than {@link io.vertx.rxjava3.core.Context} and
 * {@link io.vertx.rxjava3.core.Vertx} but on a separate worker pool.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.WorkerExecutor original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor implements io.vertx.rxjava3.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WorkerExecutor that = (WorkerExecutor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WorkerExecutor> __TYPE_ARG = new TypeArg<>(    obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor) obj),
    WorkerExecutor::getDelegate
  );

  private final io.vertx.core.WorkerExecutor delegate;
  
  public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
    this.delegate = delegate;
  }

  public WorkerExecutor(Object delegate) {
    this.delegate = (io.vertx.core.WorkerExecutor)delegate;
  }

  public io.vertx.core.WorkerExecutor getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava3.core.Promise#complete} or {@link io.vertx.rxjava3.core.Promise#complete} method, or the {@link io.vertx.rxjava3.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> executeBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    io.reactivex.rxjava3.core.Maybe<T> ret = rxExecuteBlocking(blockingCodeHandler, ordered);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava3.core.Promise#complete} or {@link io.vertx.rxjava3.core.Promise#complete} method, or the {@link io.vertx.rxjava3.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> rxExecuteBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return AsyncResultMaybe.toMaybe( resultHandler -> {
      delegate.executeBlocking(new io.vertx.lang.rx.DelegatingHandler<>(blockingCodeHandler, event -> io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), ordered, resultHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> executeBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler) { 
    io.reactivex.rxjava3.core.Maybe<T> ret = rxExecuteBlocking(blockingCodeHandler);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> rxExecuteBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler) { 
    return AsyncResultMaybe.toMaybe( resultHandler -> {
      delegate.executeBlocking(new io.vertx.lang.rx.DelegatingHandler<>(blockingCodeHandler, event -> io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), resultHandler);
    });
  }

  /**
   * Close the executor.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the executor.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  public static WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
    return arg != null ? new WorkerExecutor(arg) : null;
  }

}
