/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The entry point into the Vert.x Core API.
 * <p>
 * You use an instance of this class for functionality including:
 * <ul>
 *   <li>Creating TCP clients and servers</li>
 *   <li>Creating HTTP clients and servers</li>
 *   <li>Creating DNS clients</li>
 *   <li>Creating Datagram sockets</li>
 *   <li>Setting and cancelling periodic and one-shot timers</li>
 *   <li>Getting a reference to the event bus API</li>
 *   <li>Getting a reference to the file system API</li>
 *   <li>Getting a reference to the shared data API</li>
 *   <li>Deploying and undeploying verticles</li>
 * </ul>
 * <p>
 * Most functionality in Vert.x core is fairly low level.
 * <p>
 * To create an instance of this class you can use the static factory methods: {@link io.vertx.rxjava3.core.Vertx#vertx},
 * {@link io.vertx.rxjava3.core.Vertx#vertx} and {@link io.vertx.rxjava3.core.Vertx#clusteredVertx}.
 * <p>
 * Please see the user manual for more detailed usage information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Vertx original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.Vertx.class)
public class Vertx implements io.vertx.rxjava3.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Vertx that = (Vertx) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Vertx> __TYPE_ARG = new TypeArg<>(    obj -> new Vertx((io.vertx.core.Vertx) obj),
    Vertx::getDelegate
  );

  private final io.vertx.core.Vertx delegate;
  
  public Vertx(io.vertx.core.Vertx delegate) {
    this.delegate = delegate;
  }

  public Vertx(Object delegate) {
    this.delegate = (io.vertx.core.Vertx)delegate;
  }

  public io.vertx.core.Vertx getDelegate() {
    return delegate;
  }


  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Creates a non clustered instance using default options.
   * @return the instance
   */
  public static io.vertx.rxjava3.core.Vertx vertx() { 
    io.vertx.rxjava3.core.Vertx ret = io.vertx.rxjava3.core.Vertx.newInstance((io.vertx.core.Vertx)io.vertx.core.Vertx.vertx());
    return ret;
  }

  /**
   * Creates a non clustered instance using the specified options
   * @param options the options to use
   * @return the instance
   */
  public static io.vertx.rxjava3.core.Vertx vertx(io.vertx.core.VertxOptions options) { 
    io.vertx.rxjava3.core.Vertx ret = io.vertx.rxjava3.core.Vertx.newInstance((io.vertx.core.Vertx)io.vertx.core.Vertx.vertx(options));
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.Vertx> clusteredVertx(io.vertx.core.VertxOptions options) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.Vertx> ret = rxClusteredVertx(options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a clustered instance using the specified options.
   * <p>
   * The instance is created asynchronously and the resultHandler is called with the result when it is ready.
   * @param options the options to use
   * @return 
   */
  public static io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.Vertx> rxClusteredVertx(io.vertx.core.VertxOptions options) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      io.vertx.core.Vertx.clusteredVertx(options, new io.vertx.lang.rx.DelegatingHandler<>(resultHandler, ar -> ar.map(event -> io.vertx.rxjava3.core.Vertx.newInstance((io.vertx.core.Vertx)event))));
    });
  }

  /**
   * Gets the current context
   * @return The current context or <code>null</code> if there is no current context
   */
  public static io.vertx.rxjava3.core.Context currentContext() { 
    io.vertx.rxjava3.core.Context ret = io.vertx.rxjava3.core.Context.newInstance((io.vertx.core.Context)io.vertx.core.Vertx.currentContext());
    return ret;
  }

  /**
   * Gets the current context, or creates one if there isn't one
   * @return The current context (created if didn't exist)
   */
  public io.vertx.rxjava3.core.Context getOrCreateContext() { 
    io.vertx.rxjava3.core.Context ret = io.vertx.rxjava3.core.Context.newInstance((io.vertx.core.Context)delegate.getOrCreateContext());
    return ret;
  }

  /**
   * Create a TCP/SSL server using the specified options
   * @param options the options to use
   * @return the server
   */
  public io.vertx.rxjava3.core.net.NetServer createNetServer(io.vertx.core.net.NetServerOptions options) { 
    io.vertx.rxjava3.core.net.NetServer ret = io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.createNetServer(options));
    return ret;
  }

  /**
   * Create a TCP/SSL server using default options
   * @return the server
   */
  public io.vertx.rxjava3.core.net.NetServer createNetServer() { 
    io.vertx.rxjava3.core.net.NetServer ret = io.vertx.rxjava3.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.createNetServer());
    return ret;
  }

  /**
   * Create a TCP/SSL client using the specified options
   * @param options the options to use
   * @return the client
   */
  public io.vertx.rxjava3.core.net.NetClient createNetClient(io.vertx.core.net.NetClientOptions options) { 
    io.vertx.rxjava3.core.net.NetClient ret = io.vertx.rxjava3.core.net.NetClient.newInstance((io.vertx.core.net.NetClient)delegate.createNetClient(options));
    return ret;
  }

  /**
   * Create a TCP/SSL client using default options
   * @return the client
   */
  public io.vertx.rxjava3.core.net.NetClient createNetClient() { 
    io.vertx.rxjava3.core.net.NetClient ret = io.vertx.rxjava3.core.net.NetClient.newInstance((io.vertx.core.net.NetClient)delegate.createNetClient());
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using the specified options
   * @param options the options to use
   * @return the server
   */
  public io.vertx.rxjava3.core.http.HttpServer createHttpServer(io.vertx.core.http.HttpServerOptions options) { 
    io.vertx.rxjava3.core.http.HttpServer ret = io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.createHttpServer(options));
    return ret;
  }

  /**
   * Create an HTTP/HTTPS server using default options
   * @return the server
   */
  public io.vertx.rxjava3.core.http.HttpServer createHttpServer() { 
    io.vertx.rxjava3.core.http.HttpServer ret = io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.createHttpServer());
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using the specified options
   * @param options the options to use
   * @return the client
   */
  public io.vertx.rxjava3.core.http.HttpClient createHttpClient(io.vertx.core.http.HttpClientOptions options) { 
    io.vertx.rxjava3.core.http.HttpClient ret = io.vertx.rxjava3.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)delegate.createHttpClient(options));
    return ret;
  }

  /**
   * Create a HTTP/HTTPS client using default options
   * @return the client
   */
  public io.vertx.rxjava3.core.http.HttpClient createHttpClient() { 
    io.vertx.rxjava3.core.http.HttpClient ret = io.vertx.rxjava3.core.http.HttpClient.newInstance((io.vertx.core.http.HttpClient)delegate.createHttpClient());
    return ret;
  }

  /**
   * Create a datagram socket using the specified options
   * @param options the options to use
   * @return the socket
   */
  public io.vertx.rxjava3.core.datagram.DatagramSocket createDatagramSocket(io.vertx.core.datagram.DatagramSocketOptions options) { 
    io.vertx.rxjava3.core.datagram.DatagramSocket ret = io.vertx.rxjava3.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)delegate.createDatagramSocket(options));
    return ret;
  }

  /**
   * Create a datagram socket using default options
   * @return the socket
   */
  public io.vertx.rxjava3.core.datagram.DatagramSocket createDatagramSocket() { 
    io.vertx.rxjava3.core.datagram.DatagramSocket ret = io.vertx.rxjava3.core.datagram.DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)delegate.createDatagramSocket());
    return ret;
  }

  /**
   * Get the filesystem object. There is a single instance of FileSystem per Vertx instance.
   * @return the filesystem object
   */
  public io.vertx.rxjava3.core.file.FileSystem fileSystem() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.core.file.FileSystem ret = io.vertx.rxjava3.core.file.FileSystem.newInstance((io.vertx.core.file.FileSystem)delegate.fileSystem());
    cached_0 = ret;
    return ret;
  }

  /**
   * Get the event bus object. There is a single instance of EventBus per Vertx instance.
   * @return the event bus object
   */
  public io.vertx.rxjava3.core.eventbus.EventBus eventBus() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.core.eventbus.EventBus ret = io.vertx.rxjava3.core.eventbus.EventBus.newInstance((io.vertx.core.eventbus.EventBus)delegate.eventBus());
    cached_1 = ret;
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server at the specified host and port, with the default query timeout (5 seconds)
   * <p/>
   * @param port the port
   * @param host the host
   * @return the DNS client
   */
  public io.vertx.rxjava3.core.dns.DnsClient createDnsClient(int port, java.lang.String host) { 
    io.vertx.rxjava3.core.dns.DnsClient ret = io.vertx.rxjava3.core.dns.DnsClient.newInstance((io.vertx.core.dns.DnsClient)delegate.createDnsClient(port, host));
    return ret;
  }

  /**
   * Create a DNS client to connect to the DNS server configured by {@link io.vertx.core.VertxOptions}
   * <p>
   * DNS client takes the first configured resolver address provided by }
   * @return the DNS client
   */
  public io.vertx.rxjava3.core.dns.DnsClient createDnsClient() { 
    io.vertx.rxjava3.core.dns.DnsClient ret = io.vertx.rxjava3.core.dns.DnsClient.newInstance((io.vertx.core.dns.DnsClient)delegate.createDnsClient());
    return ret;
  }

  /**
   * Create a DNS client to connect to a DNS server
   * @param options the client options
   * @return the DNS client
   */
  public io.vertx.rxjava3.core.dns.DnsClient createDnsClient(io.vertx.core.dns.DnsClientOptions options) { 
    io.vertx.rxjava3.core.dns.DnsClient ret = io.vertx.rxjava3.core.dns.DnsClient.newInstance((io.vertx.core.dns.DnsClient)delegate.createDnsClient(options));
    return ret;
  }

  /**
   * Get the shared data object. There is a single instance of SharedData per Vertx instance.
   * @return the shared data object
   */
  public io.vertx.rxjava3.core.shareddata.SharedData sharedData() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.rxjava3.core.shareddata.SharedData ret = io.vertx.rxjava3.core.shareddata.SharedData.newInstance((io.vertx.core.shareddata.SharedData)delegate.sharedData());
    cached_2 = ret;
    return ret;
  }

  /**
   * Set a one-shot timer to fire after <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setTimer(long delay, io.vertx.core.Handler<java.lang.Long> handler) { 
    long ret = delegate.setTimer(delay, handler);
    return ret;
  }

  /**
   * Returns a one-shot timer as a read stream. The timer will be fired after <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the timer stream
   */
  public io.vertx.rxjava3.core.TimeoutStream timerStream(long delay) { 
    io.vertx.rxjava3.core.TimeoutStream ret = io.vertx.rxjava3.core.TimeoutStream.newInstance((io.vertx.core.TimeoutStream)delegate.timerStream(delay));
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long delay, io.vertx.core.Handler<java.lang.Long> handler) { 
    long ret = delegate.setPeriodic(delay, handler);
    return ret;
  }

  /**
   * Set a periodic timer to fire every <code>delay</code> milliseconds with initial delay, at which point <code>handler</code> will be called with
   * the id of the timer.
   * @param initialDelay the initial delay in milliseconds
   * @param delay the delay in milliseconds, after which the timer will fire
   * @param handler the handler that will be called with the timer ID when the timer fires
   * @return the unique ID of the timer
   */
  public long setPeriodic(long initialDelay, long delay, io.vertx.core.Handler<java.lang.Long> handler) { 
    long ret = delegate.setPeriodic(initialDelay, delay, handler);
    return ret;
  }

  /**
   * Returns a periodic timer as a read stream. The timer will be fired every <code>delay</code> milliseconds after
   * the  has been called.
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the periodic stream
   */
  public io.vertx.rxjava3.core.TimeoutStream periodicStream(long delay) { 
    io.vertx.rxjava3.core.TimeoutStream ret = io.vertx.rxjava3.core.TimeoutStream.newInstance((io.vertx.core.TimeoutStream)delegate.periodicStream(delay));
    return ret;
  }

  /**
   * Returns a periodic timer as a read stream. The timer will be fired every <code>delay</code> milliseconds after
   * the  has been called.
   * @param initialDelay the initial delay in milliseconds
   * @param delay the delay in milliseconds, after which the timer will fire
   * @return the periodic stream
   */
  public io.vertx.rxjava3.core.TimeoutStream periodicStream(long initialDelay, long delay) { 
    io.vertx.rxjava3.core.TimeoutStream ret = io.vertx.rxjava3.core.TimeoutStream.newInstance((io.vertx.core.TimeoutStream)delegate.periodicStream(initialDelay, delay));
    return ret;
  }

  /**
   * Cancels the timer with the specified <code>id</code>.
   * @param id The id of the timer to cancel
   * @return true if the timer was successfully cancelled, or false if the timer does not exist.
   */
  public boolean cancelTimer(long id) { 
    boolean ret = delegate.cancelTimer(id);
    return ret;
  }

  /**
   * Puts the handler on the event queue for the current context so it will be run asynchronously ASAP after all
   * preceeding events have been handled.
   * @param action - a handler representing the action to execute
   */
  public void runOnContext(io.vertx.core.Handler<java.lang.Void> action) { 
    delegate.runOnContext(action);
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#close} but the completionHandler will be called when the close is complete
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> deployVerticle(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxDeployVerticle(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a String representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param name The identifier
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxDeployVerticle(java.lang.String name) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.deployVerticle(name, completionHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> deployVerticle(java.lang.String name, io.vertx.core.DeploymentOptions options) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxDeployVerticle(name, options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param name the name
   * @param options the deployment options.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxDeployVerticle(java.lang.String name, io.vertx.core.DeploymentOptions options) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.deployVerticle(name, options, completionHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable undeploy(java.lang.String deploymentID) { 
    io.reactivex.rxjava3.core.Completable ret = rxUndeploy(deploymentID);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx #undeploy(String)} but the completionHandler will be notified when the undeployment is complete.
   * @param deploymentID the deployment ID
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxUndeploy(java.lang.String deploymentID) { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.undeploy(deploymentID, completionHandler);
    });
  }

  /**
   * Return a Set of deployment IDs for the currently deployed deploymentIDs.
   * @return Set of deployment IDs
   */
  public java.util.Set<java.lang.String> deploymentIDs() { 
    java.util.Set<java.lang.String> ret = delegate.deploymentIDs();
    return ret;
  }

  /**
   * Is this Vert.x instance clustered?
   * @return true if clustered
   */
  public boolean isClustered() { 
    boolean ret = delegate.isClustered();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava3.core.Promise#complete} or {@link io.vertx.rxjava3.core.Promise#complete} method, or the {@link io.vertx.rxjava3.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.rxjava3.core.Context#runOnContext}
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> executeBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    io.reactivex.rxjava3.core.Maybe<T> ret = rxExecuteBlocking(blockingCodeHandler, ordered);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (e.g. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.rxjava3.core.Promise#complete} or {@link io.vertx.rxjava3.core.Promise#complete} method, or the {@link io.vertx.rxjava3.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * The blocking code should block for a reasonable amount of time (i.e no more than a few seconds). Long blocking operations
   * or polling operations (i.e a thread that spin in a loop polling events in a blocking fashion) are precluded.
   * <p>
   * When the blocking operation lasts more than the 10 seconds, a message will be printed on the console by the
   * blocked thread checker.
   * <p>
   * Long blocking operations should use a dedicated thread managed by the application, which can interact with
   * verticles using the event-bus or {@link io.vertx.rxjava3.core.Context#runOnContext}
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> rxExecuteBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler, boolean ordered) { 
    return AsyncResultMaybe.toMaybe( resultHandler -> {
      delegate.executeBlocking(new io.vertx.lang.rx.DelegatingHandler<>(blockingCodeHandler, event -> io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), ordered, resultHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> executeBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler) { 
    io.reactivex.rxjava3.core.Maybe<T> ret = rxExecuteBlocking(blockingCodeHandler);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#executeBlocking} called with ordered = true.
   * @param blockingCodeHandler 
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Maybe<T> rxExecuteBlocking(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> blockingCodeHandler) { 
    return AsyncResultMaybe.toMaybe( resultHandler -> {
      delegate.executeBlocking(new io.vertx.lang.rx.DelegatingHandler<>(blockingCodeHandler, event -> io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown())), resultHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>poolSize</code>.
   * @param name 
   * @return 
   */
  public io.vertx.rxjava3.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name) { 
    io.vertx.rxjava3.core.WorkerExecutor ret = io.vertx.rxjava3.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>maxExecuteTime</code>.
   * @param name 
   * @param poolSize 
   * @return 
   */
  public io.vertx.rxjava3.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name, int poolSize) { 
    io.vertx.rxjava3.core.WorkerExecutor ret = io.vertx.rxjava3.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name, poolSize));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#createSharedWorkerExecutor} but with the {@link io.vertx.core.VertxOptions} <code>maxExecuteTimeUnit</code>.
   * @param name 
   * @param poolSize 
   * @param maxExecuteTime 
   * @return 
   */
  public io.vertx.rxjava3.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name, int poolSize, long maxExecuteTime) { 
    io.vertx.rxjava3.core.WorkerExecutor ret = io.vertx.rxjava3.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime));
    return ret;
  }

  /**
   * Create a named worker executor, the executor should be closed when it's not needed anymore to release
   * resources.<p/>
   *
   * This method can be called mutiple times with the same <code>name</code>. Executors with the same name will share
   * the same worker pool. The worker pool size , max execute time and unit of max execute time are set when the worker pool is created and
   * won't change after.<p>
   *
   * The worker pool is released when all the {@link io.vertx.rxjava3.core.WorkerExecutor} sharing the same name are closed.
   * @param name the name of the worker executor
   * @param poolSize the size of the pool
   * @param maxExecuteTime the value of max worker execute time
   * @param maxExecuteTimeUnit the value of unit of max worker execute time
   * @return the named worker executor
   */
  public io.vertx.rxjava3.core.WorkerExecutor createSharedWorkerExecutor(java.lang.String name, int poolSize, long maxExecuteTime, java.util.concurrent.TimeUnit maxExecuteTimeUnit) { 
    io.vertx.rxjava3.core.WorkerExecutor ret = io.vertx.rxjava3.core.WorkerExecutor.newInstance((io.vertx.core.WorkerExecutor)delegate.createSharedWorkerExecutor(name, poolSize, maxExecuteTime, maxExecuteTimeUnit));
    return ret;
  }

  /**
   * @return whether the native transport is used
   */
  public boolean isNativeTransportEnabled() { 
    if (cached_3 != null) {
      return cached_3;
    }
    boolean ret = delegate.isNativeTransportEnabled();
    cached_3 = ret;
    return ret;
  }

  /**
   * Set a default exception handler for {@link io.vertx.rxjava3.core.Context}, set on {@link io.vertx.rxjava3.core.Context#exceptionHandler} at creation.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.Vertx exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param verticle the verticle instance to deploy
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> deployVerticle(io.vertx.core.Verticle verticle) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxDeployVerticle(verticle);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but the completionHandler will be notified when the deployment is complete.
   * <p>
   * If the deployment is successful the result will contain a string representing the unique deployment ID of the
   * deployment.
   * <p>
   * This deployment ID can subsequently be used to undeploy the verticle.
   * @param verticle the verticle instance to deploy
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxDeployVerticle(io.vertx.core.Verticle verticle) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.deployVerticle(verticle, completionHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> deployVerticle(io.vertx.core.Verticle verticle, io.vertx.core.DeploymentOptions options) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxDeployVerticle(verticle, options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but {@link io.vertx.core.DeploymentOptions} are provided to configure the
   * deployment.
   * @param verticle the verticle instance to deploy
   * @param options the deployment options.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxDeployVerticle(io.vertx.core.Verticle verticle, io.vertx.core.DeploymentOptions options) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.deployVerticle(verticle, options, completionHandler);
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but {@link io.vertx.core.Verticle} instance is created by
   * invoking the <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * @param verticleSupplier 
   * @param options 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> deployVerticle(java.util.function.Supplier<io.vertx.core.Verticle> verticleSupplier, io.vertx.core.DeploymentOptions options) { 
    io.reactivex.rxjava3.core.Single<java.lang.String> ret = rxDeployVerticle(verticleSupplier, options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.Vertx#deployVerticle} but {@link io.vertx.core.Verticle} instance is created by
   * invoking the <code>verticleSupplier</code>.
   * <p>
   * The supplier will be invoked as many times as {@link io.vertx.core.DeploymentOptions}.
   * It must not return the same instance twice.
   * <p>
   * Note that the supplier will be invoked on the caller thread.
   * @param verticleSupplier 
   * @param options 
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<java.lang.String> rxDeployVerticle(java.util.function.Supplier<io.vertx.core.Verticle> verticleSupplier, io.vertx.core.DeploymentOptions options) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.deployVerticle(verticleSupplier, options, completionHandler);
    });
  }

  /**
   * Register a <code>VerticleFactory</code> that can be used for deploying Verticles based on an identifier.
   * @param factory the factory to register
   */
  public void registerVerticleFactory(io.vertx.core.spi.VerticleFactory factory) { 
    delegate.registerVerticleFactory(factory);
  }

  /**
   * Unregister a <code>VerticleFactory</code>
   * @param factory the factory to unregister
   */
  public void unregisterVerticleFactory(io.vertx.core.spi.VerticleFactory factory) { 
    delegate.unregisterVerticleFactory(factory);
  }

  /**
   * Return the Set of currently registered verticle factories.
   * @return the set of verticle factories
   */
  public java.util.Set<io.vertx.core.spi.VerticleFactory> verticleFactories() { 
    java.util.Set<io.vertx.core.spi.VerticleFactory> ret = delegate.verticleFactories();
    return ret;
  }

  /**
   * Return the Netty EventLoopGroup used by Vert.x
   * @return the EventLoopGroup
   */
  public io.netty.channel.EventLoopGroup nettyEventLoopGroup() { 
    io.netty.channel.EventLoopGroup ret = delegate.nettyEventLoopGroup();
    return ret;
  }

  private io.vertx.rxjava3.core.file.FileSystem cached_0;
  private io.vertx.rxjava3.core.eventbus.EventBus cached_1;
  private io.vertx.rxjava3.core.shareddata.SharedData cached_2;
  private java.lang.Boolean cached_3;
  public static Vertx newInstance(io.vertx.core.Vertx arg) {
    return arg != null ? new Vertx(arg) : null;
  }

}
