/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.amqp;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface used to consume AMQP message as a stream of message.
 * Back pressure is implemented using AMQP credits.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpReceiver original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpReceiver.class)
public class AmqpReceiver implements io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.amqp.AmqpMessage> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpReceiver that = (AmqpReceiver) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpReceiver> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpReceiver((io.vertx.amqp.AmqpReceiver) obj),
    AmqpReceiver::getDelegate
  );

  private final io.vertx.amqp.AmqpReceiver delegate;
  
  public AmqpReceiver(io.vertx.amqp.AmqpReceiver delegate) {
    this.delegate = delegate;
  }

  public AmqpReceiver(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpReceiver)delegate;
  }

  public io.vertx.amqp.AmqpReceiver getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.amqp.AmqpMessage> observable;
  private io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.amqp.AmqpMessage> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.amqp.AmqpMessage> toObservable() {
    if (observable == null) {
      Function<io.vertx.amqp.AmqpMessage, io.vertx.rxjava3.amqp.AmqpMessage> conv = io.vertx.rxjava3.amqp.AmqpMessage::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.amqp.AmqpMessage> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.amqp.AmqpMessage, io.vertx.rxjava3.amqp.AmqpMessage> conv = io.vertx.rxjava3.amqp.AmqpMessage::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }

  private static final TypeArg<io.vertx.rxjava3.amqp.AmqpMessage> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.amqp.AmqpMessage>(o1 -> io.vertx.rxjava3.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)o1), o1 -> o1.getDelegate());

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.amqp.AmqpMessage> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.amqp.AmqpMessage> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.amqp.AmqpMessage> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.amqp.AmqpMessage> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public io.vertx.rxjava3.amqp.AmqpReceiver exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.amqp.AmqpReceiver handler(io.vertx.core.Handler<io.vertx.rxjava3.amqp.AmqpMessage> handler) { 
    delegate.handler(new io.vertx.lang.rx.DelegatingHandler<>(handler, event -> io.vertx.rxjava3.amqp.AmqpMessage.newInstance((io.vertx.amqp.AmqpMessage)event)));
    return this;
  }

  public io.vertx.rxjava3.amqp.AmqpReceiver pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.amqp.AmqpReceiver resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.amqp.AmqpReceiver fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava3.amqp.AmqpReceiver endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * The listened address.
   * @return the address, not <code>null</code>
   */
  public java.lang.String address() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.address();
    cached_0 = ret;
    return ret;
  }

  /**
   * Closes the receiver.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Closes the receiver.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  /**
   * Gets the connection having created the receiver. Cannot be <code>null</code>
   * @return the connection having created the receiver.
   */
  public io.vertx.rxjava3.amqp.AmqpConnection connection() { 
    io.vertx.rxjava3.amqp.AmqpConnection ret = io.vertx.rxjava3.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)delegate.connection());
    return ret;
  }

  /**
   * @return the underlying ProtonReceiver.
   */
  public io.vertx.proton.ProtonReceiver unwrap() { 
    io.vertx.proton.ProtonReceiver ret = delegate.unwrap();
    return ret;
  }

  private java.lang.String cached_0;
  public static AmqpReceiver newInstance(io.vertx.amqp.AmqpReceiver arg) {
    return arg != null ? new AmqpReceiver(arg) : null;
  }

}
