/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mqtt;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents an MQTT endpoint for point-to-point communication with the remote MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttEndpoint original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.MqttEndpoint.class)
public class MqttEndpoint {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttEndpoint that = (MqttEndpoint) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttEndpoint> __TYPE_ARG = new TypeArg<>(    obj -> new MqttEndpoint((io.vertx.mqtt.MqttEndpoint) obj),
    MqttEndpoint::getDelegate
  );

  private final io.vertx.mqtt.MqttEndpoint delegate;
  
  public MqttEndpoint(io.vertx.mqtt.MqttEndpoint delegate) {
    this.delegate = delegate;
  }

  public MqttEndpoint(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttEndpoint)delegate;
  }

  public io.vertx.mqtt.MqttEndpoint getDelegate() {
    return delegate;
  }

  /**
   * Close the endpoint, so the connection with remote MQTT client
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the remote address for this socket
   */
  public io.vertx.rxjava3.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public io.vertx.rxjava3.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.core.net.SocketAddress ret = io.vertx.rxjava3.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava3.mqtt.MqttEndpoint} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   *  Returns the HTTP headers sent by the client when a WebSocket transport is used otherwise <code>null</code>
   * @return the HTTP headers
   */
  public io.vertx.rxjava3.core.MultiMap httpHeaders() { 
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.httpHeaders());
    return ret;
  }

  /**
   *  Returns the HTTP request URI sent by the client when a WebSocket transport is used otherwise <code>null</code>
   * @return the HTTP request uri
   */
  public java.lang.String httpRequestURI() { 
    java.lang.String ret = delegate.httpRequestURI();
    return ret;
  }

  /**
   * @return the client identifier as provided by the remote MQTT client
   */
  public java.lang.String clientIdentifier() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.clientIdentifier();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the Authentication information as provided by the remote MQTT client
   */
  public io.vertx.mqtt.MqttAuth auth() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.mqtt.MqttAuth ret = delegate.auth();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the Will information as provided by the remote MQTT client
   */
  public io.vertx.mqtt.MqttWill will() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.mqtt.MqttWill ret = delegate.will();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return the protocol version required by the remote MQTT client
   */
  public int protocolVersion() { 
    if (cached_5 != null) {
      return cached_5;
    }
    int ret = delegate.protocolVersion();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return the protocol name provided by the remote MQTT client
   */
  public java.lang.String protocolName() { 
    if (cached_6 != null) {
      return cached_6;
    }
    java.lang.String ret = delegate.protocolName();
    cached_6 = ret;
    return ret;
  }

  /**
   * @return true when clean session is requested by the remote MQTT client
   */
  public boolean isCleanSession() { 
    if (cached_7 != null) {
      return cached_7;
    }
    boolean ret = delegate.isCleanSession();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return the keep alive timeout (in seconds) specified by the remote MQTT client
   */
  public int keepAliveTimeSeconds() { 
    if (cached_8 != null) {
      return cached_8;
    }
    int ret = delegate.keepAliveTimeSeconds();
    cached_8 = ret;
    return ret;
  }

  /**
   * @return the message identifier used for last published message
   */
  public int lastMessageId() { 
    if (cached_9 != null) {
      return cached_9;
    }
    int ret = delegate.lastMessageId();
    cached_9 = ret;
    return ret;
  }

  /**
   * Enable/disable subscription/unsubscription requests auto acknowledge
   * @param isSubscriptionAutoAck auto acknowledge status
   */
  public void subscriptionAutoAck(boolean isSubscriptionAutoAck) { 
    delegate.subscriptionAutoAck(isSubscriptionAutoAck);
  }

  /**
   * @return true when auto acknowledge status for subscription/unsubscription requests
   */
  public boolean isSubscriptionAutoAck() { 
    boolean ret = delegate.isSubscriptionAutoAck();
    return ret;
  }

  /**
   * Enable/disable publishing (in/out) auto acknowledge
   * @param isPublishAutoAck auto acknowledge status
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishAutoAck(boolean isPublishAutoAck) { 
    delegate.publishAutoAck(isPublishAutoAck);
    return this;
  }

  /**
   * @return auto acknowledge status for publishing (in/out)
   */
  public boolean isPublishAutoAck() { 
    boolean ret = delegate.isPublishAutoAck();
    return ret;
  }

  /**
   * Enable/disable auto keep alive (sending ping response)
   * @param isAutoKeepAlive auto keep alive
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) { 
    delegate.autoKeepAlive(isAutoKeepAlive);
    return this;
  }

  /**
   * @return the auto keep alive status (sending ping response)
   */
  public boolean isAutoKeepAlive() { 
    boolean ret = delegate.isAutoKeepAlive();
    return ret;
  }

  /**
   * @return if the connection between remote client and local endpoint is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Set client identifier if not provided by the remote MQTT client (zero-bytes)
   * @param clientIdentifier the client identifier
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint setClientIdentifier(java.lang.String clientIdentifier) { 
    delegate.setClientIdentifier(clientIdentifier);
    return this;
  }

  /**
   * Set a disconnect handler on the MQTT endpoint. This handler is called when a DISCONNECT
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint disconnectHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.disconnectHandler(handler);
    return this;
  }

  /**
   * Set a disconnect handler on the MQTT endpoint. This handler is called when a DISCONNECT
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint disconnectMessageHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttDisconnectMessage> handler) { 
    delegate.disconnectMessageHandler(new Handler<io.vertx.mqtt.messages.MqttDisconnectMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttDisconnectMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttDisconnectMessage.newInstance((io.vertx.mqtt.messages.MqttDisconnectMessage)event));
      }
    });
    return this;
  }

  /**
   * Set a subscribe handler on the MQTT endpoint. This handler is called when a SUBSCRIBE
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint subscribeHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttSubscribeMessage> handler) { 
    delegate.subscribeHandler(new Handler<io.vertx.mqtt.messages.MqttSubscribeMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttSubscribeMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttSubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttSubscribeMessage)event));
      }
    });
    return this;
  }

  /**
   * Set a unsubscribe handler on the MQTT endpoint. This handler is called when a UNSUBSCRIBE
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint unsubscribeHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttUnsubscribeMessage> handler) { 
    delegate.unsubscribeHandler(new Handler<io.vertx.mqtt.messages.MqttUnsubscribeMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttUnsubscribeMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttUnsubscribeMessage.newInstance((io.vertx.mqtt.messages.MqttUnsubscribeMessage)event));
      }
    });
    return this;
  }

  /**
   * Set the publish handler on the MQTT endpoint. This handler is called when a PUBLISH
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttPublishMessage> handler) { 
    delegate.publishHandler(new Handler<io.vertx.mqtt.messages.MqttPublishMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)event));
      }
    });
    return this;
  }

  /**
   * Set the puback handler on the MQTT endpoint. This handler is called when a PUBACK
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishAcknowledgeHandler(io.vertx.core.Handler<java.lang.Integer> handler) { 
    delegate.publishAcknowledgeHandler(handler);
    return this;
  }

  /**
   * Set the puback handler on the MQTT endpoint. This handler is called when a PUBACK
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishAcknowledgeMessageHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttPubAckMessage> handler) { 
    delegate.publishAcknowledgeMessageHandler(new Handler<io.vertx.mqtt.messages.MqttPubAckMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPubAckMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttPubAckMessage.newInstance((io.vertx.mqtt.messages.MqttPubAckMessage)event));
      }
    });
    return this;
  }

  /**
   * Set the pubrec handler on the MQTT endpoint. This handler is called when a PUBREC
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishReceivedHandler(io.vertx.core.Handler<java.lang.Integer> handler) { 
    delegate.publishReceivedHandler(handler);
    return this;
  }

  /**
   * Set the pubrec handler on the MQTT endpoint. This handler is called when a PUBREC
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishReceivedMessageHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttPubRecMessage> handler) { 
    delegate.publishReceivedMessageHandler(new Handler<io.vertx.mqtt.messages.MqttPubRecMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPubRecMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttPubRecMessage.newInstance((io.vertx.mqtt.messages.MqttPubRecMessage)event));
      }
    });
    return this;
  }

  /**
   * Set the pubrel handler on the MQTT endpoint. This handler is called when a PUBREL
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishReleaseHandler(io.vertx.core.Handler<java.lang.Integer> handler) { 
    delegate.publishReleaseHandler(handler);
    return this;
  }

  /**
   * Set the pubrel handler on the MQTT endpoint. This handler is called when a PUBREL
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishReleaseMessageHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttPubRelMessage> handler) { 
    delegate.publishReleaseMessageHandler(new Handler<io.vertx.mqtt.messages.MqttPubRelMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPubRelMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttPubRelMessage.newInstance((io.vertx.mqtt.messages.MqttPubRelMessage)event));
      }
    });
    return this;
  }

  /**
   * Set the pubcomp handler on the MQTT endpoint. This handler is called when a PUBCOMP
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishCompletionHandler(io.vertx.core.Handler<java.lang.Integer> handler) { 
    delegate.publishCompletionHandler(handler);
    return this;
  }

  /**
   * Set the pubcomp handler on the MQTT endpoint. This handler is called when a PUBCOMP
   * message is received by the remote MQTT client
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishCompletionMessageHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttPubCompMessage> handler) { 
    delegate.publishCompletionMessageHandler(new Handler<io.vertx.mqtt.messages.MqttPubCompMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPubCompMessage event) {
        handler.handle(io.vertx.rxjava3.mqtt.messages.MqttPubCompMessage.newInstance((io.vertx.mqtt.messages.MqttPubCompMessage)event));
      }
    });
    return this;
  }

  /**
   * Set the pingreq handler on the MQTT endpoint. This handler is called when a PINGREQ
   * message is received by the remote MQTT client. In any case the endpoint sends the
   * PINGRESP internally after executing this handler.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint pingHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.pingHandler(handler);
    return this;
  }

  /**
   * Set a close handler. This will be called when the MQTT endpoint is closed
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set an exception handler. This will be called when an error at protocol level happens
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.mqtt.MqttEndpoint#accept} with no session is present.
   * @return 
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint accept() { 
    delegate.accept();
    return this;
  }

  /**
   * Sends the CONNACK message to the remote MQTT client with "connection accepted"
   * return code. See {@link io.vertx.rxjava3.mqtt.MqttEndpoint#reject} for refusing connection
   * @param sessionPresent if a previous session is present
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint accept(boolean sessionPresent) { 
    delegate.accept(sessionPresent);
    return this;
  }

  /**
   * Sends the CONNACK message to the remote MQTT client rejecting the connection
   * request with specified return code. See {@link io.vertx.rxjava3.mqtt.MqttEndpoint#accept} for accepting connection
   * @param returnCode the connect return code
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint reject(io.netty.handler.codec.mqtt.MqttConnectReturnCode returnCode) { 
    delegate.reject(returnCode);
    return this;
  }

  /**
   * Sends the SUBACK message to the remote MQTT client
   * @param subscribeMessageId identifier of the SUBSCRIBE message to acknowledge
   * @param grantedQoSLevels granted QoS levels for the requested topics
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint subscribeAcknowledge(int subscribeMessageId, java.util.List<io.netty.handler.codec.mqtt.MqttQoS> grantedQoSLevels) { 
    delegate.subscribeAcknowledge(subscribeMessageId, grantedQoSLevels);
    return this;
  }

  /**
   * Sends the UNSUBACK message to the remote MQTT client
   * @param unsubscribeMessageId identifier of the UNSUBSCRIBE message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId) { 
    delegate.unsubscribeAcknowledge(unsubscribeMessageId);
    return this;
  }

  /**
   * Sends the PUBACK message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishAcknowledge(int publishMessageId) { 
    delegate.publishAcknowledge(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBREC message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishReceived(int publishMessageId) { 
    delegate.publishReceived(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBREL message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishRelease(int publishMessageId) { 
    delegate.publishRelease(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBCOMP message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishComplete(int publishMessageId) { 
    delegate.publishComplete(publishMessageId);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> publish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxPublish(topic, payload, qosLevel, isDup, isRetain);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxPublish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return AsyncResultSingle.toSingle( publishSentHandler -> {
      delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    });
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> publish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxPublish(topic, payload, qosLevel, isDup, isRetain, messageId);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxPublish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) { 
    return AsyncResultSingle.toSingle( publishSentHandler -> {
      delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, publishSentHandler);
    });
  }

  /**
   * Sends the PINGRESP message to the remote MQTT client
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint pong() { 
    delegate.pong();
    return this;
  }

  /**
   * @return MQTT properties of the CONNECT message
   */
  public io.netty.handler.codec.mqtt.MqttProperties connectProperties() { 
    io.netty.handler.codec.mqtt.MqttProperties ret = delegate.connectProperties();
    return ret;
  }

  /**
   * Sends the CONNACK message to the remote MQTT client with "connection accepted"
   * return code. See {@link io.vertx.rxjava3.mqtt.MqttEndpoint#reject} for refusing connection
   * @param sessionPresent if a previous session is present
   * @param properties CONNACK message properties (MQTT5)
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint accept(boolean sessionPresent, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.accept(sessionPresent, properties);
    return this;
  }

  /**
   * Sends the CONNACK message to the remote MQTT client rejecting the connection
   * request with specified return code. See {@link io.vertx.rxjava3.mqtt.MqttEndpoint#accept} for accepting connection
   * @param returnCode the connect return code
   * @param properties CONNACK message properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint reject(io.netty.handler.codec.mqtt.MqttConnectReturnCode returnCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.reject(returnCode, properties);
    return this;
  }

  /**
   * Sends the SUBACK message to the remote MQTT client
   * @param subscribeMessageId identifier of the SUBSCRIBE message to acknowledge
   * @param reasonCodes reason codes
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint subscribeAcknowledge(int subscribeMessageId, java.util.List<io.vertx.mqtt.messages.codes.MqttSubAckReasonCode> reasonCodes, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.subscribeAcknowledge(subscribeMessageId, reasonCodes, properties);
    return this;
  }

  /**
   * Sends the UNSUBACK message to the remote MQTT client
   * @param unsubscribeMessageId identifier of the UNSUBSCRIBE message to acknowledge
   * @param reasonCodes reason codes
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint unsubscribeAcknowledge(int unsubscribeMessageId, java.util.List<io.vertx.mqtt.messages.codes.MqttUnsubAckReasonCode> reasonCodes, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.unsubscribeAcknowledge(unsubscribeMessageId, reasonCodes, properties);
    return this;
  }

  public io.vertx.rxjava3.mqtt.MqttEndpoint publishAcknowledge(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubAckReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishAcknowledge(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * Sends the PUBREC message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @param reasonCode code of the outcome
   * @param properties MQTT properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishReceived(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubRecReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishReceived(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * Sends the PUBREL message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @param reasonCode reason code
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishRelease(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubRelReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishRelease(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * Sends the PUBCOMP message to the remote MQTT client
   * @param publishMessageId identifier of the PUBLISH message to acknowledge
   * @param reasonCode reason code
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint publishComplete(int publishMessageId, io.vertx.mqtt.messages.codes.MqttPubCompReasonCode reasonCode, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.publishComplete(publishMessageId, reasonCode, properties);
    return this;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @param properties PUBLISH message properties
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> publish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxPublish(topic, payload, qosLevel, isDup, isRetain, messageId, properties);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server explicitly specifying the messageId
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @param messageId message ID
   * @param properties PUBLISH message properties
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxPublish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    return AsyncResultSingle.toSingle( publishSentHandler -> {
      delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, messageId, properties, publishSentHandler);
    });
  }

  /**
   * Sends the DISCONNECT message to the remote MQTT client
   * @param code reason code
   * @param properties MQTT message properties
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttEndpoint disconnect(io.vertx.mqtt.messages.codes.MqttDisconnectReasonCode code, io.netty.handler.codec.mqtt.MqttProperties properties) { 
    delegate.disconnect(code, properties);
    return this;
  }

  private io.vertx.rxjava3.core.net.SocketAddress cached_0;
  private io.vertx.rxjava3.core.net.SocketAddress cached_1;
  private java.lang.String cached_2;
  private io.vertx.mqtt.MqttAuth cached_3;
  private io.vertx.mqtt.MqttWill cached_4;
  private java.lang.Integer cached_5;
  private java.lang.String cached_6;
  private java.lang.Boolean cached_7;
  private java.lang.Integer cached_8;
  private java.lang.Integer cached_9;
  public static MqttEndpoint newInstance(io.vertx.mqtt.MqttEndpoint arg) {
    return arg != null ? new MqttEndpoint(arg) : null;
  }

}
