/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mqtt;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An MQTT client
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.MqttClient.class)
public class MqttClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttClient that = (MqttClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttClient> __TYPE_ARG = new TypeArg<>(    obj -> new MqttClient((io.vertx.mqtt.MqttClient) obj),
    MqttClient::getDelegate
  );

  private final io.vertx.mqtt.MqttClient delegate;
  
  public MqttClient(io.vertx.mqtt.MqttClient delegate) {
    this.delegate = delegate;
  }

  public MqttClient(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttClient)delegate;
  }

  public io.vertx.mqtt.MqttClient getDelegate() {
    return delegate;
  }

  /**
   * Return an MQTT client instance
   * @param vertx Vert.x instance
   * @param options MQTT client options
   * @return MQTT client instance
   */
  public static io.vertx.rxjava3.mqtt.MqttClient create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.mqtt.MqttClientOptions options) { 
    io.vertx.rxjava3.mqtt.MqttClient ret = io.vertx.rxjava3.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return an MQTT client instance using the default options
   * @param vertx Vert.x instance
   * @return MQTT client instance
   */
  public static io.vertx.rxjava3.mqtt.MqttClient create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.mqtt.MqttClient ret = io.vertx.rxjava3.mqtt.MqttClient.newInstance((io.vertx.mqtt.MqttClient)io.vertx.mqtt.MqttClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage> connect(int port, java.lang.String host) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage> ret = rxConnect(port, host);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage> rxConnect(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle( connectHandler -> {
      delegate.connect(port, host, new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>() {
      public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage> connect(int port, java.lang.String host, java.lang.String serverName) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage> ret = rxConnect(port, host, serverName);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connects to an MQTT server calling connectHandler after connection
   * @param port port of the MQTT server
   * @param host hostname/ip address of the MQTT server
   * @param serverName the SNI server name
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage> rxConnect(int port, java.lang.String host, java.lang.String serverName) { 
    return AsyncResultSingle.toSingle( connectHandler -> {
      delegate.connect(port, host, serverName, new Handler<AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage>>() {
      public void handle(AsyncResult<io.vertx.mqtt.messages.MqttConnAckMessage> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.mqtt.messages.MqttConnAckMessage.newInstance((io.vertx.mqtt.messages.MqttConnAckMessage)ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Completable disconnect() { 
    io.reactivex.rxjava3.core.Completable ret = rxDisconnect();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Disconnects from the MQTT server calling disconnectHandler after disconnection
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Completable rxDisconnect() { 
    return AsyncResultCompletable.toCompletable( disconnectHandler -> {
      delegate.disconnect(disconnectHandler);
    });
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> publish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxPublish(topic, payload, qosLevel, isDup, isRetain);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Sends the PUBLISH message to the remote MQTT server
   * @param topic topic on which the message is published
   * @param payload message payload
   * @param qosLevel QoS level
   * @param isDup if the message is a duplicate
   * @param isRetain if the message needs to be retained
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxPublish(java.lang.String topic, io.vertx.rxjava3.core.buffer.Buffer payload, io.netty.handler.codec.mqtt.MqttQoS qosLevel, boolean isDup, boolean isRetain) { 
    return AsyncResultSingle.toSingle( publishSentHandler -> {
      delegate.publish(topic, payload.getDelegate(), qosLevel, isDup, isRetain, publishSentHandler);
    });
  }

  /**
   * Sets a handler which will be called each time the publishing of a message has been completed.
   * <p>
   * For a message that has been published using
   * <ul>
   * <li>QoS 0 this means that the client has successfully sent the corresponding PUBLISH packet,</li>
   * <li>QoS 1 this means that a corresponding PUBACK has been received from the server,</li>
   * <li>QoS 2 this means that a corresponding PUBCOMP has been received from the server.</li>
   * </ul>
   * @param publishCompletionHandler handler called with the packetId
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient publishCompletionHandler(io.vertx.core.Handler<java.lang.Integer> publishCompletionHandler) { 
    delegate.publishCompletionHandler(publishCompletionHandler);
    return this;
  }

  /**
   * Sets a handler which will be called when the client does not receive a PUBACK or
   * PUBREC/PUBCOMP for a message published using QoS 1 or 2 respectively.
   * <p>
   * The time to wait for an acknowledgement message can be configured using
   * {@link io.vertx.mqtt.MqttClientOptions}.
   * If the client receives a PUBACK/PUBREC/PUBCOMP for a message after its completion
   * has expired, the handler registered using {@link io.vertx.rxjava3.mqtt.MqttClient#publishCompletionUnknownPacketIdHandler}
   * will be invoked.
   * <p>
   * Note that this behavior is outside the scope of the MQTT 3.1.1 specification. The client's default
   * behavior is therefore to wait forever for the server's corresponding acknowledgement.
   * @param publishCompletionExpirationHandler the handler to call with the ID of the expired packet
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient publishCompletionExpirationHandler(io.vertx.core.Handler<java.lang.Integer> publishCompletionExpirationHandler) { 
    delegate.publishCompletionExpirationHandler(publishCompletionExpirationHandler);
    return this;
  }

  /**
   * Sets a handler which will be called when the client receives a PUBACK/PUBREC/PUBCOMP with an unknown
   * packet ID.
   * @param publishCompletionPhantomHandler the handler to call with the unknown packet ID
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient publishCompletionUnknownPacketIdHandler(io.vertx.core.Handler<java.lang.Integer> publishCompletionPhantomHandler) { 
    delegate.publishCompletionUnknownPacketIdHandler(publishCompletionPhantomHandler);
    return this;
  }

  /**
   * Sets handler which will be called each time server publish something to client
   * @param publishHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient publishHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttPublishMessage> publishHandler) { 
    delegate.publishHandler(new Handler<io.vertx.mqtt.messages.MqttPublishMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttPublishMessage event) {
        publishHandler.handle(io.vertx.rxjava3.mqtt.messages.MqttPublishMessage.newInstance((io.vertx.mqtt.messages.MqttPublishMessage)event));
      }
    });
    return this;
  }

  /**
   * Sets handler which will be called after SUBACK packet receiving
   * @param subscribeCompletionHandler handler to call. List inside is a granted QoS array
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient subscribeCompletionHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.messages.MqttSubAckMessage> subscribeCompletionHandler) { 
    delegate.subscribeCompletionHandler(new Handler<io.vertx.mqtt.messages.MqttSubAckMessage>() {
      public void handle(io.vertx.mqtt.messages.MqttSubAckMessage event) {
        subscribeCompletionHandler.handle(io.vertx.rxjava3.mqtt.messages.MqttSubAckMessage.newInstance((io.vertx.mqtt.messages.MqttSubAckMessage)event));
      }
    });
    return this;
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> subscribe(java.lang.String topic, int qos) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxSubscribe(topic, qos);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Subscribes to the topic with a specified QoS level
   * @param topic topic you subscribe on
   * @param qos QoS level
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxSubscribe(java.lang.String topic, int qos) { 
    return AsyncResultSingle.toSingle( subscribeSentHandler -> {
      delegate.subscribe(topic, qos, subscribeSentHandler);
    });
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> subscribe(java.util.Map<java.lang.String,java.lang.Integer> topics) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxSubscribe(topics);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Subscribes to the topic and adds a handler which will be called after the request is sent
   * @param topics topics you subscribe on
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxSubscribe(java.util.Map<java.lang.String,java.lang.Integer> topics) { 
    return AsyncResultSingle.toSingle( subscribeSentHandler -> {
      delegate.subscribe(topics, subscribeSentHandler);
    });
  }

  /**
   * Sets handler which will be called after UNSUBACK packet receiving
   * @param unsubscribeCompletionHandler handler to call with the packetid
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient unsubscribeCompletionHandler(io.vertx.core.Handler<java.lang.Integer> unsubscribeCompletionHandler) { 
    delegate.unsubscribeCompletionHandler(unsubscribeCompletionHandler);
    return this;
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic Topic you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> unsubscribe(java.lang.String topic) { 
    io.reactivex.rxjava3.core.Single<java.lang.Integer> ret = rxUnsubscribe(topic);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Unsubscribe from receiving messages on given topic
   * @param topic Topic you want to unsubscribe from
   * @return current MQTT client instance
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Integer> rxUnsubscribe(java.lang.String topic) { 
    return AsyncResultSingle.toSingle( unsubscribeSentHandler -> {
      delegate.unsubscribe(topic, unsubscribeSentHandler);
    });
  }

  /**
   * Sets handler which will be called after PINGRESP packet receiving
   * @param pingResponseHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient pingResponseHandler(io.vertx.core.Handler<java.lang.Void> pingResponseHandler) { 
    delegate.pingResponseHandler(pingResponseHandler);
    return this;
  }

  /**
   * Set an exception handler for the client, that will be called when an error happens
   * in internal netty structures.
   *
   * <code>io.netty.handler.codec.DecoderException</code> can be one of the cause
   * @param handler the exception handler
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set a handler that will be called when the connection with server is closed
   * @param closeHandler handler to call
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient closeHandler(io.vertx.core.Handler<java.lang.Void> closeHandler) { 
    delegate.closeHandler(closeHandler);
    return this;
  }

  /**
   * This method is needed by the client in order to avoid server closes the
   * connection due to the keep alive timeout if client has no messages to send
   * @return current MQTT client instance
   */
  public io.vertx.rxjava3.mqtt.MqttClient ping() { 
    delegate.ping();
    return this;
  }

  /**
   * @return the client identifier
   */
  public java.lang.String clientId() { 
    java.lang.String ret = delegate.clientId();
    return ret;
  }

  /**
   * @return if the connection between client and remote server is established/open
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  public static MqttClient newInstance(io.vertx.mqtt.MqttClient arg) {
    return arg != null ? new MqttClient(arg) : null;
  }

}
