/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that chains to a sequence of handlers.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ChainAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.ChainAuthHandler.class)
public class ChainAuthHandler implements io.vertx.rxjava3.ext.web.handler.AuthenticationHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChainAuthHandler that = (ChainAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ChainAuthHandler> __TYPE_ARG = new TypeArg<>(    obj -> new ChainAuthHandler((io.vertx.ext.web.handler.ChainAuthHandler) obj),
    ChainAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ChainAuthHandler delegate;
  
  public ChainAuthHandler(io.vertx.ext.web.handler.ChainAuthHandler delegate) {
    this.delegate = delegate;
  }

  public ChainAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ChainAuthHandler)delegate;
  }

  public io.vertx.ext.web.handler.ChainAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * @return 
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.web.handler.ChainAuthHandler create() { 
    io.vertx.rxjava3.ext.web.handler.ChainAuthHandler ret = io.vertx.rxjava3.ext.web.handler.ChainAuthHandler.newInstance((io.vertx.ext.web.handler.ChainAuthHandler)io.vertx.ext.web.handler.ChainAuthHandler.create());
    return ret;
  }

  /**
   * Create a chain authentication handler that will assert that all handlers pass the verification.
   * @return a new chain authentication handler
   */
  public static io.vertx.rxjava3.ext.web.handler.ChainAuthHandler all() { 
    io.vertx.rxjava3.ext.web.handler.ChainAuthHandler ret = io.vertx.rxjava3.ext.web.handler.ChainAuthHandler.newInstance((io.vertx.ext.web.handler.ChainAuthHandler)io.vertx.ext.web.handler.ChainAuthHandler.all());
    return ret;
  }

  /**
   * Create a chain authentication handler that will assert that any handler passes the verification.
   * @return a new chain authentication handler
   */
  public static io.vertx.rxjava3.ext.web.handler.ChainAuthHandler any() { 
    io.vertx.rxjava3.ext.web.handler.ChainAuthHandler ret = io.vertx.rxjava3.ext.web.handler.ChainAuthHandler.newInstance((io.vertx.ext.web.handler.ChainAuthHandler)io.vertx.ext.web.handler.ChainAuthHandler.any());
    return ret;
  }

  /**
   * Appends a auth provider to the chain.
   * @param other auth handler
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.ChainAuthHandler add(io.vertx.rxjava3.ext.web.handler.AuthenticationHandler other) { 
    delegate.add(other.getDelegate());
    return this;
  }

  public static ChainAuthHandler newInstance(io.vertx.ext.web.handler.ChainAuthHandler arg) {
    return arg != null ? new ChainAuthHandler(arg) : null;
  }

}
