/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An asynchronous sessions aware HTTP / HTTP/2 client called <code>WebClientSession</code>.
 * <p>
 * This client wraps a {@link io.vertx.rxjava3.ext.web.client.WebClient} and makes it session aware adding features to it:
 * <ul>
 *   <li>Per client headers, to be send with every request</li>
 *   <li>Per client cookies, to be send with every request</li>
 *   <li>Automatic storage and sending of cookies received from the server(s)</li>
 * </ul>
 * <p>
 * The client honors the cookies attributes:
 * <ul>
 *  <li>domain</li>
 *  <li>path</li>
 *  <li>secure</li>
 *  <li>max-age and expires</li>
 * </ul>
 * <p/>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.WebClientSession original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.client.WebClientSession.class)
public class WebClientSession extends io.vertx.rxjava3.ext.web.client.WebClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebClientSession that = (WebClientSession) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebClientSession> __TYPE_ARG = new TypeArg<>(    obj -> new WebClientSession((io.vertx.ext.web.client.WebClientSession) obj),
    WebClientSession::getDelegate
  );

  private final io.vertx.ext.web.client.WebClientSession delegate;
  
  public WebClientSession(io.vertx.ext.web.client.WebClientSession delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public WebClientSession(Object delegate) {
    super((io.vertx.ext.web.client.WebClientSession)delegate);
    this.delegate = (io.vertx.ext.web.client.WebClientSession)delegate;
  }

  public io.vertx.ext.web.client.WebClientSession getDelegate() {
    return delegate;
  }

  /**
   * Create a session aware web client using the provided <code>webClient</code> instance.
   * @param webClient the web client instance
   * @return the created client
   */
  public static io.vertx.rxjava3.ext.web.client.WebClientSession create(io.vertx.rxjava3.ext.web.client.WebClient webClient) { 
    io.vertx.rxjava3.ext.web.client.WebClientSession ret = io.vertx.rxjava3.ext.web.client.WebClientSession.newInstance((io.vertx.ext.web.client.WebClientSession)io.vertx.ext.web.client.WebClientSession.create(webClient.getDelegate()));
    return ret;
  }

  /**
   * Configure the client to add an HTTP header to every request.
   * @param name the header name
   * @param value the header value
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.client.WebClientSession addHeader(java.lang.String name, java.lang.String value) { 
    delegate.addHeader(name, value);
    return this;
  }

  /**
   * Removes a previously added header.
   * @param name the header name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.client.WebClientSession removeHeader(java.lang.String name) { 
    delegate.removeHeader(name);
    return this;
  }

  public static WebClientSession newInstance(io.vertx.ext.web.client.WebClientSession arg) {
    return arg != null ? new WebClientSession(arg) : null;
  }

}
