/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.shareddata;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Shared data allows you to share data safely between different parts of your application in a safe way.
 * <p>
 * Shared data provides:
 * <ul>
 *   <li>synchronous shared maps (local)</li>
 *   <li>asynchronous maps (local or cluster-wide)</li>
 *   <li>asynchronous locks (local or cluster-wide)</li>
 *   <li>asynchronous counters (local or cluster-wide)</li>
 * </ul>
 * <p>
 * <p>
 *   <strong>WARNING</strong>: In clustered mode, asynchronous maps/locks/counters rely on distributed data structures provided by the cluster manager.
 *   Beware that the latency relative to asynchronous maps/locks/counters operations can be much higher in clustered than in local mode.
 * </p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.shareddata.SharedData original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.shareddata.SharedData.class)
public class SharedData {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SharedData that = (SharedData) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SharedData> __TYPE_ARG = new TypeArg<>(    obj -> new SharedData((io.vertx.core.shareddata.SharedData) obj),
    SharedData::getDelegate
  );

  private final io.vertx.core.shareddata.SharedData delegate;
  
  public SharedData(io.vertx.core.shareddata.SharedData delegate) {
    this.delegate = delegate;
  }

  public SharedData(Object delegate) {
    this.delegate = (io.vertx.core.shareddata.SharedData)delegate;
  }

  public io.vertx.core.shareddata.SharedData getDelegate() {
    return delegate;
  }


  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return 
   */
  public <K, V> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> getClusterWideMap(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> ret = rxGetClusterWideMap(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the cluster wide map with the specified name. The map is accessible to all nodes in the cluster and data
   * put into the map from any node is visible to to any other node.
   * @param name the name of the map
   * @return 
   */
  public <K, V> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> rxGetClusterWideMap(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getClusterWideMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)ar.result(), TypeArg.unknown(), TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Get the {@link io.vertx.rxjava3.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return 
   */
  public <K, V> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> getAsyncMap(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> ret = rxGetAsyncMap(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the {@link io.vertx.rxjava3.core.shareddata.AsyncMap} with the specified name. When clustered, the map is accessible to all nodes in the cluster
   * and data put into the map from any node is visible to to any other node.
   * <p>
   *   <strong>WARNING</strong>: In clustered mode, asynchronous shared maps rely on distributed data structures provided by the cluster manager.
   *   Beware that the latency relative to asynchronous shared maps operations can be much higher in clustered than in local mode.
   * </p>
   * @param name the name of the map
   * @return 
   */
  public <K, V> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> rxGetAsyncMap(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)ar.result(), TypeArg.unknown(), TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Get the {@link io.vertx.rxjava3.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return 
   */
  public <K, V> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> getLocalAsyncMap(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> ret = rxGetLocalAsyncMap(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get the {@link io.vertx.rxjava3.core.shareddata.AsyncMap} with the specified name.
   * <p>
   * When clustered, the map is <b>NOT</b> accessible to all nodes in the cluster.
   * Only the instance which created the map can put and retrieve data from this map.
   * @param name the name of the map
   * @return 
   */
  public <K, V> io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.AsyncMap<K,V>> rxGetLocalAsyncMap(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getLocalAsyncMap(name, new Handler<AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.AsyncMap<K,V>> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.AsyncMap.newInstance((io.vertx.core.shareddata.AsyncMap)ar.result(), TypeArg.unknown(), TypeArg.unknown())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> getLock(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> ret = rxGetLock(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get an asynchronous lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> rxGetLock(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> getLockWithTimeout(java.lang.String name, long timeout) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> ret = rxGetLockWithTimeout(name, timeout);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.shareddata.SharedData#getLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> rxGetLockWithTimeout(java.lang.String name, long timeout) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> getLocalLock(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> ret = rxGetLocalLock(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get an asynchronous local lock with the specified name. The lock will be passed to the handler when it is available.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> rxGetLocalLock(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getLocalLock(name, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> getLocalLockWithTimeout(java.lang.String name, long timeout) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> ret = rxGetLocalLockWithTimeout(name, timeout);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.shareddata.SharedData#getLocalLock} but specifying a timeout. If the lock is not obtained within the timeout
   * a failure will be sent to the handler.
   * <p>
   *   In general lock acquision is unordered, so that sequential attempts to acquire a lock,
   *   even from a single thread, can happen in non-sequential order.
   * </p>
   * @param name the name of the lock
   * @param timeout the timeout in ms
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Lock> rxGetLocalLockWithTimeout(java.lang.String name, long timeout) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getLocalLockWithTimeout(name, timeout, new Handler<AsyncResult<io.vertx.core.shareddata.Lock>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Lock> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.Lock.newInstance((io.vertx.core.shareddata.Lock)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Counter> getCounter(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Counter> ret = rxGetCounter(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get an asynchronous counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Counter> rxGetCounter(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Counter> getLocalCounter(java.lang.String name) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Counter> ret = rxGetLocalCounter(name);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Get an asynchronous local counter. The counter will be passed to the handler.
   * @param name the name of the counter.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.shareddata.Counter> rxGetLocalCounter(java.lang.String name) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.getLocalCounter(name, new Handler<AsyncResult<io.vertx.core.shareddata.Counter>>() {
      public void handle(AsyncResult<io.vertx.core.shareddata.Counter> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.shareddata.Counter.newInstance((io.vertx.core.shareddata.Counter)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Return a <code>LocalMap</code> with the specific <code>name</code>.
   * @param name the name of the map
   * @return the msp
   */
  public <K, V> io.vertx.rxjava3.core.shareddata.LocalMap<K,V> getLocalMap(java.lang.String name) { 
    io.vertx.rxjava3.core.shareddata.LocalMap<K,V> ret = io.vertx.rxjava3.core.shareddata.LocalMap.newInstance((io.vertx.core.shareddata.LocalMap)delegate.getLocalMap(name), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  public static SharedData newInstance(io.vertx.core.shareddata.SharedData arg) {
    return arg != null ? new SharedData(arg) : null;
  }

}
