/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.eventbus;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An event bus consumer object representing a stream of message to an {@link io.vertx.rxjava3.core.eventbus.EventBus} address that can
 * be read from.
 * <p>
 * The {@link io.vertx.rxjava3.core.eventbus.EventBus#consumer} or {@link io.vertx.rxjava3.core.eventbus.EventBus#localConsumer}
 * creates a new consumer, the returned consumer is not yet registered against the event bus. Registration
 * is effective after the {@link io.vertx.rxjava3.core.eventbus.MessageConsumer#handler} method is invoked.<p>
 *
 * The consumer is unregistered from the event bus using the {@link io.vertx.rxjava3.core.eventbus.MessageConsumer#unregister} method or by calling the
 * {@link io.vertx.rxjava3.core.eventbus.MessageConsumer#handler} with a null value..
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageConsumer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.eventbus.MessageConsumer.class)
public class MessageConsumer<T> implements io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.eventbus.Message<T>> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageConsumer that = (MessageConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MessageConsumer> __TYPE_ARG = new TypeArg<>(    obj -> new MessageConsumer((io.vertx.core.eventbus.MessageConsumer) obj),
    MessageConsumer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageConsumer<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public MessageConsumer(io.vertx.core.eventbus.MessageConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public MessageConsumer(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.eventbus.MessageConsumer)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.MessageConsumer getDelegate() {
    return delegate;
  }

  private io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.core.eventbus.Message<T>> observable;
  private io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.eventbus.Message<T>> flowable;

  public synchronized io.reactivex.rxjava3.core.Observable<io.vertx.rxjava3.core.eventbus.Message<T>> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.eventbus.Message<T>, io.vertx.rxjava3.core.eventbus.Message<T>> conv = io.vertx.rxjava3.core.eventbus.Message::newInstance;
      observable = ObservableHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public synchronized io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.eventbus.Message<T>> toFlowable() {
    if (flowable == null) {
      Function<io.vertx.core.eventbus.Message<T>, io.vertx.rxjava3.core.eventbus.Message<T>> conv = io.vertx.rxjava3.core.eventbus.Message::newInstance;
      flowable = FlowableHelper.toFlowable(delegate, conv);
    }
    return flowable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.core.eventbus.Message<T>> pipe() { 
    io.vertx.rxjava3.core.streams.Pipe<io.vertx.rxjava3.core.eventbus.Message<T>> ret = io.vertx.rxjava3.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), new TypeArg<io.vertx.rxjava3.core.eventbus.Message<T>>(o0 -> io.vertx.rxjava3.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)o0, __typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable pipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.eventbus.Message<T>> dst) { 
    io.reactivex.rxjava3.core.Completable ret = rxPipeTo(dst);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxPipeTo(io.vertx.rxjava3.core.streams.WriteStream<io.vertx.rxjava3.core.eventbus.Message<T>> dst) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> handler(io.vertx.core.Handler<io.vertx.rxjava3.core.eventbus.Message<T>> handler) { 
    delegate.handler(new Handler<io.vertx.core.eventbus.Message<T>>() {
      public void handle(io.vertx.core.eventbus.Message<T> event) {
        handler.handle(io.vertx.rxjava3.core.eventbus.Message.newInstance((io.vertx.core.eventbus.Message)event, __typeArg_0));
      }
    });
    return this;
  }

  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> endHandler(io.vertx.core.Handler<java.lang.Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * @return a read stream for the body of the message stream.
   */
  public io.vertx.rxjava3.core.streams.ReadStream<T> bodyStream() { 
    io.vertx.rxjava3.core.streams.ReadStream<T> ret = io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.bodyStream(), __typeArg_0);
    return ret;
  }

  /**
   * @return true if the current consumer is registered
   */
  public boolean isRegistered() { 
    boolean ret = delegate.isRegistered();
    return ret;
  }

  /**
   * @return The address the handler was registered with.
   */
  public java.lang.String address() { 
    java.lang.String ret = delegate.address();
    return ret;
  }

  /**
   * Set the number of messages this registration will buffer when this stream is paused. The default
   * value is <code>1000</code>.
   * <p>
   * When a new value is set, buffered messages may be discarded to reach the new value. The most recent
   * messages will be kept.
   * @param maxBufferedMessages the maximum number of messages that can be buffered
   * @return this registration
   */
  public io.vertx.rxjava3.core.eventbus.MessageConsumer<T> setMaxBufferedMessages(int maxBufferedMessages) { 
    io.vertx.rxjava3.core.eventbus.MessageConsumer<T> ret = io.vertx.rxjava3.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.setMaxBufferedMessages(maxBufferedMessages), __typeArg_0);
    return ret;
  }

  /**
   * @return the maximum number of messages that can be buffered when this stream is paused
   */
  public int getMaxBufferedMessages() { 
    int ret = delegate.getMaxBufferedMessages();
    return ret;
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable completionHandler() { 
    io.reactivex.rxjava3.core.Completable ret = rxCompletionHandler();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Optional method which can be called to indicate when the registration has been propagated across the cluster.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxCompletionHandler() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.completionHandler(completionHandler);
    });
  }

  /**
   * Unregisters the handler which created this registration
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable unregister() { 
    io.reactivex.rxjava3.core.Completable ret = rxUnregister();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Unregisters the handler which created this registration
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxUnregister() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.unregister(completionHandler);
    });
  }

  public static <T> MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg) {
    return arg != null ? new MessageConsumer<T>(arg) : null;
  }

  public static <T> MessageConsumer<T> newInstance(io.vertx.core.eventbus.MessageConsumer arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageConsumer<T>(arg, __typeArg_T) : null;
  }

}
