/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.amqp;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AMQP Client entry point.
 * Use this interface to create an instance of {@link io.vertx.rxjava3.amqp.AmqpClient} and connect to a broker and server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqp.AmqpClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqp.AmqpClient.class)
public class AmqpClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpClient that = (AmqpClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpClient> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpClient((io.vertx.amqp.AmqpClient) obj),
    AmqpClient::getDelegate
  );

  private final io.vertx.amqp.AmqpClient delegate;
  
  public AmqpClient(io.vertx.amqp.AmqpClient delegate) {
    this.delegate = delegate;
  }

  public AmqpClient(Object delegate) {
    this.delegate = (io.vertx.amqp.AmqpClient)delegate;
  }

  public io.vertx.amqp.AmqpClient getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of {@link io.vertx.rxjava3.amqp.AmqpClient} using an internal Vert.x instance (with default configuration) and
   * the given AMQP client configuration. Note that the created Vert.x instance will be closed when the client is
   * closed.
   * @param options the AMQP client options, may be <code>null</code> falling back to the default configuration
   * @return the created instances.
   */
  public static io.vertx.rxjava3.amqp.AmqpClient create(io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.rxjava3.amqp.AmqpClient ret = io.vertx.rxjava3.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.rxjava3.amqp.AmqpClient} with the given Vert.x instance and the given options.
   * @param vertx the vert.x instance, must not be <code>null</code>
   * @param options the AMQP options, may be @{code null} falling back to the default configuration
   * @return the AMQP client instance
   */
  public static io.vertx.rxjava3.amqp.AmqpClient create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.amqp.AmqpClientOptions options) { 
    io.vertx.rxjava3.amqp.AmqpClient ret = io.vertx.rxjava3.amqp.AmqpClient.newInstance((io.vertx.amqp.AmqpClient)io.vertx.amqp.AmqpClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpConnection> connect() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpConnection> ret = rxConnect();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Connects to the AMQP broker or router. The location is specified in the {@link io.vertx.amqp.AmqpClientOptions} as well as the
   * potential credential required.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpConnection> rxConnect() { 
    return AsyncResultSingle.toSingle( connectionHandler -> {
      delegate.connect(new Handler<AsyncResult<io.vertx.amqp.AmqpConnection>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpConnection> ar) {
        if (ar.succeeded()) {
          connectionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.amqp.AmqpConnection.newInstance((io.vertx.amqp.AmqpConnection)ar.result())));
        } else {
          connectionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Closes the client.
   * The client must always be closed once not needed anymore.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( closeHandler -> {
      delegate.close(closeHandler);
    });
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.rxjava3.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the client.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpReceiver> createReceiver(java.lang.String address) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpReceiver> ret = rxCreateReceiver(address);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a receiver used to consume messages from the given address. The receiver has no handler and won't
   * start receiving messages until a handler is explicitly configured. This method avoids having to connect explicitly.
   * You can retrieve the connection using {@link io.vertx.rxjava3.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to, must not be <code>null</code>
   * @return the client.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.createReceiver(address, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.rxjava3.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpReceiver> createReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpReceiver> ret = rxCreateReceiver(address, receiverOptions);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a receiver used to consumer messages from the given address.  This method avoids having to connect
   * explicitly. You can retrieve the connection using {@link io.vertx.rxjava3.amqp.AmqpReceiver#connection}.
   * @param address The source address to attach the consumer to.
   * @param receiverOptions The options for this receiver.
   * @return the connection.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpReceiver> rxCreateReceiver(java.lang.String address, io.vertx.amqp.AmqpReceiverOptions receiverOptions) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.createReceiver(address, receiverOptions, new Handler<AsyncResult<io.vertx.amqp.AmqpReceiver>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpReceiver> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.amqp.AmqpReceiver.newInstance((io.vertx.amqp.AmqpReceiver)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the client.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpSender> createSender(java.lang.String address) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpSender> ret = rxCreateSender(address);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @return the client.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpSender> rxCreateSender(java.lang.String address) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.createSender(address, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the client.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpSender> createSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpSender> ret = rxCreateSender(address, options);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Creates a sender used to send messages to the given address. The address must be set.
   * @param address The target address to attach to, must not be <code>null</code>
   * @param options The options for this sender.
   * @return the client.
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.amqp.AmqpSender> rxCreateSender(java.lang.String address, io.vertx.amqp.AmqpSenderOptions options) { 
    return AsyncResultSingle.toSingle( completionHandler -> {
      delegate.createSender(address, options, new Handler<AsyncResult<io.vertx.amqp.AmqpSender>>() {
      public void handle(AsyncResult<io.vertx.amqp.AmqpSender> ar) {
        if (ar.succeeded()) {
          completionHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.amqp.AmqpSender.newInstance((io.vertx.amqp.AmqpSender)ar.result())));
        } else {
          completionHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  public static AmqpClient newInstance(io.vertx.amqp.AmqpClient arg) {
    return arg != null ? new AmqpClient(arg) : null;
  }

}
