/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.stomp;

import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.stomp.BridgeOptions;
import io.vertx.ext.stomp.Frame;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.auth.User;
import io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider;
import io.vertx.rxjava3.ext.stomp.Acknowledgement;
import io.vertx.rxjava3.ext.stomp.Destination;
import io.vertx.rxjava3.ext.stomp.DestinationFactory;
import io.vertx.rxjava3.ext.stomp.ServerFrame;
import io.vertx.rxjava3.ext.stomp.StompServerConnection;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.ext.stomp.StompServerHandler.class)
public class StompServerHandler
implements Handler<ServerFrame> {
    public static final TypeArg<StompServerHandler> __TYPE_ARG = new TypeArg(obj -> new StompServerHandler((io.vertx.ext.stomp.StompServerHandler)obj), StompServerHandler::getDelegate);
    private final io.vertx.ext.stomp.StompServerHandler delegate;
    private static final TypeArg<Destination> TYPE_ARG_0 = new TypeArg(o1 -> Destination.newInstance((io.vertx.ext.stomp.Destination)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompServerHandler that = (StompServerHandler)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompServerHandler(io.vertx.ext.stomp.StompServerHandler delegate) {
        this.delegate = delegate;
    }

    public StompServerHandler(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompServerHandler)delegate;
    }

    public io.vertx.ext.stomp.StompServerHandler getDelegate() {
        return this.delegate;
    }

    public void handle(ServerFrame event) {
        this.delegate.handle((Object)event.getDelegate());
    }

    public static StompServerHandler create(io.vertx.rxjava3.core.Vertx vertx) {
        StompServerHandler ret = StompServerHandler.newInstance(io.vertx.ext.stomp.StompServerHandler.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public StompServerHandler receivedFrameHandler(final Handler<ServerFrame> handler) {
        this.delegate.receivedFrameHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler connectHandler(final Handler<ServerFrame> handler) {
        this.delegate.connectHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler stompHandler(final Handler<ServerFrame> handler) {
        this.delegate.stompHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler subscribeHandler(final Handler<ServerFrame> handler) {
        this.delegate.subscribeHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler unsubscribeHandler(final Handler<ServerFrame> handler) {
        this.delegate.unsubscribeHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler sendHandler(final Handler<ServerFrame> handler) {
        this.delegate.sendHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler closeHandler(final Handler<StompServerConnection> handler) {
        this.delegate.closeHandler((Handler)new Handler<io.vertx.ext.stomp.StompServerConnection>(){

            public void handle(io.vertx.ext.stomp.StompServerConnection event) {
                handler.handle((Object)StompServerConnection.newInstance(event));
            }
        });
        return this;
    }

    public void onClose(StompServerConnection connection) {
        this.delegate.onClose(connection.getDelegate());
    }

    public StompServerHandler commitHandler(final Handler<ServerFrame> handler) {
        this.delegate.commitHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler abortHandler(final Handler<ServerFrame> handler) {
        this.delegate.abortHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler beginHandler(final Handler<ServerFrame> handler) {
        this.delegate.beginHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler disconnectHandler(final Handler<ServerFrame> handler) {
        this.delegate.disconnectHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler ackHandler(final Handler<ServerFrame> handler) {
        this.delegate.ackHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler nackHandler(final Handler<ServerFrame> handler) {
        this.delegate.nackHandler((Handler)new Handler<io.vertx.ext.stomp.ServerFrame>(){

            public void handle(io.vertx.ext.stomp.ServerFrame event) {
                handler.handle((Object)ServerFrame.newInstance(event));
            }
        });
        return this;
    }

    public Single<Boolean> onAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        Single ret = this.rxOnAuthenticationRequest(connection, login, passcode);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxOnAuthenticationRequest(StompServerConnection connection, String login, String passcode) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.onAuthenticationRequest(connection.getDelegate(), login, passcode, handler));
    }

    public User getUserBySession(String session) {
        User ret = User.newInstance(this.delegate.getUserBySession(session));
        return ret;
    }

    public StompServerHandler authProvider(AuthenticationProvider handler) {
        this.delegate.authProvider(handler.getDelegate());
        return this;
    }

    public List<Destination> getDestinations() {
        List<Destination> ret = this.delegate.getDestinations().stream().map(elt -> Destination.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public Destination getDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getDestination(destination));
        return ret;
    }

    public StompServerHandler onAck(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onAck(connection.getDelegate(), subscribe, messages);
        return this;
    }

    public StompServerHandler onNack(StompServerConnection connection, Frame subscribe, List<Frame> messages) {
        this.delegate.onNack(connection.getDelegate(), subscribe, messages);
        return this;
    }

    public StompServerHandler onAckHandler(final Handler<Acknowledgement> handler) {
        this.delegate.onAckHandler((Handler)new Handler<io.vertx.ext.stomp.Acknowledgement>(){

            public void handle(io.vertx.ext.stomp.Acknowledgement event) {
                handler.handle((Object)Acknowledgement.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler onNackHandler(final Handler<Acknowledgement> handler) {
        this.delegate.onNackHandler((Handler)new Handler<io.vertx.ext.stomp.Acknowledgement>(){

            public void handle(io.vertx.ext.stomp.Acknowledgement event) {
                handler.handle((Object)Acknowledgement.newInstance(event));
            }
        });
        return this;
    }

    public StompServerHandler pingHandler(final Handler<StompServerConnection> handler) {
        this.delegate.pingHandler((Handler)new Handler<io.vertx.ext.stomp.StompServerConnection>(){

            public void handle(io.vertx.ext.stomp.StompServerConnection event) {
                handler.handle((Object)StompServerConnection.newInstance(event));
            }
        });
        return this;
    }

    public Destination getOrCreateDestination(String destination) {
        Destination ret = Destination.newInstance(this.delegate.getOrCreateDestination(destination));
        return ret;
    }

    public StompServerHandler destinationFactory(DestinationFactory factory) {
        this.delegate.destinationFactory(factory.getDelegate());
        return this;
    }

    public StompServerHandler bridge(BridgeOptions options) {
        this.delegate.bridge(options);
        return this;
    }

    public static StompServerHandler newInstance(io.vertx.ext.stomp.StompServerHandler arg) {
        return arg != null ? new StompServerHandler(arg) : null;
    }
}

