/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.streams;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.vertx.core.Handler;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import java.util.function.Function;

class ReadStreamImpl<T>
implements ReadStream<T> {
    private final io.vertx.core.streams.ReadStream<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private Observable<T> observable;
    private Flowable<T> flowable;

    public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public ReadStreamImpl(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.core.streams.ReadStream)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    @Override
    public io.vertx.core.streams.ReadStream getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<T> toObservable() {
        if (this.observable == null) {
            Function conv = this.__typeArg_0.wrap;
            this.observable = ObservableHelper.toObservable(this.delegate, (Function)conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<T> toFlowable() {
        if (this.flowable == null) {
            Function conv = this.__typeArg_0.wrap;
            this.flowable = FlowableHelper.toFlowable(this.delegate, (Function)conv);
        }
        return this.flowable;
    }

    @Override
    public ReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public ReadStream<T> handler(final Handler<T> handler) {
        this.delegate.handler(new Handler<T>(){

            public void handle(T event) {
                handler.handle(ReadStreamImpl.this.__typeArg_0.wrap(event));
            }
        });
        return this;
    }

    @Override
    public ReadStream<T> pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public ReadStream<T> resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public ReadStream<T> fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public ReadStream<T> endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public Pipe<T> pipe() {
        Pipe<T> ret = Pipe.newInstance(this.delegate.pipe(), this.__typeArg_0);
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<T> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<T> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }
}

