/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.http.WebSocketBase;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.WebSocket.class)
public class WebSocket
implements RxDelegate,
WebSocketBase {
    public static final TypeArg<WebSocket> __TYPE_ARG = new TypeArg(obj -> new WebSocket((io.vertx.core.http.WebSocket)obj), WebSocket::getDelegate);
    private final io.vertx.core.http.WebSocket delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocket that = (WebSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocket(io.vertx.core.http.WebSocket delegate) {
        this.delegate = delegate;
    }

    public WebSocket(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocket)delegate;
    }

    public io.vertx.core.http.WebSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Future<Void> write(Buffer data) {
        Future ret = this.delegate.write((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public Future<Void> end(Buffer data) {
        Future ret = this.delegate.end((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Future<Void> pipeTo(io.vertx.reactivex.core.streams.WriteStream<Buffer> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(io.vertx.reactivex.core.streams.WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }

    @Override
    public String binaryHandlerID() {
        String ret = this.delegate.binaryHandlerID();
        return ret;
    }

    @Override
    public String textHandlerID() {
        String ret = this.delegate.textHandlerID();
        return ret;
    }

    @Override
    public String subProtocol() {
        String ret = this.delegate.subProtocol();
        return ret;
    }

    @Override
    public Short closeStatusCode() {
        Short ret = this.delegate.closeStatusCode();
        return ret;
    }

    @Override
    public String closeReason() {
        String ret = this.delegate.closeReason();
        return ret;
    }

    @Override
    public MultiMap headers() {
        MultiMap ret = this.delegate.headers();
        return ret;
    }

    @Override
    public Future<Void> writeFrame(WebSocketFrame frame) {
        Future ret = this.delegate.writeFrame(frame).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWriteFrame(WebSocketFrame frame) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFrame(frame).onComplete($handler));
    }

    @Override
    public Future<Void> writeFinalTextFrame(String text) {
        Future ret = this.delegate.writeFinalTextFrame(text).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWriteFinalTextFrame(String text) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFinalTextFrame(text).onComplete($handler));
    }

    @Override
    public Future<Void> writeFinalBinaryFrame(Buffer data) {
        Future ret = this.delegate.writeFinalBinaryFrame(data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWriteFinalBinaryFrame(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFinalBinaryFrame(data).onComplete($handler));
    }

    @Override
    public Future<Void> writeBinaryMessage(Buffer data) {
        Future ret = this.delegate.writeBinaryMessage(data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWriteBinaryMessage(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeBinaryMessage(data).onComplete($handler));
    }

    @Override
    public Future<Void> writeTextMessage(String text) {
        Future ret = this.delegate.writeTextMessage(text).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWriteTextMessage(String text) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeTextMessage(text).onComplete($handler));
    }

    @Override
    public Future<Void> writePing(Buffer data) {
        Future ret = this.delegate.writePing(data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWritePing(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writePing(data).onComplete($handler));
    }

    @Override
    public Future<Void> writePong(Buffer data) {
        Future ret = this.delegate.writePong(data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWritePong(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writePong(data).onComplete($handler));
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    @Override
    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    @Override
    public Future<Void> close(short statusCode) {
        Future ret = this.delegate.close(statusCode).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode) {
        return AsyncResultCompletable.toCompletable($handler -> this.close(statusCode).onComplete($handler));
    }

    @Override
    public Future<Void> close(short statusCode, String reason) {
        Future ret = this.delegate.close(statusCode, reason).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxClose(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable($handler -> this.close(statusCode, reason).onComplete($handler));
    }

    @Override
    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    @Override
    public Future<Void> shutdown(short statusCode) {
        Future ret = this.delegate.shutdown(statusCode).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown(short statusCode) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(statusCode).onComplete($handler));
    }

    @Override
    public Future<Void> shutdown(short statusCode, String reason) {
        Future ret = this.delegate.shutdown(statusCode, reason).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown(short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(statusCode, reason).onComplete($handler));
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit, short statusCode) {
        Future ret = this.delegate.shutdown(timeout, unit, statusCode).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit, short statusCode) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit, statusCode).onComplete($handler));
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit, short statusCode, String reason) {
        Future ret = this.delegate.shutdown(timeout, unit, statusCode, reason).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxShutdown(long timeout, TimeUnit unit, short statusCode, String reason) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit, statusCode, reason).onComplete($handler));
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.remoteAddress();
        return ret;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.localAddress();
        return ret;
    }

    @Override
    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    @Override
    public boolean isClosed() {
        boolean ret = this.delegate.isClosed();
        return ret;
    }

    @Override
    public WebSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public WebSocket handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    @Override
    public WebSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public WebSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public WebSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public WebSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public WebSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Override
    public WebSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    @Override
    public WebSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    @Override
    public WebSocket shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    @Override
    public WebSocket frameHandler(Handler<WebSocketFrame> handler) {
        this.delegate.frameHandler(handler);
        return this;
    }

    @Override
    public WebSocket textMessageHandler(Handler<String> handler) {
        this.delegate.textMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocket binaryMessageHandler(Handler<Buffer> handler) {
        this.delegate.binaryMessageHandler(handler);
        return this;
    }

    @Override
    public WebSocket pongHandler(Handler<Buffer> handler) {
        this.delegate.pongHandler(handler);
        return this;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static WebSocket newInstance(io.vertx.core.http.WebSocket arg) {
        return arg != null ? new WebSocket(arg) : null;
    }
}

