/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.kafka.admin;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.DescribeClusterOptions;
import io.vertx.kafka.admin.DescribeConsumerGroupsOptions;
import io.vertx.kafka.admin.DescribeTopicsOptions;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

@RxGen(value=io.vertx.kafka.admin.KafkaAdminClient.class)
public class KafkaAdminClient
implements RxDelegate {
    public static final TypeArg<KafkaAdminClient> __TYPE_ARG = new TypeArg(obj -> new KafkaAdminClient((io.vertx.kafka.admin.KafkaAdminClient)obj), KafkaAdminClient::getDelegate);
    private final io.vertx.kafka.admin.KafkaAdminClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaAdminClient that = (KafkaAdminClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public KafkaAdminClient(io.vertx.kafka.admin.KafkaAdminClient delegate) {
        this.delegate = delegate;
    }

    public KafkaAdminClient(Object delegate) {
        this.delegate = (io.vertx.kafka.admin.KafkaAdminClient)delegate;
    }

    public io.vertx.kafka.admin.KafkaAdminClient getDelegate() {
        return this.delegate;
    }

    public static KafkaAdminClient create(io.vertx.reactivex.core.Vertx vertx, Map<String, String> config) {
        KafkaAdminClient ret = KafkaAdminClient.newInstance(io.vertx.kafka.admin.KafkaAdminClient.create((Vertx)vertx.getDelegate(), config));
        return ret;
    }

    public Future<Set<String>> listTopics() {
        Future ret = this.delegate.listTopics().map(val -> val);
        return ret;
    }

    public Single<Set<String>> rxListTopics() {
        return AsyncResultSingle.toSingle($handler -> this.listTopics().onComplete($handler));
    }

    public Future<Map<String, TopicDescription>> describeTopics(List<String> topicNames) {
        Future ret = this.delegate.describeTopics(topicNames).map(val -> val);
        return ret;
    }

    public Single<Map<String, TopicDescription>> rxDescribeTopics(List<String> topicNames) {
        return AsyncResultSingle.toSingle($handler -> this.describeTopics(topicNames).onComplete($handler));
    }

    public Future<Map<String, TopicDescription>> describeTopics(List<String> topicNames, DescribeTopicsOptions options) {
        Future ret = this.delegate.describeTopics(topicNames, options).map(val -> val);
        return ret;
    }

    public Single<Map<String, TopicDescription>> rxDescribeTopics(List<String> topicNames, DescribeTopicsOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.describeTopics(topicNames, options).onComplete($handler));
    }

    public Future<Void> createTopics(List<NewTopic> topics) {
        Future ret = this.delegate.createTopics(topics).map(val -> val);
        return ret;
    }

    public Completable rxCreateTopics(List<NewTopic> topics) {
        return AsyncResultCompletable.toCompletable($handler -> this.createTopics(topics).onComplete($handler));
    }

    public Future<Void> deleteTopics(List<String> topicNames) {
        Future ret = this.delegate.deleteTopics(topicNames).map(val -> val);
        return ret;
    }

    public Completable rxDeleteTopics(List<String> topicNames) {
        return AsyncResultCompletable.toCompletable($handler -> this.deleteTopics(topicNames).onComplete($handler));
    }

    public Future<Void> createPartitions(Map<String, NewPartitions> partitions) {
        Future ret = this.delegate.createPartitions(partitions).map(val -> val);
        return ret;
    }

    public Completable rxCreatePartitions(Map<String, NewPartitions> partitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.createPartitions(partitions).onComplete($handler));
    }

    public Future<List<ConsumerGroupListing>> listConsumerGroups() {
        Future ret = this.delegate.listConsumerGroups().map(val -> val);
        return ret;
    }

    public Single<List<ConsumerGroupListing>> rxListConsumerGroups() {
        return AsyncResultSingle.toSingle($handler -> this.listConsumerGroups().onComplete($handler));
    }

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds) {
        Future ret = this.delegate.describeConsumerGroups(groupIds).map(val -> val);
        return ret;
    }

    public Single<Map<String, ConsumerGroupDescription>> rxDescribeConsumerGroups(List<String> groupIds) {
        return AsyncResultSingle.toSingle($handler -> this.describeConsumerGroups(groupIds).onComplete($handler));
    }

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> groupIds, DescribeConsumerGroupsOptions options) {
        Future ret = this.delegate.describeConsumerGroups(groupIds, options).map(val -> val);
        return ret;
    }

    public Single<Map<String, ConsumerGroupDescription>> rxDescribeConsumerGroups(List<String> groupIds, DescribeConsumerGroupsOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.describeConsumerGroups(groupIds, options).onComplete($handler));
    }

    public Future<ClusterDescription> describeCluster() {
        Future ret = this.delegate.describeCluster().map(val -> val);
        return ret;
    }

    public Single<ClusterDescription> rxDescribeCluster() {
        return AsyncResultSingle.toSingle($handler -> this.describeCluster().onComplete($handler));
    }

    public Future<ClusterDescription> describeCluster(DescribeClusterOptions options) {
        Future ret = this.delegate.describeCluster(options).map(val -> val);
        return ret;
    }

    public Single<ClusterDescription> rxDescribeCluster(DescribeClusterOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.describeCluster(options).onComplete($handler));
    }

    public Future<Void> deleteConsumerGroups(List<String> groupIds) {
        Future ret = this.delegate.deleteConsumerGroups(groupIds).map(val -> val);
        return ret;
    }

    public Completable rxDeleteConsumerGroups(List<String> groupIds) {
        return AsyncResultCompletable.toCompletable($handler -> this.deleteConsumerGroups(groupIds).onComplete($handler));
    }

    public Future<Void> deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        Future ret = this.delegate.deleteConsumerGroupOffsets(groupId, partitions).map(val -> val);
        return ret;
    }

    public Completable rxDeleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions) {
        return AsyncResultCompletable.toCompletable($handler -> this.deleteConsumerGroupOffsets(groupId, partitions).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Void> close(long timeout) {
        Future ret = this.delegate.close(timeout).map(val -> val);
        return ret;
    }

    public Completable rxClose(long timeout) {
        return AsyncResultCompletable.toCompletable($handler -> this.close(timeout).onComplete($handler));
    }

    public Future<List<AclBinding>> describeAcls(AclBindingFilter aclBindingFilter) {
        Future ret = this.delegate.describeAcls(aclBindingFilter).map(val -> val);
        return ret;
    }

    public Single<List<AclBinding>> rxDescribeAcls(AclBindingFilter aclBindingFilter) {
        return AsyncResultSingle.toSingle($handler -> this.describeAcls(aclBindingFilter).onComplete($handler));
    }

    public Future<List<AclBinding>> createAcls(List<AclBinding> aclBindings) {
        Future ret = this.delegate.createAcls(aclBindings).map(val -> val);
        return ret;
    }

    public Single<List<AclBinding>> rxCreateAcls(List<AclBinding> aclBindings) {
        return AsyncResultSingle.toSingle($handler -> this.createAcls(aclBindings).onComplete($handler));
    }

    public Future<List<AclBinding>> deleteAcls(List<AclBindingFilter> aclBindings) {
        Future ret = this.delegate.deleteAcls(aclBindings).map(val -> val);
        return ret;
    }

    public Single<List<AclBinding>> rxDeleteAcls(List<AclBindingFilter> aclBindings) {
        return AsyncResultSingle.toSingle($handler -> this.deleteAcls(aclBindings).onComplete($handler));
    }

    public static KafkaAdminClient newInstance(io.vertx.kafka.admin.KafkaAdminClient arg) {
        return arg != null ? new KafkaAdminClient(arg) : null;
    }
}

