/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.RenameCollectionOptions;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.ext.mongo.MongoGridFsClient;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoClient.class)
public class MongoClient
implements RxDelegate {
    public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg(obj -> new MongoClient((io.vertx.ext.mongo.MongoClient)obj), MongoClient::getDelegate);
    private final io.vertx.ext.mongo.MongoClient delegate;
    private static final TypeArg<MongoGridFsClient> TYPE_ARG_0 = new TypeArg(o1 -> MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)o1), o1 -> o1.getDelegate());
    private static final TypeArg<MongoGridFsClient> TYPE_ARG_1 = new TypeArg(o1 -> MongoGridFsClient.newInstance((io.vertx.ext.mongo.MongoGridFsClient)o1), o1 -> o1.getDelegate());
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClient that = (MongoClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
        this.delegate = delegate;
    }

    public MongoClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
    }

    public io.vertx.ext.mongo.MongoClient getDelegate() {
        return this.delegate;
    }

    public static MongoClient create(io.vertx.reactivex.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.create((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, JsonObject config, String dataSourceName) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)dataSourceName));
        return ret;
    }

    public static MongoClient createShared(io.vertx.reactivex.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public Future<String> save(String collection, JsonObject document) {
        Future ret = this.delegate.save(collection, document).map(val -> val);
        return ret;
    }

    public Maybe<String> rxSave(String collection, JsonObject document) {
        return AsyncResultMaybe.toMaybe($handler -> this.save(collection, document).onComplete($handler));
    }

    public Future<String> saveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        Future ret = this.delegate.saveWithOptions(collection, document, writeOption).map(val -> val);
        return ret;
    }

    public Maybe<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe($handler -> this.saveWithOptions(collection, document, writeOption).onComplete($handler));
    }

    public Future<String> insert(String collection, JsonObject document) {
        Future ret = this.delegate.insert(collection, document).map(val -> val);
        return ret;
    }

    public Maybe<String> rxInsert(String collection, JsonObject document) {
        return AsyncResultMaybe.toMaybe($handler -> this.insert(collection, document).onComplete($handler));
    }

    public Future<String> insertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        Future ret = this.delegate.insertWithOptions(collection, document, writeOption).map(val -> val);
        return ret;
    }

    public Maybe<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe($handler -> this.insertWithOptions(collection, document, writeOption).onComplete($handler));
    }

    public Future<MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonObject update) {
        Future ret = this.delegate.updateCollection(collection, query, update).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) {
        return AsyncResultMaybe.toMaybe($handler -> this.updateCollection(collection, query, update).onComplete($handler));
    }

    public Future<MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonArray update) {
        Future ret = this.delegate.updateCollection(collection, query, update).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonArray update) {
        return AsyncResultMaybe.toMaybe($handler -> this.updateCollection(collection, query, update).onComplete($handler));
    }

    public Future<MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        Future ret = this.delegate.updateCollectionWithOptions(collection, query, update, options).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return AsyncResultMaybe.toMaybe($handler -> this.updateCollectionWithOptions(collection, query, update, options).onComplete($handler));
    }

    public Future<MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        Future ret = this.delegate.updateCollectionWithOptions(collection, query, update, options).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        return AsyncResultMaybe.toMaybe($handler -> this.updateCollectionWithOptions(collection, query, update, options).onComplete($handler));
    }

    public Future<MongoClientUpdateResult> replaceDocuments(String collection, JsonObject query, JsonObject replace) {
        Future ret = this.delegate.replaceDocuments(collection, query, replace).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return AsyncResultMaybe.toMaybe($handler -> this.replaceDocuments(collection, query, replace).onComplete($handler));
    }

    public Future<MongoClientUpdateResult> replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        Future ret = this.delegate.replaceDocumentsWithOptions(collection, query, replace, options).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return AsyncResultMaybe.toMaybe($handler -> this.replaceDocumentsWithOptions(collection, query, replace, options).onComplete($handler));
    }

    public Future<MongoClientBulkWriteResult> bulkWrite(String collection, List<BulkOperation> operations) {
        Future ret = this.delegate.bulkWrite(collection, operations).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) {
        return AsyncResultMaybe.toMaybe($handler -> this.bulkWrite(collection, operations).onComplete($handler));
    }

    public Future<MongoClientBulkWriteResult> bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        Future ret = this.delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return AsyncResultMaybe.toMaybe($handler -> this.bulkWriteWithOptions(collection, operations, bulkWriteOptions).onComplete($handler));
    }

    public Future<List<JsonObject>> find(String collection, JsonObject query) {
        Future ret = this.delegate.find(collection, query).map(val -> val);
        return ret;
    }

    public Single<List<JsonObject>> rxFind(String collection, JsonObject query) {
        return AsyncResultSingle.toSingle($handler -> this.find(collection, query).onComplete($handler));
    }

    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatch(collection, query), TypeArg.unknown());
        return ret;
    }

    public Future<List<JsonObject>> findWithOptions(String collection, JsonObject query, FindOptions options) {
        Future ret = this.delegate.findWithOptions(collection, query, options).map(val -> val);
        return ret;
    }

    public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.findWithOptions(collection, query, options).onComplete($handler));
    }

    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
        return ret;
    }

    public Future<JsonObject> findOne(String collection, JsonObject query, JsonObject fields) {
        Future ret = this.delegate.findOne(collection, query, fields).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOne(collection, query, fields).onComplete($handler));
    }

    public Future<JsonObject> findOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        Future ret = this.delegate.findOneAndUpdate(collection, query, update).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOneAndUpdate(collection, query, update).onComplete($handler));
    }

    public Future<JsonObject> findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        Future ret = this.delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).onComplete($handler));
    }

    public Future<JsonObject> findOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        Future ret = this.delegate.findOneAndReplace(collection, query, replace).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOneAndReplace(collection, query, replace).onComplete($handler));
    }

    public Future<JsonObject> findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        Future ret = this.delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).onComplete($handler));
    }

    public Future<JsonObject> findOneAndDelete(String collection, JsonObject query) {
        Future ret = this.delegate.findOneAndDelete(collection, query).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOneAndDelete(collection, query).onComplete($handler));
    }

    public Future<JsonObject> findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        Future ret = this.delegate.findOneAndDeleteWithOptions(collection, query, findOptions).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return AsyncResultMaybe.toMaybe($handler -> this.findOneAndDeleteWithOptions(collection, query, findOptions).onComplete($handler));
    }

    public Future<Long> count(String collection, JsonObject query) {
        Future ret = this.delegate.count(collection, query).map(val -> val);
        return ret;
    }

    public Single<Long> rxCount(String collection, JsonObject query) {
        return AsyncResultSingle.toSingle($handler -> this.count(collection, query).onComplete($handler));
    }

    public Future<Long> countWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        Future ret = this.delegate.countWithOptions(collection, query, countOptions).map(val -> val);
        return ret;
    }

    public Single<Long> rxCountWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        return AsyncResultSingle.toSingle($handler -> this.countWithOptions(collection, query, countOptions).onComplete($handler));
    }

    public Future<MongoClientDeleteResult> removeDocuments(String collection, JsonObject query) {
        Future ret = this.delegate.removeDocuments(collection, query).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) {
        return AsyncResultMaybe.toMaybe($handler -> this.removeDocuments(collection, query).onComplete($handler));
    }

    public Future<MongoClientDeleteResult> removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        Future ret = this.delegate.removeDocumentsWithOptions(collection, query, writeOption).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe($handler -> this.removeDocumentsWithOptions(collection, query, writeOption).onComplete($handler));
    }

    public Future<MongoClientDeleteResult> removeDocument(String collection, JsonObject query) {
        Future ret = this.delegate.removeDocument(collection, query).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) {
        return AsyncResultMaybe.toMaybe($handler -> this.removeDocument(collection, query).onComplete($handler));
    }

    public Future<MongoClientDeleteResult> removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        Future ret = this.delegate.removeDocumentWithOptions(collection, query, writeOption).map(val -> val);
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe($handler -> this.removeDocumentWithOptions(collection, query, writeOption).onComplete($handler));
    }

    public Future<Void> createCollection(String collectionName) {
        Future ret = this.delegate.createCollection(collectionName).map(val -> val);
        return ret;
    }

    public Completable rxCreateCollection(String collectionName) {
        return AsyncResultCompletable.toCompletable($handler -> this.createCollection(collectionName).onComplete($handler));
    }

    public Future<Void> createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        Future ret = this.delegate.createCollectionWithOptions(collectionName, collectionOptions).map(val -> val);
        return ret;
    }

    public Completable rxCreateCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return AsyncResultCompletable.toCompletable($handler -> this.createCollectionWithOptions(collectionName, collectionOptions).onComplete($handler));
    }

    public Future<List<String>> getCollections() {
        Future ret = this.delegate.getCollections().map(val -> val);
        return ret;
    }

    public Single<List<String>> rxGetCollections() {
        return AsyncResultSingle.toSingle($handler -> this.getCollections().onComplete($handler));
    }

    public Future<Void> dropCollection(String collection) {
        Future ret = this.delegate.dropCollection(collection).map(val -> val);
        return ret;
    }

    public Completable rxDropCollection(String collection) {
        return AsyncResultCompletable.toCompletable($handler -> this.dropCollection(collection).onComplete($handler));
    }

    public Future<Void> renameCollection(String oldCollectionName, String newCollectionName) {
        Future ret = this.delegate.renameCollection(oldCollectionName, newCollectionName).map(val -> val);
        return ret;
    }

    public Completable rxRenameCollection(String oldCollectionName, String newCollectionName) {
        return AsyncResultCompletable.toCompletable($handler -> this.renameCollection(oldCollectionName, newCollectionName).onComplete($handler));
    }

    public Future<Void> renameCollectionWithOptions(String oldCollectionName, String newCollectionName, RenameCollectionOptions collectionOptions) {
        Future ret = this.delegate.renameCollectionWithOptions(oldCollectionName, newCollectionName, collectionOptions).map(val -> val);
        return ret;
    }

    public Completable rxRenameCollectionWithOptions(String oldCollectionName, String newCollectionName, RenameCollectionOptions collectionOptions) {
        return AsyncResultCompletable.toCompletable($handler -> this.renameCollectionWithOptions(oldCollectionName, newCollectionName, collectionOptions).onComplete($handler));
    }

    public Future<Void> createIndex(String collection, JsonObject key) {
        Future ret = this.delegate.createIndex(collection, key).map(val -> val);
        return ret;
    }

    public Completable rxCreateIndex(String collection, JsonObject key) {
        return AsyncResultCompletable.toCompletable($handler -> this.createIndex(collection, key).onComplete($handler));
    }

    public Future<Void> createIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        Future ret = this.delegate.createIndexWithOptions(collection, key, options).map(val -> val);
        return ret;
    }

    public Completable rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return AsyncResultCompletable.toCompletable($handler -> this.createIndexWithOptions(collection, key, options).onComplete($handler));
    }

    public Future<Void> createIndexes(String collection, List<IndexModel> indexes) {
        Future ret = this.delegate.createIndexes(collection, indexes).map(val -> val);
        return ret;
    }

    public Completable rxCreateIndexes(String collection, List<IndexModel> indexes) {
        return AsyncResultCompletable.toCompletable($handler -> this.createIndexes(collection, indexes).onComplete($handler));
    }

    public Future<JsonArray> listIndexes(String collection) {
        Future ret = this.delegate.listIndexes(collection).map(val -> val);
        return ret;
    }

    public Single<JsonArray> rxListIndexes(String collection) {
        return AsyncResultSingle.toSingle($handler -> this.listIndexes(collection).onComplete($handler));
    }

    public Future<Void> dropIndex(String collection, String indexName) {
        Future ret = this.delegate.dropIndex(collection, indexName).map(val -> val);
        return ret;
    }

    public Completable rxDropIndex(String collection, String indexName) {
        return AsyncResultCompletable.toCompletable($handler -> this.dropIndex(collection, indexName).onComplete($handler));
    }

    public Future<Void> dropIndex(String collection, JsonObject key) {
        Future ret = this.delegate.dropIndex(collection, key).map(val -> val);
        return ret;
    }

    public Completable rxDropIndex(String collection, JsonObject key) {
        return AsyncResultCompletable.toCompletable($handler -> this.dropIndex(collection, key).onComplete($handler));
    }

    public Future<JsonObject> runCommand(String commandName, JsonObject command) {
        Future ret = this.delegate.runCommand(commandName, command).map(val -> val);
        return ret;
    }

    public Maybe<JsonObject> rxRunCommand(String commandName, JsonObject command) {
        return AsyncResultMaybe.toMaybe($handler -> this.runCommand(commandName, command).onComplete($handler));
    }

    public Future<JsonArray> distinct(String collection, String fieldName, String resultClassname) {
        Future ret = this.delegate.distinct(collection, fieldName, resultClassname).map(val -> val);
        return ret;
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) {
        return AsyncResultSingle.toSingle($handler -> this.distinct(collection, fieldName, resultClassname).onComplete($handler));
    }

    public Future<JsonArray> distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        Future ret = this.delegate.distinct(collection, fieldName, resultClassname, distinctOptions).map(val -> val);
        return ret;
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return AsyncResultSingle.toSingle($handler -> this.distinct(collection, fieldName, resultClassname, distinctOptions).onComplete($handler));
    }

    public Future<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        Future ret = this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query).map(val -> val);
        return ret;
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return AsyncResultSingle.toSingle($handler -> this.distinctWithQuery(collection, fieldName, resultClassname, query).onComplete($handler));
    }

    public Future<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        Future ret = this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).map(val -> val);
        return ret;
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return AsyncResultSingle.toSingle($handler -> this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).onComplete($handler));
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregate(collection, pipeline), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
        return ret;
    }

    public Future<MongoGridFsClient> createDefaultGridFsBucketService() {
        Future ret = this.delegate.createDefaultGridFsBucketService().map(val -> MongoGridFsClient.newInstance(val));
        return ret;
    }

    public Single<MongoGridFsClient> rxCreateDefaultGridFsBucketService() {
        return AsyncResultSingle.toSingle($handler -> this.createDefaultGridFsBucketService().onComplete($handler));
    }

    public Future<MongoGridFsClient> createGridFsBucketService(String bucketName) {
        Future ret = this.delegate.createGridFsBucketService(bucketName).map(val -> MongoGridFsClient.newInstance(val));
        return ret;
    }

    public Single<MongoGridFsClient> rxCreateGridFsBucketService(String bucketName) {
        return AsyncResultSingle.toSingle($handler -> this.createGridFsBucketService(bucketName).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        ReadStream<ChangeStreamDocument<JsonObject>> ret = ReadStream.newInstance(this.delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
        return ret;
    }

    public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
        return arg != null ? new MongoClient(arg) : null;
    }
}

