/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.grpc.client;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.GrpcWriteStream;
import io.vertx.grpc.common.WireFormat;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.Timer;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.grpc.client.GrpcClientResponse;
import io.vertx.reactivex.grpc.common.ServiceName;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

@RxGen(value=io.vertx.grpc.client.GrpcClientRequest.class)
public class GrpcClientRequest<Req, Resp>
extends io.vertx.reactivex.grpc.common.GrpcWriteStream<Req>
implements RxDelegate {
    public static final TypeArg<GrpcClientRequest> __TYPE_ARG = new TypeArg(obj -> new GrpcClientRequest((io.vertx.grpc.client.GrpcClientRequest)obj), GrpcClientRequest::getDelegate);
    private final io.vertx.grpc.client.GrpcClientRequest<Req, Resp> delegate;
    public final TypeArg<Req> __typeArg_0;
    public final TypeArg<Resp> __typeArg_1;
    private WriteStreamObserver<Req> observer;
    private WriteStreamSubscriber<Req> subscriber;
    private Future<GrpcClientResponse<Req, Resp>> cached_0;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcClientRequest that = (GrpcClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public GrpcClientRequest(io.vertx.grpc.client.GrpcClientRequest delegate) {
        super((GrpcWriteStream)delegate);
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
        this.__typeArg_1 = TypeArg.unknown();
    }

    public GrpcClientRequest(Object delegate, TypeArg<Req> typeArg_0, TypeArg<Resp> typeArg_1) {
        super((GrpcWriteStream)((io.vertx.grpc.client.GrpcClientRequest)delegate));
        this.delegate = (io.vertx.grpc.client.GrpcClientRequest)delegate;
        this.__typeArg_0 = typeArg_0;
        this.__typeArg_1 = typeArg_1;
    }

    public io.vertx.grpc.client.GrpcClientRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<Req> toObserver() {
        if (this.observer == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Req> toSubscriber() {
        if (this.subscriber == null) {
            Function conv = this.__typeArg_0.unwrap;
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate(), (Function)conv);
        }
        return this.subscriber;
    }

    @Override
    public Future<Void> write(Req data) {
        Future ret = this.delegate.write(this.__typeArg_0.unwrap(data)).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(Req data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    @Override
    public Future<Void> end(Req data) {
        Future ret = this.delegate.end(this.__typeArg_0.unwrap(data)).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(Req data) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    public GrpcClientRequest<Req, Resp> encoding(String encoding) {
        this.delegate.encoding(encoding);
        return this;
    }

    public GrpcClientRequest<Req, Resp> format(WireFormat format) {
        this.delegate.format(format);
        return this;
    }

    public GrpcClientRequest<Req, Resp> fullMethodName(String fullMethodName) {
        this.delegate.fullMethodName(fullMethodName);
        return this;
    }

    public GrpcClientRequest<Req, Resp> serviceName(ServiceName serviceName) {
        this.delegate.serviceName(serviceName.getDelegate());
        return this;
    }

    public GrpcClientRequest<Req, Resp> methodName(String methodName) {
        this.delegate.methodName(methodName);
        return this;
    }

    public Future<GrpcClientResponse<Req, Resp>> response() {
        Future ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.response().map(val -> GrpcClientResponse.newInstance(val, this.__typeArg_0, this.__typeArg_1));
        return ret;
    }

    public Single<GrpcClientResponse<Req, Resp>> rxResponse() {
        return AsyncResultSingle.toSingle($handler -> this.response().onComplete($handler));
    }

    @Override
    public GrpcClientRequest<Req, Resp> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public GrpcClientRequest<Req, Resp> setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public GrpcClientRequest<Req, Resp> drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public GrpcClientRequest<Req, Resp> timeout(long timeout, TimeUnit unit) {
        this.delegate.timeout(timeout, unit);
        return this;
    }

    public Timer deadline() {
        Timer ret = Timer.newInstance(this.delegate.deadline());
        return ret;
    }

    public GrpcClientRequest<Req, Resp> idleTimeout(long timeout) {
        this.delegate.idleTimeout(timeout);
        return this;
    }

    public HttpConnection connection() {
        HttpConnection ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public Future<GrpcClientResponse<Req, Resp>> send(Req item) {
        Future ret = this.delegate.send(this.__typeArg_0.unwrap(item)).map(val -> GrpcClientResponse.newInstance(val, this.__typeArg_0, this.__typeArg_1));
        return ret;
    }

    public Single<GrpcClientResponse<Req, Resp>> rxSend(Req item) {
        return AsyncResultSingle.toSingle($handler -> this.send(item).onComplete($handler));
    }

    public Future<GrpcClientResponse<Req, Resp>> send(ReadStream<Req> body) {
        Future ret = this.delegate.send(body.getDelegate()).map(val -> GrpcClientResponse.newInstance((io.vertx.grpc.client.GrpcClientResponse)val, this.__typeArg_0, this.__typeArg_1));
        return ret;
    }

    public Single<GrpcClientResponse<Req, Resp>> rxSend(ReadStream<Req> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(body).onComplete($handler));
    }

    public Future<GrpcClientResponse<Req, Resp>> send(Flowable<Req> body) {
        Future ret = this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj -> this.__typeArg_0.unwrap(obj)).resume()).map(val -> GrpcClientResponse.newInstance(val, this.__typeArg_0, this.__typeArg_1));
        return ret;
    }

    public Single<GrpcClientResponse<Req, Resp>> rxSend(Flowable<Req> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(body).onComplete($handler));
    }

    public static <Req, Resp> GrpcClientRequest<Req, Resp> newInstance(io.vertx.grpc.client.GrpcClientRequest arg) {
        return arg != null ? new GrpcClientRequest<Req, Resp>(arg) : null;
    }

    public static <Req, Resp> GrpcClientRequest<Req, Resp> newInstance(io.vertx.grpc.client.GrpcClientRequest arg, TypeArg<Req> __typeArg_Req, TypeArg<Resp> __typeArg_Resp) {
        return arg != null ? new GrpcClientRequest<Req, Resp>(arg, __typeArg_Req, __typeArg_Resp) : null;
    }
}

