/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.streams.WriteStream;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.SingleHelper;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import io.vertx.reactivex.core.http.ClientForm;
import io.vertx.reactivex.core.http.HttpClientResponse;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;

@RxGen(value=io.vertx.core.http.HttpClientRequest.class)
public class HttpClientRequest
implements RxDelegate,
io.vertx.reactivex.core.streams.WriteStream<Buffer> {
    public static final TypeArg<HttpClientRequest> __TYPE_ARG = new TypeArg(obj -> new HttpClientRequest((io.vertx.core.http.HttpClientRequest)obj), HttpClientRequest::getDelegate);
    private final io.vertx.core.http.HttpClientRequest delegate;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private static final TypeArg<HttpClientResponse> TYPE_ARG_0 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientResponse> TYPE_ARG_1 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientResponse> TYPE_ARG_2 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientResponse> TYPE_ARG_3 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientResponse> TYPE_ARG_4 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientResponse> TYPE_ARG_5 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpClientResponse> TYPE_ARG_6 = new TypeArg(o1 -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)o1), o1 -> o1.getDelegate());
    private MultiMap cached_0;
    private HttpConnection cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientRequest that = (HttpClientRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpClientRequest(io.vertx.core.http.HttpClientRequest delegate) {
        this.delegate = delegate;
    }

    public HttpClientRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpClientRequest)delegate;
    }

    public io.vertx.core.http.HttpClientRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Future<Void> write(Buffer data) {
        Future ret = this.delegate.write((Object)data).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(data).onComplete($handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpClientRequest authority(HostAndPort authority) {
        this.delegate.authority(authority);
        return this;
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        this.delegate.setFollowRedirects(followRedirects);
        return this;
    }

    public boolean isFollowRedirects() {
        boolean ret = this.delegate.isFollowRedirects();
        return ret;
    }

    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        this.delegate.setMaxRedirects(maxRedirects);
        return this;
    }

    public int getMaxRedirects() {
        int ret = this.delegate.getMaxRedirects();
        return ret;
    }

    public int numberOfRedirections() {
        int ret = this.delegate.numberOfRedirections();
        return ret;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public HttpMethod getMethod() {
        HttpMethod ret = this.delegate.getMethod();
        return ret;
    }

    public HttpClientRequest setMethod(HttpMethod method) {
        this.delegate.setMethod(method);
        return this;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public String getURI() {
        String ret = this.delegate.getURI();
        return ret;
    }

    public HttpClientRequest setURI(String uri) {
        this.delegate.setURI(uri);
        return this;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.headers();
        return ret;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest traceOperation(String op) {
        HttpClientRequest ret = HttpClientRequest.newInstance(this.delegate.traceOperation(op));
        return ret;
    }

    public String traceOperation() {
        String ret = this.delegate.traceOperation();
        return ret;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public Future<Void> write(String chunk) {
        Future ret = this.delegate.write(chunk).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxWrite(String chunk) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(chunk).onComplete($handler));
    }

    public Future<Void> write(String chunk, String enc) {
        Future ret = this.delegate.write(chunk, enc).map(val -> val);
        return ret;
    }

    public Completable rxWrite(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable($handler -> this.write(chunk, enc).onComplete($handler));
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        this.delegate.continueHandler(handler);
        return this;
    }

    public HttpClientRequest earlyHintsHandler(Handler<MultiMap> handler) {
        this.delegate.earlyHintsHandler(handler);
        return this;
    }

    public HttpClientRequest redirectHandler(final java.util.function.Function<HttpClientResponse, Future<HttpClientRequest>> handler) {
        this.delegate.redirectHandler((java.util.function.Function)new java.util.function.Function<io.vertx.core.http.HttpClientResponse, Future<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public Future<io.vertx.core.http.HttpClientRequest> apply(io.vertx.core.http.HttpClientResponse arg) {
                Future ret = (Future)handler.apply(HttpClientResponse.newInstance(arg));
                return ret.map(val -> val.getDelegate());
            }
        });
        return this;
    }

    public HttpClientRequest redirectHandler(final Function<HttpClientResponse, Single<HttpClientRequest>> handler) {
        this.delegate.redirectHandler((java.util.function.Function)new java.util.function.Function<io.vertx.core.http.HttpClientResponse, Future<io.vertx.core.http.HttpClientRequest>>(){

            @Override
            public Future<io.vertx.core.http.HttpClientRequest> apply(io.vertx.core.http.HttpClientResponse arg) {
                Single ret;
                try {
                    ret = (Single)handler.apply((Object)HttpClientResponse.newInstance(arg));
                }
                catch (Exception e) {
                    return Future.failedFuture((Throwable)e);
                }
                return SingleHelper.toFuture((Single)ret, obj -> obj.getDelegate());
            }
        });
        return this;
    }

    public Future<Void> sendHead() {
        Future ret = this.delegate.sendHead().map(val -> val);
        return ret;
    }

    public Completable rxSendHead() {
        return AsyncResultCompletable.toCompletable($handler -> this.sendHead().onComplete($handler));
    }

    public Future<HttpClientResponse> connect() {
        Future ret = this.delegate.connect().map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxConnect() {
        return AsyncResultSingle.toSingle($handler -> this.connect().onComplete($handler));
    }

    public Future<HttpClientResponse> response() {
        Future ret = this.delegate.response().map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxResponse() {
        return AsyncResultSingle.toSingle($handler -> this.response().onComplete($handler));
    }

    public Future<HttpClientResponse> send() {
        Future ret = this.delegate.send().map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxSend() {
        return AsyncResultSingle.toSingle($handler -> this.send().onComplete($handler));
    }

    public Future<HttpClientResponse> send(String body) {
        Future ret = this.delegate.send(body).map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxSend(String body) {
        return AsyncResultSingle.toSingle($handler -> this.send(body).onComplete($handler));
    }

    public Future<HttpClientResponse> send(Buffer body) {
        Future ret = this.delegate.send(body).map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxSend(Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(body).onComplete($handler));
    }

    public Future<HttpClientResponse> send(ClientForm form) {
        Future ret = this.delegate.send(form.getDelegate()).map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxSend(ClientForm form) {
        return AsyncResultSingle.toSingle($handler -> this.send(form).onComplete($handler));
    }

    public Future<HttpClientResponse> send(ReadStream<Buffer> body) {
        Future ret = this.delegate.send(body.getDelegate()).map(val -> HttpClientResponse.newInstance((io.vertx.core.http.HttpClientResponse)val));
        return ret;
    }

    public Single<HttpClientResponse> rxSend(ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(body).onComplete($handler));
    }

    public Future<HttpClientResponse> send(Flowable<Buffer> body) {
        Future ret = this.delegate.send(ReadStreamSubscriber.asReadStream(body, obj -> obj).resume()).map(val -> HttpClientResponse.newInstance(val));
        return ret;
    }

    public Single<HttpClientResponse> rxSend(Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.send(body).onComplete($handler));
    }

    @Override
    public Future<Void> end(String chunk) {
        Future ret = this.delegate.end(chunk).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(chunk).onComplete($handler));
    }

    public Future<Void> end(String chunk, String enc) {
        Future ret = this.delegate.end(chunk, enc).map(val -> val);
        return ret;
    }

    public Completable rxEnd(String chunk, String enc) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(chunk, enc).onComplete($handler));
    }

    @Override
    public Future<Void> end(Buffer chunk) {
        Future ret = this.delegate.end(chunk).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer chunk) {
        return AsyncResultCompletable.toCompletable($handler -> this.end(chunk).onComplete($handler));
    }

    @Override
    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    public HttpClientRequest idleTimeout(long timeout) {
        this.delegate.idleTimeout(timeout);
        return this;
    }

    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        this.delegate.pushHandler(Helper.convertHandler(handler, event -> HttpClientRequest.newInstance(event)));
        return this;
    }

    public Future<Void> reset() {
        Future ret = this.delegate.reset().map(val -> val);
        return ret;
    }

    public Completable rxReset() {
        return AsyncResultCompletable.toCompletable($handler -> this.reset().onComplete($handler));
    }

    public Future<Void> reset(long code) {
        Future ret = this.delegate.reset(code).map(val -> val);
        return ret;
    }

    public Completable rxReset(long code) {
        return AsyncResultCompletable.toCompletable($handler -> this.reset(code).onComplete($handler));
    }

    public Future<Void> reset(long code, Throwable cause) {
        Future ret = this.delegate.reset(code, cause).map(val -> val);
        return ret;
    }

    public Completable rxReset(long code, Throwable cause) {
        return AsyncResultCompletable.toCompletable($handler -> this.reset(code, cause).onComplete($handler));
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public Future<Void> writeCustomFrame(int type, int flags, Buffer payload) {
        Future ret = this.delegate.writeCustomFrame(type, flags, payload).map(val -> val);
        return ret;
    }

    public Completable rxWriteCustomFrame(int type, int flags, Buffer payload) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeCustomFrame(type, flags, payload).onComplete($handler));
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    public Future<Void> writeCustomFrame(HttpFrame frame) {
        Future ret = this.delegate.writeCustomFrame(frame).map(val -> val);
        return ret;
    }

    public Completable rxWriteCustomFrame(HttpFrame frame) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeCustomFrame(frame).onComplete($handler));
    }

    public HttpClientRequest setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    public StreamPriority getStreamPriority() {
        StreamPriority ret = this.delegate.getStreamPriority();
        return ret;
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    public static HttpClientRequest newInstance(io.vertx.core.http.HttpClientRequest arg) {
        return arg != null ? new HttpClientRequest(arg) : null;
    }
}

