/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.redis.client;

import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.redis.client.Redis;
import io.vertx.reactivex.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.RequestGrouping;
import io.vertx.redis.client.Response;
import java.util.List;

@RxGen(value=io.vertx.redis.client.RedisCluster.class)
public class RedisCluster {
    public static final TypeArg<RedisCluster> __TYPE_ARG = new TypeArg(obj -> new RedisCluster((io.vertx.redis.client.RedisCluster)obj), RedisCluster::getDelegate);
    private final io.vertx.redis.client.RedisCluster delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisCluster that = (RedisCluster)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisCluster(io.vertx.redis.client.RedisCluster delegate) {
        this.delegate = delegate;
    }

    public RedisCluster(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisCluster)delegate;
    }

    public io.vertx.redis.client.RedisCluster getDelegate() {
        return this.delegate;
    }

    public static RedisCluster create(Redis client) {
        RedisCluster ret = RedisCluster.newInstance(io.vertx.redis.client.RedisCluster.create((io.vertx.redis.client.Redis)client.getDelegate()));
        return ret;
    }

    public static RedisCluster create(RedisConnection connection) {
        RedisCluster ret = RedisCluster.newInstance(io.vertx.redis.client.RedisCluster.create((io.vertx.redis.client.RedisConnection)connection.getDelegate()));
        return ret;
    }

    public Future<List<Response>> onAllNodes(Request request) {
        Future ret = this.delegate.onAllNodes(request).map(val -> val);
        return ret;
    }

    public Single<List<Response>> rxOnAllNodes(Request request) {
        return AsyncResultSingle.toSingle($handler -> this.onAllNodes(request).onComplete($handler));
    }

    public Future<List<Response>> onAllMasterNodes(Request request) {
        Future ret = this.delegate.onAllMasterNodes(request).map(val -> val);
        return ret;
    }

    public Single<List<Response>> rxOnAllMasterNodes(Request request) {
        return AsyncResultSingle.toSingle($handler -> this.onAllMasterNodes(request).onComplete($handler));
    }

    public Future<RequestGrouping> groupByNodes(List<Request> requests) {
        Future ret = this.delegate.groupByNodes(requests).map(val -> val);
        return ret;
    }

    public Single<RequestGrouping> rxGroupByNodes(List<Request> requests) {
        return AsyncResultSingle.toSingle($handler -> this.groupByNodes(requests).onComplete($handler));
    }

    public static RedisCluster newInstance(io.vertx.redis.client.RedisCluster arg) {
        return arg != null ? new RedisCluster(arg) : null;
    }
}

