/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.http.ClientWebSocket;
import io.vertx.reactivex.core.http.WebSocket;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient
implements Measured {
    public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg(obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient)obj), WebSocketClient::getDelegate);
    private final io.vertx.core.http.WebSocketClient delegate;
    private static final TypeArg<WebSocket> TYPE_ARG_0 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<WebSocket> TYPE_ARG_1 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<WebSocket> TYPE_ARG_2 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<WebSocket> TYPE_ARG_3 = new TypeArg(o1 -> WebSocket.newInstance((io.vertx.core.http.WebSocket)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
        this.delegate = delegate;
    }

    public WebSocketClient(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
    }

    public io.vertx.core.http.WebSocketClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ClientWebSocket webSocket() {
        ClientWebSocket ret = ClientWebSocket.newInstance(this.delegate.webSocket());
        return ret;
    }

    public Future<WebSocket> connect(int port, String host, String requestURI) {
        Future ret = this.delegate.connect(port, host, requestURI).map(val -> WebSocket.newInstance(val));
        return ret;
    }

    public Single<WebSocket> rxConnect(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, requestURI).onComplete($handler));
    }

    public Future<WebSocket> connect(String host, String requestURI) {
        Future ret = this.delegate.connect(host, requestURI).map(val -> WebSocket.newInstance(val));
        return ret;
    }

    public Single<WebSocket> rxConnect(String host, String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.connect(host, requestURI).onComplete($handler));
    }

    public Future<WebSocket> connect(String requestURI) {
        Future ret = this.delegate.connect(requestURI).map(val -> WebSocket.newInstance(val));
        return ret;
    }

    public Single<WebSocket> rxConnect(String requestURI) {
        return AsyncResultSingle.toSingle($handler -> this.connect(requestURI).onComplete($handler));
    }

    public Future<WebSocket> connect(WebSocketConnectOptions options) {
        Future ret = this.delegate.connect(options).map(val -> WebSocket.newInstance(val));
        return ret;
    }

    public Single<WebSocket> rxConnect(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.connect(options).onComplete($handler));
    }

    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions options) {
        Future ret = this.delegate.updateSSLOptions(options).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options).onComplete($handler));
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        Future ret = this.delegate.updateSSLOptions(options, force).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, force).onComplete($handler));
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }

    public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
        return arg != null ? new WebSocketClient(arg) : null;
    }
}

