/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.net;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.net.ConnectOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;
    private static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_1 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_2 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_3 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<NetSocket> TYPE_ARG_4 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Future<NetSocket> connect(int port, String host) {
        Future ret = this.delegate.connect(port, host).map(val -> NetSocket.newInstance(val));
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host).onComplete($handler));
    }

    public Future<NetSocket> connect(int port, String host, String serverName) {
        Future ret = this.delegate.connect(port, host, serverName).map(val -> NetSocket.newInstance(val));
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(port, host, serverName).onComplete($handler));
    }

    public Future<NetSocket> connect(SocketAddress remoteAddress) {
        Future ret = this.delegate.connect(remoteAddress).map(val -> NetSocket.newInstance(val));
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return AsyncResultSingle.toSingle($handler -> this.connect(remoteAddress).onComplete($handler));
    }

    public Future<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        Future ret = this.delegate.connect(remoteAddress, serverName).map(val -> NetSocket.newInstance(val));
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultSingle.toSingle($handler -> this.connect(remoteAddress, serverName).onComplete($handler));
    }

    public Future<NetSocket> connect(ConnectOptions connectOptions) {
        Future ret = this.delegate.connect(connectOptions).map(val -> NetSocket.newInstance(val));
        return ret;
    }

    public Single<NetSocket> rxConnect(ConnectOptions connectOptions) {
        return AsyncResultSingle.toSingle($handler -> this.connect(connectOptions).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions options) {
        Future ret = this.delegate.updateSSLOptions(options).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options).onComplete($handler));
    }

    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        Future ret = this.delegate.updateSSLOptions(options, force).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ClientSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, force).onComplete($handler));
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

