/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.datagram;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    private static final TypeArg<DatagramSocket> TYPE_ARG_0 = new TypeArg(o1 -> DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public DatagramSocket(Object delegate) {
        this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Future<Void> send(Buffer packet, int port, String host) {
        Future ret = this.delegate.send(packet, port, host).map(val -> val);
        return ret;
    }

    public Completable rxSend(Buffer packet, int port, String host) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(packet, port, host).onComplete($handler));
    }

    public WriteStream<Buffer> sender(int port, String host) {
        WriteStream<Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), TypeArg.unknown());
        return ret;
    }

    public Future<Void> send(String str, int port, String host) {
        Future ret = this.delegate.send(str, port, host).map(val -> val);
        return ret;
    }

    public Completable rxSend(String str, int port, String host) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(str, port, host).onComplete($handler));
    }

    public Future<Void> send(String str, String enc, int port, String host) {
        Future ret = this.delegate.send(str, enc, port, host).map(val -> val);
        return ret;
    }

    public Completable rxSend(String str, String enc, int port, String host) {
        return AsyncResultCompletable.toCompletable($handler -> this.send(str, enc, port, host).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.localAddress();
        return ret;
    }

    public Future<Void> listenMulticastGroup(String multicastAddress) {
        Future ret = this.delegate.listenMulticastGroup(multicastAddress).map(val -> val);
        return ret;
    }

    public Completable rxListenMulticastGroup(String multicastAddress) {
        return AsyncResultCompletable.toCompletable($handler -> this.listenMulticastGroup(multicastAddress).onComplete($handler));
    }

    public Future<Void> listenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        Future ret = this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source).map(val -> val);
        return ret;
    }

    public Completable rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultCompletable.toCompletable($handler -> this.listenMulticastGroup(multicastAddress, networkInterface, source).onComplete($handler));
    }

    public Future<Void> unlistenMulticastGroup(String multicastAddress) {
        Future ret = this.delegate.unlistenMulticastGroup(multicastAddress).map(val -> val);
        return ret;
    }

    public Completable rxUnlistenMulticastGroup(String multicastAddress) {
        return AsyncResultCompletable.toCompletable($handler -> this.unlistenMulticastGroup(multicastAddress).onComplete($handler));
    }

    public Future<Void> unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        Future ret = this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source).map(val -> val);
        return ret;
    }

    public Completable rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultCompletable.toCompletable($handler -> this.unlistenMulticastGroup(multicastAddress, networkInterface, source).onComplete($handler));
    }

    public Future<Void> blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        Future ret = this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock).map(val -> val);
        return ret;
    }

    public Completable rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return AsyncResultCompletable.toCompletable($handler -> this.blockMulticastGroup(multicastAddress, sourceToBlock).onComplete($handler));
    }

    public Future<Void> blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        Future ret = this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).map(val -> val);
        return ret;
    }

    public Completable rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return AsyncResultCompletable.toCompletable($handler -> this.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock).onComplete($handler));
    }

    public Future<DatagramSocket> listen(int port, String host) {
        Future ret = this.delegate.listen(port, host).map(val -> DatagramSocket.newInstance(val));
        return ret;
    }

    public Single<DatagramSocket> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, host).onComplete($handler));
    }

    public DatagramSocket handler(Handler<DatagramPacket> handler) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.handler(handler));
        return ret;
    }

    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.exceptionHandler(handler));
        return ret;
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

