/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.cli;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The completion object
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.cli.Completion original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.cli.Completion.class)
public class Completion implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Completion that = (Completion) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Completion> __TYPE_ARG = new TypeArg<>(    obj -> new Completion((io.vertx.ext.shell.cli.Completion) obj),
    Completion::getDelegate
  );

  private final io.vertx.ext.shell.cli.Completion delegate;
  
  public Completion(io.vertx.ext.shell.cli.Completion delegate) {
    this.delegate = delegate;
  }

  public Completion(Object delegate) {
    this.delegate = (io.vertx.ext.shell.cli.Completion)delegate;
  }

  @Override 
  public io.vertx.ext.shell.cli.Completion getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.shell.cli.CliToken> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.shell.cli.CliToken>(o1 -> io.vertx.reactivex.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)o1), o1 -> o1.getDelegate());

  /**
   * @return the current Vert.x instance
   */
  public io.vertx.reactivex.core.Vertx vertx() { 
    io.vertx.reactivex.core.Vertx ret = io.vertx.reactivex.core.Vertx.newInstance((io.vertx.core.Vertx)delegate.vertx());
    return ret;
  }

  /**
   * @return the shell current session, useful for accessing data like the current path for file completion, etc...
   */
  public io.vertx.reactivex.ext.shell.session.Session session() { 
    io.vertx.reactivex.ext.shell.session.Session ret = io.vertx.reactivex.ext.shell.session.Session.newInstance((io.vertx.ext.shell.session.Session)delegate.session());
    return ret;
  }

  /**
   * @return the current line being completed in raw format, i.e without any char escape performed
   */
  public java.lang.String rawLine() { 
    java.lang.String ret = delegate.rawLine();
    return ret;
  }

  /**
   * @return the current line being completed as preparsed tokens
   */
  public java.util.List<io.vertx.reactivex.ext.shell.cli.CliToken> lineTokens() { 
    java.util.List<io.vertx.reactivex.ext.shell.cli.CliToken> ret = delegate.lineTokens().stream().map(elt -> io.vertx.reactivex.ext.shell.cli.CliToken.newInstance((io.vertx.ext.shell.cli.CliToken)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * End the completion with a list of candidates, these candidates will be displayed by the shell on the console.
   * @param candidates the candidates
   */
  public void complete(java.util.List<java.lang.String> candidates) { 
    delegate.complete(candidates);
  }

  /**
   * End the completion with a value that will be inserted to complete the line.
   * @param value the value to complete with
   * @param terminal true if the value is terminal, i.e can be further completed
   */
  public void complete(java.lang.String value, boolean terminal) { 
    delegate.complete(value, terminal);
  }

  public static Completion newInstance(io.vertx.ext.shell.cli.Completion arg) {
    return arg != null ? new Completion(arg) : null;
  }

}
