/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.cassandra;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Eclipse Vert.x Cassandra client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.cassandra.CassandraClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.cassandra.CassandraClient.class)
public class CassandraClient implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CassandraClient that = (CassandraClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg<>(    obj -> new CassandraClient((io.vertx.cassandra.CassandraClient) obj),
    CassandraClient::getDelegate
  );

  private final io.vertx.cassandra.CassandraClient delegate;
  
  public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
    this.delegate = delegate;
  }

  public CassandraClient(Object delegate) {
    this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
  }

  @Override 
  public io.vertx.cassandra.CassandraClient getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#create} with default options.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Cassandra client which maintains its own driver session.
   * <p>
   * It is not recommended to create several non shared clients in an application.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.cassandra.CassandraClient create(io.vertx.reactivex.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default options and client name.
   * @param vertx 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default options.
   * @param vertx 
   * @param clientName 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientName) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.cassandra.CassandraClient#createShared} with default client name.
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a Cassandra client that shares its driver session with any other client having the same name.
   * @param vertx the Vert.x instance
   * @param clientName the shared client name
   * @param options the options
   * @return the client
   */
  public static io.vertx.reactivex.cassandra.CassandraClient createShared(io.vertx.reactivex.core.Vertx vertx, java.lang.String clientName, io.vertx.cassandra.CassandraClientOptions options) { 
    io.vertx.reactivex.cassandra.CassandraClient ret = io.vertx.reactivex.cassandra.CassandraClient.newInstance((io.vertx.cassandra.CassandraClient)io.vertx.cassandra.CassandraClient.createShared(vertx.getDelegate(), clientName, options));
    return ret;
  }

  /**
   * @return whether this Cassandra client instance is connected
   */
  public boolean isConnected() { 
    boolean ret = delegate.isConnected();
    return ret;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @param resultHandler handler called when result of execution is present, but can be not fully fetched
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient execute(java.lang.String query, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.cassandra.ResultSet>> resultHandler) { 
    delegate.execute(query, io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient execute(java.lang.String query) {
    return 
execute(query, ar -> { });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.ResultSet> rxExecute(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      execute(query, $handler);
    });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param rowStreamHandler the handler which is called once the operation completes. It will return an instance of {@link io.vertx.reactivex.cassandra.CassandraRowStream}.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient queryStream(java.lang.String sql, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.cassandra.CassandraRowStream>> rowStreamHandler) { 
    delegate.queryStream(sql, io.vertx.lang.reactivex.Helper.convertHandler(rowStreamHandler, ar -> ar.map(event -> io.vertx.reactivex.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)event))));
    return this;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient queryStream(java.lang.String sql) {
    return 
queryStream(sql, ar -> { });
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.CassandraRowStream> rxQueryStream(java.lang.String sql) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryStream(sql, $handler);
    });
  }

  /**
   * Closes this client.
   * @param closeHandler handler called when client is closed
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> closeHandler) { 
    delegate.close(closeHandler);
    return this;
  }

  /**
   * Closes this client.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient close() {
    return 
close(ar -> { });
  }

  /**
   * Closes this client.
   * @return current Cassandra client instance
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @param resultHandler handler called when result of execution is fully fetched.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient executeWithFullFetch(java.lang.String query, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<com.datastax.oss.driver.api.core.cql.Row>>> resultHandler) { 
    delegate.executeWithFullFetch(query, resultHandler);
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient executeWithFullFetch(java.lang.String query) {
    return 
executeWithFullFetch(query, ar -> { });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param query the query to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxExecuteWithFullFetch(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      executeWithFullFetch(query, $handler);
    });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @param resultHandler handler called when result of execution is fully fetched.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient executeWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.util.List<com.datastax.oss.driver.api.core.cql.Row>>> resultHandler) { 
    delegate.executeWithFullFetch(statement, resultHandler);
    return this;
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient executeWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) {
    return 
executeWithFullFetch(statement, ar -> { });
  }

  /**
   * Execute the query and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<java.util.List<com.datastax.oss.driver.api.core.cql.Row>> rxExecuteWithFullFetch(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      executeWithFullFetch(statement, $handler);
    });
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @param resultHandler handler called when result of execution is present
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient execute(com.datastax.oss.driver.api.core.cql.Statement statement, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.cassandra.ResultSet>> resultHandler) { 
    delegate.execute(statement, io.vertx.lang.reactivex.Helper.convertHandler(resultHandler, ar -> ar.map(event -> io.vertx.reactivex.cassandra.ResultSet.newInstance((io.vertx.cassandra.ResultSet)event))));
    return this;
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient execute(com.datastax.oss.driver.api.core.cql.Statement statement) {
    return 
execute(statement, ar -> { });
  }

  /**
   * Execute the statement and provide a handler for consuming results.
   * @param statement the statement to execute
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.ResultSet> rxExecute(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      execute(statement, $handler);
    });
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @param resultHandler handler called when result of query preparation is present
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient prepare(java.lang.String query, io.vertx.core.Handler<io.vertx.core.AsyncResult<com.datastax.oss.driver.api.core.cql.PreparedStatement>> resultHandler) { 
    delegate.prepare(query, resultHandler);
    return this;
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient prepare(java.lang.String query) {
    return 
prepare(query, ar -> { });
  }

  /**
   * Prepares the provided query string.
   * @param query the query to prepare
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> rxPrepare(java.lang.String query) { 
    return AsyncResultSingle.toSingle($handler -> {
      prepare(query, $handler);
    });
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @param resultHandler handler called when result of query preparation is present
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient prepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement, io.vertx.core.Handler<io.vertx.core.AsyncResult<com.datastax.oss.driver.api.core.cql.PreparedStatement>> resultHandler) { 
    delegate.prepare(statement, resultHandler);
    return this;
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient prepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) {
    return 
prepare(statement, ar -> { });
  }

  /**
   * Prepares the provided a .
   * @param statement the statement to prepare
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<com.datastax.oss.driver.api.core.cql.PreparedStatement> rxPrepare(com.datastax.oss.driver.api.core.cql.SimpleStatement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      prepare(statement, $handler);
    });
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @param rowStreamHandler the handler which is called once the operation completes. It will return an instance of {@link io.vertx.reactivex.cassandra.CassandraRowStream}.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient queryStream(com.datastax.oss.driver.api.core.cql.Statement statement, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.cassandra.CassandraRowStream>> rowStreamHandler) { 
    delegate.queryStream(statement, io.vertx.lang.reactivex.Helper.convertHandler(rowStreamHandler, ar -> ar.map(event -> io.vertx.reactivex.cassandra.CassandraRowStream.newInstance((io.vertx.cassandra.CassandraRowStream)event))));
    return this;
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return current Cassandra client instance
   */
  public io.vertx.reactivex.cassandra.CassandraClient queryStream(com.datastax.oss.driver.api.core.cql.Statement statement) {
    return 
queryStream(statement, ar -> { });
  }

  /**
   * Executes the given SQL statement which returns the results of the query as a read stream.
   * @param statement the statement to execute.
   * @return current Cassandra client instance
   */
  public io.reactivex.Single<io.vertx.reactivex.cassandra.CassandraRowStream> rxQueryStream(com.datastax.oss.driver.api.core.cql.Statement statement) { 
    return AsyncResultSingle.toSingle($handler -> {
      queryStream(statement, $handler);
    });
  }

  /**
   * Get  for the session.
   * @param handler the handler called backed with the metadata
   */
  public void metadata(io.vertx.core.Handler<io.vertx.core.AsyncResult<com.datastax.oss.driver.api.core.metadata.Metadata>> handler) { 
    delegate.metadata(handler);
  }

  /**
   * Get  for the session.
   */
  public void metadata() {
    metadata(ar -> { });
  }

  /**
   * Get  for the session.
   * @return 
   */
  public io.reactivex.Single<com.datastax.oss.driver.api.core.metadata.Metadata> rxMetadata() { 
    return AsyncResultSingle.toSingle($handler -> {
      metadata($handler);
    });
  }

  /**
   * The default shared client name.
   */
  public static final java.lang.String DEFAULT_SHARED_CLIENT_NAME = io.vertx.cassandra.CassandraClient.DEFAULT_SHARED_CLIENT_NAME;
  public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
    return arg != null ? new CassandraClient(arg) : null;
  }

}
