/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.json.schema;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A validator, validates some input object using a well known schema.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.json.schema.Validator original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.json.schema.Validator.class)
public class Validator implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Validator that = (Validator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Validator> __TYPE_ARG = new TypeArg<>(    obj -> new Validator((io.vertx.json.schema.Validator) obj),
    Validator::getDelegate
  );

  private final io.vertx.json.schema.Validator delegate;
  
  public Validator(io.vertx.json.schema.Validator delegate) {
    this.delegate = delegate;
  }

  public Validator(Object delegate) {
    this.delegate = (io.vertx.json.schema.Validator)delegate;
  }

  @Override 
  public io.vertx.json.schema.Validator getDelegate() {
    return delegate;
  }

  /**
   * Creates a new validator with some initial schema and options.
   * <p>
   * When validation is to be reused, it is recommended to create a {@link io.vertx.reactivex.json.schema.SchemaRepository} instance and use the
   * {@link io.vertx.reactivex.json.schema.SchemaRepository#validator}} method. The use of a {@link java.lang.String} key allows avoiding re-parsing
   * and fast lookups.
   * @param schema the initial schema
   * @param options the validator options
   * @return a validator instance
   */
  public static io.vertx.reactivex.json.schema.Validator create(io.vertx.reactivex.json.schema.JsonSchema schema, io.vertx.json.schema.JsonSchemaOptions options) { 
    io.vertx.reactivex.json.schema.Validator ret = io.vertx.reactivex.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)io.vertx.json.schema.Validator.create(schema.getDelegate(), options));
    return ret;
  }

  /**
   * Creates a new validator with some initial schema, options and a custom JSON format validator.
   *
   * When validation is to be reused, it is recommended to create a {@link io.vertx.reactivex.json.schema.SchemaRepository} instance and use the
   * {@link io.vertx.reactivex.json.schema.SchemaRepository#validator}} method. The use of a {@link java.lang.String} key allows avoiding re-parsing
   * and fast lookups.
   * @param schema the initial schema
   * @param options the validator options
   * @param jsonFormatValidator the custom JSON format validator
   * @return a validator instance
   */
  public static io.vertx.reactivex.json.schema.Validator create(io.vertx.reactivex.json.schema.JsonSchema schema, io.vertx.json.schema.JsonSchemaOptions options, io.vertx.reactivex.json.schema.JsonFormatValidator jsonFormatValidator) { 
    io.vertx.reactivex.json.schema.Validator ret = io.vertx.reactivex.json.schema.Validator.newInstance((io.vertx.json.schema.Validator)io.vertx.json.schema.Validator.create(schema.getDelegate(), options, jsonFormatValidator.getDelegate()));
    return ret;
  }

  /**
   * Validate a given input against the initial schema.
   * @param instance instance to validate
   * @return returns a output unit object as defined by the options
   */
  public io.vertx.json.schema.OutputUnit validate(java.lang.Object instance) { 
    io.vertx.json.schema.OutputUnit ret = delegate.validate(instance);
    return ret;
  }

  public static Validator newInstance(io.vertx.json.schema.Validator arg) {
    return arg != null ? new Validator(arg) : null;
  }

}
