/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.reactivex.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.reactivex.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements RxDelegate, io.vertx.reactivex.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  public HttpServer(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServer)delegate;
  }

  @Override 
  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.core.http.HttpServerRequest> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.core.http.HttpServerRequest>(o1 -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.core.http.ServerWebSocket> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.core.http.ServerWebSocket>(o1 -> io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the request stream for the server. As HTTP requests are received by the server,
   * instances of {@link io.vertx.reactivex.core.http.HttpServerRequest} will be created and passed to the stream {@link io.vertx.reactivex.core.streams.ReadStream#handler}.
   * @return the request stream
   */
  @Deprecated()
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.HttpServerRequest> requestStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.HttpServerRequest> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.requestStream(), TYPE_ARG_0);
    cached_0 = ret;
    return ret;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.reactivex.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer requestHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event)));
    return this;
  }

  /**
   * Set a <code>handler</code> for handling invalid requests. When an invalid request is received by the server
   * this handler will be called with the request. The handler can send any HTTP response, when the response
   * ends, the server shall close the connection. {@link io.vertx.reactivex.core.http.HttpServerRequest#decoderResult} can be used
   * to obtain the Netty decoder result and the failure cause reported by the decoder.
   *
   * <p> Currently this handler is only used for HTTP/1.x requests.
   *
   * <p> When no specific handler is set, the {@link io.vertx.reactivex.core.http.HttpServerRequest} is used.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer invalidRequestHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpServerRequest> handler) { 
    io.vertx.reactivex.core.http.HttpServer ret = io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.invalidRequestHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event))));
    return ret;
  }

  /**
   * Set a connection handler for the server.
   * <br/>
   * The handler will always be called on the event-loop thread.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer connectionHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event)));
    return this;
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Return the WebSocket stream for the server. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the stream {@link io.vertx.reactivex.core.streams.ReadStream#handler}.
   * @return the WebSocket stream
   */
  @Deprecated()
  public io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> webSocketStream() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> ret = io.vertx.reactivex.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.webSocketStream(), TYPE_ARG_1);
    cached_1 = ret;
    return ret;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.reactivex.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.core.http.HttpServer webSocketHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event)));
    return this;
  }

  /**
   * Set a handler for WebSocket handshake.
   *
   * <p>When an inbound HTTP request presents a WebSocket upgrade, this handler is called first. The handler
   * can chose to {@link io.vertx.reactivex.core.http.ServerWebSocketHandshake#accept} or {@link io.vertx.reactivex.core.http.ServerWebSocketHandshake#reject} the request.</p>
   *
   * <p>Setting no handler, implicitly accepts any HTTP request connection presenting an upgrade header and upgrades it
   * to a WebSocket.</p>
   * @param handler 
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer webSocketHandshakeHandler(io.vertx.core.Handler<io.vertx.reactivex.core.http.ServerWebSocketHandshake> handler) { 
    delegate.webSocketHandshakeHandler(io.vertx.lang.reactivex.Helper.convertHandler(handler, event -> io.vertx.reactivex.core.http.ServerWebSocketHandshake.newInstance((io.vertx.core.http.ServerWebSocketHandshake)event)));
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param handler the update handler
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> handler) { 
    delegate.updateSSLOptions(options, handler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options) {
    updateSSLOptions(options, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @return 
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return AsyncResultSingle.toSingle($handler -> {
      updateSSLOptions(options, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @param handler the update handler
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force, io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Boolean>> handler) { 
    delegate.updateSSLOptions(options, force, handler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   */
  public void updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) {
    updateSSLOptions(options, force, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return 
   */
  public io.reactivex.Single<java.lang.Boolean> rxUpdateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    return AsyncResultSingle.toSingle($handler -> {
      updateSSLOptions(options, force, $handler);
    });
  }

  /**
   * Update traffic shaping options <code>options</code>, the update happens if valid values are passed for traffic
   * shaping options. This update happens synchronously and at best effort for rate update to take effect immediately.
   * @param options the new traffic shaping options
   */
  public void updateTrafficShapingOptions(io.vertx.core.net.TrafficShapingOptions options) { 
    delegate.updateTrafficShapingOptions(options);
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port, java.lang.String host, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, host, io.vertx.lang.reactivex.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port, java.lang.String host) {
    return 
listen(port, host, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle($handler -> {
      listen(port, host, $handler);
    });
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(io.vertx.reactivex.core.net.SocketAddress address, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(address.getDelegate(), io.vertx.lang.reactivex.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)event))));
    return this;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(io.vertx.reactivex.core.net.SocketAddress address) {
    return 
listen(address, ar -> { });
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen(io.vertx.reactivex.core.net.SocketAddress address) { 
    return AsyncResultSingle.toSingle($handler -> {
      listen(address, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port, io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(port, io.vertx.lang.reactivex.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(int port) {
    return 
listen(port, ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle($handler -> {
      listen(port, $handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param listenHandler the listen handler
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.core.http.HttpServer>> listenHandler) { 
    delegate.listen(io.vertx.lang.reactivex.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.reactivex.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)event))));
    return this;
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public io.vertx.reactivex.core.http.HttpServer listen() {
    return 
listen(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.core.http.HttpServer> rxListen() { 
    return AsyncResultSingle.toSingle($handler -> {
      listen($handler);
    });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @param completionHandler the handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Like {@link io.vertx.reactivex.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  private io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.HttpServerRequest> cached_0;
  private io.vertx.reactivex.core.streams.ReadStream<io.vertx.reactivex.core.http.ServerWebSocket> cached_1;
  public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
