/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.micrometer;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.micrometer.PrometheusScrapingHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.micrometer.PrometheusScrapingHandler.class)
public class PrometheusScrapingHandler implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PrometheusScrapingHandler that = (PrometheusScrapingHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PrometheusScrapingHandler> __TYPE_ARG = new TypeArg<>(    obj -> new PrometheusScrapingHandler((io.vertx.micrometer.PrometheusScrapingHandler) obj),
    PrometheusScrapingHandler::getDelegate
  );

  private final io.vertx.micrometer.PrometheusScrapingHandler delegate;
  
  public PrometheusScrapingHandler(io.vertx.micrometer.PrometheusScrapingHandler delegate) {
    this.delegate = delegate;
  }

  public PrometheusScrapingHandler(Object delegate) {
    this.delegate = (io.vertx.micrometer.PrometheusScrapingHandler)delegate;
  }

  @Override 
  public io.vertx.micrometer.PrometheusScrapingHandler getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.ext.web.RoutingContext> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o1 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.web.RoutingContext> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o1 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.ext.web.RoutingContext> TYPE_ARG_2 = new TypeArg<io.vertx.reactivex.ext.web.RoutingContext>(o1 -> io.vertx.reactivex.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)o1), o1 -> o1.getDelegate());

  /**
   * Creates a Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
   * The default backend registry is used.
   * @return a {@link io.vertx.reactivex.ext.web.Route} handler for the default backend registry
   */
  public static io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> create() { 
    io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create().handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Creates a Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
   * The registry specified by <code>registryName</code> is used.
   * @param registryName the backend metrics registry
   * @return a {@link io.vertx.reactivex.ext.web.Route} handler for a specific metrics registry
   */
  public static io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> create(java.lang.String registryName) { 
    io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create(registryName).handle(event.getDelegate());
      }
    };
    return ret;
  }

  /**
   * Creates a Vert.x Web {@link io.vertx.reactivex.ext.web.Route} handler for Prometheus metrics scraping.
   * The registry specified by <code>registry</code> is used.
   * @param registry the backend metrics registry
   * @return a {@link io.vertx.reactivex.ext.web.Route} handler for a specific metrics registry
   */
  public static io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> create(io.micrometer.prometheus.PrometheusMeterRegistry registry) { 
    io.vertx.core.Handler<io.vertx.reactivex.ext.web.RoutingContext> ret = new Handler<io.vertx.reactivex.ext.web.RoutingContext>() {
      public void handle(io.vertx.reactivex.ext.web.RoutingContext event) {
          io.vertx.micrometer.PrometheusScrapingHandler.create(registry).handle(event.getDelegate());
      }
    };
    return ret;
  }

  public static PrometheusScrapingHandler newInstance(io.vertx.micrometer.PrometheusScrapingHandler arg) {
    return arg != null ? new PrometheusScrapingHandler(arg) : null;
  }

}
