/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.http;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A WebSocket frame that represents either text or binary data.
 * <p>
 * A WebSocket message is composed of one or more WebSocket frames.
 * <p>
 * If there is a just a single frame in the message then a single text or binary frame should be created with final = true.
 * <p>
 * If there are more than one frames in the message, then the first frame should be a text or binary frame with
 * final = false, followed by one or more continuation frames. The last continuation frame should have final = true.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketFrame original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.WebSocketFrame.class)
public class WebSocketFrame implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebSocketFrame that = (WebSocketFrame) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<WebSocketFrame> __TYPE_ARG = new TypeArg<>(    obj -> new WebSocketFrame((io.vertx.core.http.WebSocketFrame) obj),
    WebSocketFrame::getDelegate
  );

  private final io.vertx.core.http.WebSocketFrame delegate;
  
  public WebSocketFrame(io.vertx.core.http.WebSocketFrame delegate) {
    this.delegate = delegate;
  }

  public WebSocketFrame(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketFrame)delegate;
  }

  @Override 
  public io.vertx.core.http.WebSocketFrame getDelegate() {
    return delegate;
  }

  /**
   * Create a binary WebSocket frame.
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.reactivex.core.http.WebSocketFrame binaryFrame(io.vertx.reactivex.core.buffer.Buffer data, boolean isFinal) { 
    io.vertx.reactivex.core.http.WebSocketFrame ret = io.vertx.reactivex.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.binaryFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * Create a text WebSocket frame.
   * @param str the string for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.reactivex.core.http.WebSocketFrame textFrame(java.lang.String str, boolean isFinal) { 
    io.vertx.reactivex.core.http.WebSocketFrame ret = io.vertx.reactivex.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.textFrame(str, isFinal));
    return ret;
  }

  /**
   * Create a ping WebSocket frame.  Will be a final frame. There is no option for non final ping frames.
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static io.vertx.reactivex.core.http.WebSocketFrame pingFrame(io.vertx.reactivex.core.buffer.Buffer data) { 
    io.vertx.reactivex.core.http.WebSocketFrame ret = io.vertx.reactivex.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.pingFrame(data.getDelegate()));
    return ret;
  }

  /**
   * Create a pong WebSocket frame.  Will be a final frame. There is no option for non final pong frames.
   * @param data the bytes for the frame, may be at most 125 bytes
   * @return the frame
   */
  public static io.vertx.reactivex.core.http.WebSocketFrame pongFrame(io.vertx.reactivex.core.buffer.Buffer data) { 
    io.vertx.reactivex.core.http.WebSocketFrame ret = io.vertx.reactivex.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.pongFrame(data.getDelegate()));
    return ret;
  }

  /**
   * Create a continuation frame
   * @param data the data for the frame
   * @param isFinal true if it's the final frame in the WebSocket message
   * @return the frame
   */
  public static io.vertx.reactivex.core.http.WebSocketFrame continuationFrame(io.vertx.reactivex.core.buffer.Buffer data, boolean isFinal) { 
    io.vertx.reactivex.core.http.WebSocketFrame ret = io.vertx.reactivex.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)io.vertx.core.http.WebSocketFrame.continuationFrame(data.getDelegate(), isFinal));
    return ret;
  }

  /**
   * @return the frame type
   */
  public io.vertx.core.http.WebSocketFrameType type() { 
    io.vertx.core.http.WebSocketFrameType ret = delegate.type();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isText() { 
    boolean ret = delegate.isText();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isBinary() { 
    boolean ret = delegate.isBinary();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isContinuation() { 
    boolean ret = delegate.isContinuation();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isClose() { 
    boolean ret = delegate.isClose();
    return ret;
  }

  /**
   * @return whether the frame is a  frame
   */
  public boolean isPing() { 
    boolean ret = delegate.isPing();
    return ret;
  }

  /**
   * @return the content of this frame as a UTF-8 string and returns the converted string. Only use this for text frames.
   */
  public java.lang.String textData() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.textData();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the data of the frame
   */
  public io.vertx.reactivex.core.buffer.Buffer binaryData() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.reactivex.core.buffer.Buffer ret = io.vertx.reactivex.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.binaryData());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this is the final frame.
   */
  public boolean isFinal() { 
    boolean ret = delegate.isFinal();
    return ret;
  }

  /**
   * @return status code of close frame. Only use this for close frames
   */
  public short closeStatusCode() { 
    short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * @return string explaining close reason. Only use this for close frames
   */
  public java.lang.String closeReason() { 
    java.lang.String ret = delegate.closeReason();
    return ret;
  }

  private java.lang.String cached_0;
  private io.vertx.reactivex.core.buffer.Buffer cached_1;
  public static WebSocketFrame newInstance(io.vertx.core.http.WebSocketFrame arg) {
    return arg != null ? new WebSocketFrame(arg) : null;
  }

}
