/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.circuitbreaker;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A failure policy for the {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker}.
 * <p>
 * The default policy is to consider an asynchronous result as a failure if  returns <code>true</code>.
 * Nevertheless, sometimes this is not good enough. For example, an HTTP Client could return a response, but with an unexpected status code.
 * <p>
 * In this case, a custom failure policy can be configured with {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker#failurePolicy}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.FailurePolicy original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.circuitbreaker.FailurePolicy.class)
public class FailurePolicy<T> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FailurePolicy that = (FailurePolicy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FailurePolicy> __TYPE_ARG = new TypeArg<>(    obj -> new FailurePolicy((io.vertx.circuitbreaker.FailurePolicy) obj),
    FailurePolicy::getDelegate
  );

  private final io.vertx.circuitbreaker.FailurePolicy<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public FailurePolicy(io.vertx.circuitbreaker.FailurePolicy delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public FailurePolicy(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.circuitbreaker.FailurePolicy)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.circuitbreaker.FailurePolicy getDelegate() {
    return delegate;
  }


  /**
   * The default policy, which considers an asynchronous result as a failure if  returns <code>true</code>.
   * @return 
   */
  public static <U> io.vertx.reactivex.circuitbreaker.FailurePolicy<U> defaultPolicy() { 
    io.vertx.reactivex.circuitbreaker.FailurePolicy<U> ret = io.vertx.reactivex.circuitbreaker.FailurePolicy.newInstance((io.vertx.circuitbreaker.FailurePolicy)io.vertx.circuitbreaker.FailurePolicy.defaultPolicy(), TypeArg.unknown());
    return ret;
  }

  /**
   * Invoked by the {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker} when an operation completes.
   * @param future a completed future
   * @return <code>true</code> if the asynchronous result should be considered as a failure, <code>false</code> otherwise
   */
  public boolean test(io.vertx.core.Future<T> future) { 
    boolean ret = delegate.test(future.map(val -> __typeArg_0.<T>unwrap(val)));
    return ret;
  }

  /**
   * Invoked by the {@link io.vertx.reactivex.circuitbreaker.CircuitBreaker} when an operation completes.
   * @param future a completed future
   * @return <code>true</code> if the asynchronous result should be considered as a failure, <code>false</code> otherwise
   */
  public boolean test(io.reactivex.Single<T> future) { 
    boolean ret = delegate.test(io.vertx.reactivex.SingleHelper.toFuture(future, obj -> __typeArg_0.<T>unwrap(obj)));
    return ret;
  }

  public static <T> FailurePolicy<T> newInstance(io.vertx.circuitbreaker.FailurePolicy arg) {
    return arg != null ? new FailurePolicy<T>(arg) : null;
  }

  public static <T> FailurePolicy<T> newInstance(io.vertx.circuitbreaker.FailurePolicy arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new FailurePolicy<T>(arg, __typeArg_T) : null;
  }

}
