/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.stomp;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.stomp.Frame;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.Map;

@RxGen(value=io.vertx.ext.stomp.StompClientConnection.class)
public class StompClientConnection {
    public static final TypeArg<StompClientConnection> __TYPE_ARG = new TypeArg(obj -> new StompClientConnection((io.vertx.ext.stomp.StompClientConnection)obj), StompClientConnection::getDelegate);
    private final io.vertx.ext.stomp.StompClientConnection delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StompClientConnection that = (StompClientConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public StompClientConnection(io.vertx.ext.stomp.StompClientConnection delegate) {
        this.delegate = delegate;
    }

    public StompClientConnection(Object delegate) {
        this.delegate = (io.vertx.ext.stomp.StompClientConnection)delegate;
    }

    public io.vertx.ext.stomp.StompClientConnection getDelegate() {
        return this.delegate;
    }

    public String session() {
        String ret = this.delegate.session();
        return ret;
    }

    public String version() {
        String ret = this.delegate.version();
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public String server() {
        String ret = this.delegate.server();
        return ret;
    }

    public StompClientConnection send(Map<String, String> headers, Buffer body, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.send(headers, body.getDelegate(), receiptHandler);
        return this;
    }

    public StompClientConnection send(Map<String, String> headers, Buffer body) {
        return this.send(headers, body, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxSend(Map<String, String> headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(headers, body, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection send(String destination, Buffer body, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.send(destination, body.getDelegate(), receiptHandler);
        return this;
    }

    public StompClientConnection send(String destination, Buffer body) {
        return this.send(destination, body, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxSend(String destination, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(destination, body, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection send(Frame frame, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.send(frame, receiptHandler);
        return this;
    }

    public StompClientConnection send(Frame frame) {
        return this.send(frame, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxSend(Frame frame) {
        return AsyncResultSingle.toSingle($handler -> this.send(frame, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection send(String destination, Map<String, String> headers, Buffer body, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.send(destination, headers, body.getDelegate(), receiptHandler);
        return this;
    }

    public StompClientConnection send(String destination, Map<String, String> headers, Buffer body) {
        return this.send(destination, headers, body, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxSend(String destination, Map<String, String> headers, Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.send(destination, headers, body, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection subscribe(String destination, Handler<Frame> handler, Handler<AsyncResult<String>> receiptHandler) {
        this.delegate.subscribe(destination, handler, receiptHandler);
        return this;
    }

    public StompClientConnection subscribe(String destination, Handler<Frame> handler) {
        return this.subscribe(destination, handler, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxSubscribe(String destination, Handler<Frame> handler) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(destination, handler, (Handler<AsyncResult<String>>)$handler));
    }

    public StompClientConnection subscribe(String destination, Map<String, String> headers, Handler<Frame> handler, Handler<AsyncResult<String>> receiptHandler) {
        this.delegate.subscribe(destination, headers, handler, receiptHandler);
        return this;
    }

    public StompClientConnection subscribe(String destination, Map<String, String> headers, Handler<Frame> handler) {
        return this.subscribe(destination, headers, handler, (Handler<AsyncResult<String>>)((Handler)ar -> {}));
    }

    public Single<String> rxSubscribe(String destination, Map<String, String> headers, Handler<Frame> handler) {
        return AsyncResultSingle.toSingle($handler -> this.subscribe(destination, headers, handler, (Handler<AsyncResult<String>>)$handler));
    }

    public StompClientConnection unsubscribe(String destination, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.unsubscribe(destination, receiptHandler);
        return this;
    }

    public StompClientConnection unsubscribe(String destination) {
        return this.unsubscribe(destination, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxUnsubscribe(String destination) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(destination, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection unsubscribe(String destination, Map<String, String> headers, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.unsubscribe(destination, headers, receiptHandler);
        return this;
    }

    public StompClientConnection unsubscribe(String destination, Map<String, String> headers) {
        return this.unsubscribe(destination, headers, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxUnsubscribe(String destination, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.unsubscribe(destination, headers, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection errorHandler(Handler<Frame> handler) {
        StompClientConnection ret = StompClientConnection.newInstance(this.delegate.errorHandler(handler));
        return ret;
    }

    public StompClientConnection closeHandler(Handler<StompClientConnection> handler) {
        this.delegate.closeHandler((Handler)new DelegatingHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection connectionDroppedHandler(Handler<StompClientConnection> handler) {
        this.delegate.connectionDroppedHandler((Handler)new DelegatingHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection pingHandler(Handler<StompClientConnection> handler) {
        this.delegate.pingHandler((Handler)new DelegatingHandler(handler, event -> StompClientConnection.newInstance(event)));
        return this;
    }

    public StompClientConnection beginTX(String id, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.beginTX(id, receiptHandler);
        return this;
    }

    public StompClientConnection beginTX(String id) {
        return this.beginTX(id, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxBeginTX(String id) {
        return AsyncResultSingle.toSingle($handler -> this.beginTX(id, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection beginTX(String id, Map<String, String> headers, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.beginTX(id, headers, receiptHandler);
        return this;
    }

    public StompClientConnection beginTX(String id, Map<String, String> headers) {
        return this.beginTX(id, headers, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxBeginTX(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.beginTX(id, headers, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection commit(String id, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.commit(id, receiptHandler);
        return this;
    }

    public StompClientConnection commit(String id) {
        return this.commit(id, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxCommit(String id) {
        return AsyncResultSingle.toSingle($handler -> this.commit(id, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection commit(String id, Map<String, String> headers, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.commit(id, headers, receiptHandler);
        return this;
    }

    public StompClientConnection commit(String id, Map<String, String> headers) {
        return this.commit(id, headers, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxCommit(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.commit(id, headers, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection abort(String id, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.abort(id, receiptHandler);
        return this;
    }

    public StompClientConnection abort(String id) {
        return this.abort(id, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxAbort(String id) {
        return AsyncResultSingle.toSingle($handler -> this.abort(id, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection abort(String id, Map<String, String> headers, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.abort(id, headers, receiptHandler);
        return this;
    }

    public StompClientConnection abort(String id, Map<String, String> headers) {
        return this.abort(id, headers, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxAbort(String id, Map<String, String> headers) {
        return AsyncResultSingle.toSingle($handler -> this.abort(id, headers, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection disconnect(Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.disconnect(receiptHandler);
        return this;
    }

    public StompClientConnection disconnect() {
        return this.disconnect((Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxDisconnect() {
        return AsyncResultSingle.toSingle($handler -> this.disconnect((Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection disconnect(Frame frame, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.disconnect(frame, receiptHandler);
        return this;
    }

    public StompClientConnection disconnect(Frame frame) {
        return this.disconnect(frame, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxDisconnect(Frame frame) {
        return AsyncResultSingle.toSingle($handler -> this.disconnect(frame, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection ack(String id, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.ack(id, receiptHandler);
        return this;
    }

    public StompClientConnection ack(String id) {
        return this.ack(id, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxAck(String id) {
        return AsyncResultSingle.toSingle($handler -> this.ack(id, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection nack(String id, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.nack(id, receiptHandler);
        return this;
    }

    public StompClientConnection nack(String id) {
        return this.nack(id, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxNack(String id) {
        return AsyncResultSingle.toSingle($handler -> this.nack(id, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection ack(String id, String txId, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.ack(id, txId, receiptHandler);
        return this;
    }

    public StompClientConnection ack(String id, String txId) {
        return this.ack(id, txId, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxAck(String id, String txId) {
        return AsyncResultSingle.toSingle($handler -> this.ack(id, txId, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection nack(String id, String txId, Handler<AsyncResult<Frame>> receiptHandler) {
        this.delegate.nack(id, txId, receiptHandler);
        return this;
    }

    public StompClientConnection nack(String id, String txId) {
        return this.nack(id, txId, (Handler<AsyncResult<Frame>>)((Handler)ar -> {}));
    }

    public Single<Frame> rxNack(String id, String txId) {
        return AsyncResultSingle.toSingle($handler -> this.nack(id, txId, (Handler<AsyncResult<Frame>>)$handler));
    }

    public StompClientConnection receivedFrameHandler(Handler<Frame> handler) {
        this.delegate.receivedFrameHandler(handler);
        return this;
    }

    public StompClientConnection writingFrameHandler(Handler<Frame> handler) {
        this.delegate.writingFrameHandler(handler);
        return this;
    }

    public StompClientConnection exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public static StompClientConnection newInstance(io.vertx.ext.stomp.StompClientConnection arg) {
        return arg != null ? new StompClientConnection(arg) : null;
    }
}

