/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection pool which reuses a number of SQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Pool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Pool.class)
public class Pool extends io.vertx.reactivex.sqlclient.SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pool that = (Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Pool> __TYPE_ARG = new TypeArg<>(    obj -> new Pool((io.vertx.sqlclient.Pool) obj),
    Pool::getDelegate
  );

  private final io.vertx.sqlclient.Pool delegate;
  
  public Pool(io.vertx.sqlclient.Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Pool(Object delegate) {
    super((io.vertx.sqlclient.Pool)delegate);
    this.delegate = (io.vertx.sqlclient.Pool)delegate;
  }

  public io.vertx.sqlclient.Pool getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> TYPE_ARG_1 = new TypeArg<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>>(o1 -> io.vertx.reactivex.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.reactivex.sqlclient.Row>(o2 -> io.vertx.reactivex.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Pool#pool} with default options.
   * @param connectOptions 
   * @return 
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions connectOptions) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(connectOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.reactivex.sqlclient.Pool#pool} with a Vert.x instance created automatically.
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(database, options));
    return ret;
  }

  /**
   * Create a connection pool to the <code>database</code> with the given <code>options</code>.
   *
   * <p> A  will be selected among the drivers found on the classpath returning
   * <code>true</code> when  applied to the first options
   * of the list.
   * @param vertx the Vertx instance to be used with the connection pool
   * @param database the options used to create the connection pool, such as database hostname
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.reactivex.sqlclient.Pool pool(io.vertx.reactivex.core.Vertx vertx, io.vertx.sqlclient.SqlConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.reactivex.sqlclient.Pool ret = io.vertx.reactivex.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * Get a connection from the pool.
   * @param handler the handler that will get the connection result
   */
  public void getConnection(io.vertx.core.Handler<io.vertx.core.AsyncResult<io.vertx.reactivex.sqlclient.SqlConnection>> handler) { 
    delegate.getConnection(new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

  /**
   * Get a connection from the pool.
   */
  public void getConnection() {
    getConnection(ar -> { });
  }

  /**
   * Get a connection from the pool.
   * @return 
   */
  public io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection> rxGetConnection() { 
    return AsyncResultSingle.toSingle($handler -> {
      getConnection($handler);
    });
  }

  /**
   * 
   *
   * A connection is borrowed from the connection pool when the query is executed and then immediately returned
   * to the pool after it completes.
   * @param sql 
   * @return 
   */
  public io.vertx.reactivex.sqlclient.Query<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> query(java.lang.String sql) { 
    io.vertx.reactivex.sqlclient.Query<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * 
   *
   * A connection is borrowed from the connection pool when the query is executed and then immediately returned
   * to the pool after it completes.
   * @param sql 
   * @return 
   */
  public io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> preparedQuery(java.lang.String sql) { 
    io.vertx.reactivex.sqlclient.PreparedQuery<io.vertx.reactivex.sqlclient.RowSet<io.vertx.reactivex.sqlclient.Row>> ret = io.vertx.reactivex.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @param handler the result handler
   */
  public <T> void withTransaction(java.util.function.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.vertx.core.Future<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withTransaction(new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.vertx.core.Future<T> ret = function.apply(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        return ret.map(val -> val);
      }
    }, handler);
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   */
  public <T> void withTransaction(java.util.function.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) {
    withTransaction(function, ar -> { });
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxWithTransaction(java.util.function.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      withTransaction(function, $handler);
    });
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @param handler the result handler
   */
  public <T> void withTransaction(io.reactivex.functions.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.reactivex.Maybe<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withTransaction(new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.reactivex.Maybe<T> ret;
        try {
          ret = function.apply(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.MaybeHelper.toFuture(ret, obj -> obj);
      }
    }, handler);
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   */
  public <T> void withTransaction(io.reactivex.functions.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.reactivex.Maybe<T>> function) {
    withTransaction(function, ar -> { });
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxWithTransaction(io.reactivex.functions.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.reactivex.Maybe<T>> function) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      withTransaction(function, $handler);
    });
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @param handler the result handler
   */
  public <T> void withConnection(java.util.function.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.vertx.core.Future<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withConnection(new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.vertx.core.Future<T> ret = function.apply(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        return ret.map(val -> val);
      }
    }, handler);
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   */
  public <T> void withConnection(java.util.function.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) {
    withConnection(function, ar -> { });
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxWithConnection(java.util.function.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.vertx.core.Future<T>> function) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      withConnection(function, $handler);
    });
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @param handler the result handler
   */
  public <T> void withConnection(io.reactivex.functions.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.reactivex.Maybe<T>> function, io.vertx.core.Handler<io.vertx.core.AsyncResult<T>> handler) { 
    delegate.withConnection(new Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
        io.reactivex.Maybe<T> ret;
        try {
          ret = function.apply(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.MaybeHelper.toFuture(ret, obj -> obj);
      }
    }, handler);
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   */
  public <T> void withConnection(io.reactivex.functions.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.reactivex.Maybe<T>> function) {
    withConnection(function, ar -> { });
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * @param function the code to execute
   * @return 
   */
  public <T> io.reactivex.Maybe<T> rxWithConnection(io.reactivex.functions.Function<io.vertx.reactivex.sqlclient.SqlConnection,io.reactivex.Maybe<T>> function) { 
    return AsyncResultMaybe.toMaybe($handler -> {
      withConnection(function, $handler);
    });
  }

  /**
   * Close the pool and release the associated resources.
   * @param handler the completion handler
   */
  public void close(io.vertx.core.Handler<io.vertx.core.AsyncResult<java.lang.Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Close the pool and release the associated resources.
   */
  public void close() {
    close(ar -> { });
  }

  /**
   * Close the pool and release the associated resources.
   * @return 
   */
  public io.reactivex.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable($handler -> {
      close($handler);
    });
  }

  /**
   * Set an handler called when the pool has established a connection to the database.
   *
   * <p> This handler allows interactions with the database before the connection is added to the pool.
   *
   * <p> When the handler has finished, it must call {@link io.vertx.reactivex.sqlclient.SqlClient#close} to release the connection
   * to the pool.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Pool connectHandler(io.vertx.core.Handler<io.vertx.reactivex.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new Handler<io.vertx.sqlclient.SqlConnection>() {
      public void handle(io.vertx.sqlclient.SqlConnection event) {
        handler.handle(io.vertx.reactivex.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event));
      }
    });
    return this;
  }

  /**
   * Replace the default pool connection provider, the new <code>provider</code> returns a future connection for a
   * given .
   *
   * <p> A {@link io.vertx.sqlclient.spi.ConnectionFactory} can be used as connection provider.
   * @param provider the new connection provider
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Pool connectionProvider(java.util.function.Function<io.vertx.reactivex.core.Context,io.vertx.core.Future<io.vertx.reactivex.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.vertx.core.Future<io.vertx.reactivex.sqlclient.SqlConnection> ret = provider.apply(io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)arg));
        return ret.map(val -> val.getDelegate());
      }
    });
    return this;
  }

  /**
   * Replace the default pool connection provider, the new <code>provider</code> returns a future connection for a
   * given .
   *
   * <p> A {@link io.vertx.sqlclient.spi.ConnectionFactory} can be used as connection provider.
   * @param provider the new connection provider
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.reactivex.sqlclient.Pool connectionProvider(io.reactivex.functions.Function<io.vertx.reactivex.core.Context,io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
        io.reactivex.Single<io.vertx.reactivex.sqlclient.SqlConnection> ret;
        try {
          ret = provider.apply(io.vertx.reactivex.core.Context.newInstance((io.vertx.core.Context)arg));
        } catch (Exception e) {
          return io.vertx.core.Future.failedFuture(e);
        }
        return io.vertx.reactivex.SingleHelper.toFuture(ret, obj -> obj.getDelegate());
      }
    });
    return this;
  }

  /**
   * @return the current pool size approximation
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
    return arg != null ? new Pool(arg) : null;
  }

}
