/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.handler;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler that serves favicons.
 * <p>
 * If no file system path is specified it will attempt to serve a resource called `favicon.ico` from the classpath.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.FaviconHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.FaviconHandler.class)
public class FaviconHandler implements Handler<io.vertx.reactivex.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FaviconHandler that = (FaviconHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FaviconHandler> __TYPE_ARG = new TypeArg<>(    obj -> new FaviconHandler((io.vertx.ext.web.handler.FaviconHandler) obj),
    FaviconHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.FaviconHandler delegate;
  
  public FaviconHandler(io.vertx.ext.web.handler.FaviconHandler delegate) {
    this.delegate = delegate;
  }

  public FaviconHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.FaviconHandler)delegate;
  }

  public io.vertx.ext.web.handler.FaviconHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.reactivex.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a handler with defaults
   * @param vertx 
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.FaviconHandler create(io.vertx.reactivex.core.Vertx vertx) { 
    io.vertx.reactivex.ext.web.handler.FaviconHandler ret = io.vertx.reactivex.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a handler attempting to load favicon file from the specified path
   * @param vertx 
   * @param path the path
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.FaviconHandler create(io.vertx.reactivex.core.Vertx vertx, java.lang.String path) { 
    io.vertx.reactivex.ext.web.handler.FaviconHandler ret = io.vertx.reactivex.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate(), path));
    return ret;
  }

  /**
   * Create a handler attempting to load favicon file from the specified path, and with the specified max cache time
   * @param vertx 
   * @param path the path
   * @param maxAgeSeconds max how long the file will be cached by browser, in seconds
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.FaviconHandler create(io.vertx.reactivex.core.Vertx vertx, java.lang.String path, long maxAgeSeconds) { 
    io.vertx.reactivex.ext.web.handler.FaviconHandler ret = io.vertx.reactivex.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate(), path, maxAgeSeconds));
    return ret;
  }

  /**
   * Create a handler with the specified max cache time
   * @param vertx 
   * @param maxAgeSeconds max how long the file will be cached by browser, in seconds
   * @return the handler
   */
  public static io.vertx.reactivex.ext.web.handler.FaviconHandler create(io.vertx.reactivex.core.Vertx vertx, long maxAgeSeconds) { 
    io.vertx.reactivex.ext.web.handler.FaviconHandler ret = io.vertx.reactivex.ext.web.handler.FaviconHandler.newInstance((io.vertx.ext.web.handler.FaviconHandler)io.vertx.ext.web.handler.FaviconHandler.create(vertx.getDelegate(), maxAgeSeconds));
    return ret;
  }

  /**
   * The default max age in seconds as set in the cache-control header
   */
  public static final long DEFAULT_MAX_AGE_SECONDS = io.vertx.ext.web.handler.FaviconHandler.DEFAULT_MAX_AGE_SECONDS;
  public static FaviconHandler newInstance(io.vertx.ext.web.handler.FaviconHandler arg) {
    return arg != null ? new FaviconHandler(arg) : null;
  }

}
