/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.api.validation;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Interface for declaration of method for validate a specific parameter type.<br/>
 * If you want to implement your own type validator, you need only to implement
 * {@link io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator#isValid}:
 * <ul>
 * <li>If parameter is valid, call  to put value (maybe modified) inside
 * RequestParameters. The validation flow will care about set parameter name</li>
 * <li>If parameter is invalid, throw a new ValidationException with message
 * ({@link io.vertx.ext.web.api.validation.ValidationException}) and/or with
 * {@link io.vertx.ext.web.api.validation.ValidationException.ErrorType}
 * (). As for value, the
 * validation flow will care about setting all other ValidationException fields</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.api.validation.ParameterTypeValidator original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.api.validation.ParameterTypeValidator.class)
public class ParameterTypeValidator {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParameterTypeValidator that = (ParameterTypeValidator) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ParameterTypeValidator> __TYPE_ARG = new TypeArg<>(    obj -> new ParameterTypeValidator((io.vertx.ext.web.api.validation.ParameterTypeValidator) obj),
    ParameterTypeValidator::getDelegate
  );

  private final io.vertx.ext.web.api.validation.ParameterTypeValidator delegate;
  
  public ParameterTypeValidator(io.vertx.ext.web.api.validation.ParameterTypeValidator delegate) {
    this.delegate = delegate;
  }

  public ParameterTypeValidator(Object delegate) {
    this.delegate = (io.vertx.ext.web.api.validation.ParameterTypeValidator)delegate;
  }

  public io.vertx.ext.web.api.validation.ParameterTypeValidator getDelegate() {
    return delegate;
  }

  /**
   * Function that checks if parameter is valid. It returns a RequestParameter object that will be linked inside
   * . For more info, check .
   * @param value value of parameter to test
   * @return request parameter value
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.RequestParameter isValid(java.lang.String value) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.isValid(value));
    return ret;
  }

  /**
   * Function that checks if array of values of a specific parameter. It returns a RequestParameter object that will
   * be linked inside . For more info, check .
   * @param value list of values of parameter to test
   * @return request parameter value
   */
  @Deprecated()
  public io.vertx.reactivex.ext.web.api.RequestParameter isValidCollection(java.util.List<java.lang.String> value) { 
    io.vertx.reactivex.ext.web.api.RequestParameter ret = io.vertx.reactivex.ext.web.api.RequestParameter.newInstance((io.vertx.ext.web.api.RequestParameter)delegate.isValidCollection(value));
    return ret;
  }

  /**
   * Returns default value of parameter
   * @return 
   */
  @Deprecated()
  public java.lang.Object getDefault() { 
    java.lang.Object ret = (Object) delegate.getDefault();
    return ret;
  }

  /**
   * Returns true if this type validator has default value
   * @return 
   */
  @Deprecated()
  public boolean hasDefault() { 
    boolean ret = delegate.hasDefault();
    return ret;
  }

  /**
   * Create a new type validator for integer values
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createIntegerTypeValidator(java.lang.Integer defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createIntegerTypeValidator(defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for integer values
   * @param maximum Maximum value. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createIntegerTypeValidator(java.lang.Double maximum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Integer defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createIntegerTypeValidator(maximum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for integer values
   * @param exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
   * @param maximum Maximum value. It can be null
   * @param exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createIntegerTypeValidator(java.lang.Boolean exclusiveMaximum, java.lang.Double maximum, java.lang.Boolean exclusiveMinimum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createIntegerTypeValidator(exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for long integer values
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createLongTypeValidator(java.lang.Long defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createLongTypeValidator(defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for long integer values
   * @param maximum Maximum value. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createLongTypeValidator(java.lang.Double maximum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Long defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createLongTypeValidator(maximum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for long integer values
   * @param exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
   * @param maximum Maximum value. It can be null
   * @param exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createLongTypeValidator(java.lang.Boolean exclusiveMaximum, java.lang.Double maximum, java.lang.Boolean exclusiveMinimum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createLongTypeValidator(exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for float values
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createFloatTypeValidator(java.lang.Float defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createFloatTypeValidator(defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for float values
   * @param maximum Maximum value. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createFloatTypeValidator(java.lang.Double maximum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Float defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createFloatTypeValidator(maximum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for float values
   * @param exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
   * @param maximum Maximum value. It can be null
   * @param exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createFloatTypeValidator(java.lang.Boolean exclusiveMaximum, java.lang.Double maximum, java.lang.Boolean exclusiveMinimum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createFloatTypeValidator(exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for double values
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createDoubleTypeValidator(java.lang.Double defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createDoubleTypeValidator(defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for double values
   * @param maximum Maximum value. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createDoubleTypeValidator(java.lang.Double maximum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Double defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createDoubleTypeValidator(maximum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new type validator for double values
   * @param exclusiveMaximum If true, value will be mark as valid if value < maximum. If false, value will be mark as valid if value <= maximum. The default value is false. It can be null
   * @param maximum Maximum value. It can be null
   * @param exclusiveMinimum If true, value will be mark as valid if value > minimum. If false, value will be mark as valid if value >= minimum. The default value is false. It can be null
   * @param minimum Minimum value. It can be null
   * @param multipleOf Multiple of value. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createDoubleTypeValidator(java.lang.Boolean exclusiveMaximum, java.lang.Double maximum, java.lang.Boolean exclusiveMinimum, java.lang.Double minimum, java.lang.Double multipleOf, java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createDoubleTypeValidator(exclusiveMaximum, maximum, exclusiveMinimum, minimum, multipleOf, defaultValue));
    return ret;
  }

  /**
   * Create a new string type validator
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createStringTypeValidator(java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createStringTypeValidator(defaultValue));
    return ret;
  }

  /**
   * Create a new string type validator
   * @param pattern pattern that string have to match. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createStringTypeValidator(java.lang.String pattern, java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createStringTypeValidator(pattern, defaultValue));
    return ret;
  }

  /**
   * Create a new string type validator
   * @param pattern pattern that string have to match. It can be null
   * @param minLength Minimum length of string. It can be null
   * @param maxLength Maximum length of string. It can be null
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createStringTypeValidator(java.lang.String pattern, java.lang.Integer minLength, java.lang.Integer maxLength, java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createStringTypeValidator(pattern, minLength, maxLength, defaultValue));
    return ret;
  }

  /**
   * Create a boolean type validator
   * @param defaultValue Default value that will be set if parameter is empty or not found. To apply default value you have to set {@link io.vertx.reactivex.ext.web.api.validation.ParameterValidationRule#allowEmptyValue} true. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createBooleanTypeValidator(java.lang.Object defaultValue) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createBooleanTypeValidator(defaultValue));
    return ret;
  }

  /**
   * Create an enum type validator
   * @param allowedValues allowed values. It <b>can't be</b> null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createStringEnumTypeValidator(java.util.List<java.lang.String> allowedValues) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createStringEnumTypeValidator(allowedValues));
    return ret;
  }

  /**
   * Create an enum type validator
   * @param allowedValues allowed values. It <b>can't be</b> null
   * @param innerValidator After check if value is one of the lists, you can pass the value to an inner validator. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createEnumTypeValidatorWithInnerValidator(java.util.List<java.lang.Object> allowedValues, io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator innerValidator) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createEnumTypeValidatorWithInnerValidator(allowedValues, innerValidator.getDelegate()));
    return ret;
  }

  /**
   * Create an array type validator
   * @param arrayMembersValidator Type validator that describe array items. It <b>can't be</b> null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createArrayTypeValidator(io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator arrayMembersValidator) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createArrayTypeValidator(arrayMembersValidator.getDelegate()));
    return ret;
  }

  /**
   * Create an array type validator
   * @param arrayMembersValidator Type validator that describe array items. It <b>can't be</b> null
   * @param collectionFormat String that represent a ContainerSerializationStyle. Check out {@link io.vertx.ext.web.api.validation.ContainerSerializationStyle} for more informations. The default value is "csv". It can be null
   * @param maxItems Maximum items in array. It can be null
   * @param minItems Minimum items in array. It can be null
   * @return 
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator createArrayTypeValidator(io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator arrayMembersValidator, java.lang.String collectionFormat, java.lang.Integer maxItems, java.lang.Integer minItems) { 
    io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator ret = io.vertx.reactivex.ext.web.api.validation.ParameterTypeValidator.newInstance((io.vertx.ext.web.api.validation.ParameterTypeValidator)io.vertx.ext.web.api.validation.ParameterTypeValidator.createArrayTypeValidator(arrayMembersValidator.getDelegate(), collectionFormat, maxItems, minItems));
    return ret;
  }

  public static ParameterTypeValidator newInstance(io.vertx.ext.web.api.validation.ParameterTypeValidator arg) {
    return arg != null ? new ParameterTypeValidator(arg) : null;
  }

}
