/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.shell.term;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Provide interactions with the Shell TTY.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.term.Tty original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.term.Tty.class)
public class Tty {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Tty that = (Tty) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Tty> __TYPE_ARG = new TypeArg<>(    obj -> new Tty((io.vertx.ext.shell.term.Tty) obj),
    Tty::getDelegate
  );

  private final io.vertx.ext.shell.term.Tty delegate;
  
  public Tty(io.vertx.ext.shell.term.Tty delegate) {
    this.delegate = delegate;
  }

  public Tty(Object delegate) {
    this.delegate = (io.vertx.ext.shell.term.Tty)delegate;
  }

  public io.vertx.ext.shell.term.Tty getDelegate() {
    return delegate;
  }

  /**
   * @return the declared tty type, for instance , , etc... it can be null when the tty does not have declared its type.
   */
  public java.lang.String type() { 
    java.lang.String ret = delegate.type();
    return ret;
  }

  /**
   * @return the current width, i.e the number of rows or  if unknown
   */
  public int width() { 
    int ret = delegate.width();
    return ret;
  }

  /**
   * @return the current height, i.e the number of columns or  if unknown
   */
  public int height() { 
    int ret = delegate.height();
    return ret;
  }

  /**
   * Set a stream handler on the standard input to read the data.
   * @param handler the standard input
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.term.Tty stdinHandler(io.vertx.core.Handler<java.lang.String> handler) { 
    delegate.stdinHandler(handler);
    return this;
  }

  /**
   * Write data to the standard output.
   * @param data the data to write
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.term.Tty write(java.lang.String data) { 
    delegate.write(data);
    return this;
  }

  /**
   * Set a resize handler, the handler is called when the tty size changes.
   * @param handler the resize handler
   * @return this object
   */
  public io.vertx.reactivex.ext.shell.term.Tty resizehandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.resizehandler(handler);
    return this;
  }

  public static Tty newInstance(io.vertx.ext.shell.term.Tty arg) {
    return arg != null ? new Tty(arg) : null;
  }

}
