/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.sqlclient;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider} instances that use the Vert.x SQL client.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.sqlclient.SqlAuthentication original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.sqlclient.SqlAuthentication.class)
public class SqlAuthentication extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlAuthentication that = (SqlAuthentication) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlAuthentication> __TYPE_ARG = new TypeArg<>(    obj -> new SqlAuthentication((io.vertx.ext.auth.sqlclient.SqlAuthentication) obj),
    SqlAuthentication::getDelegate
  );

  private final io.vertx.ext.auth.sqlclient.SqlAuthentication delegate;
  
  public SqlAuthentication(io.vertx.ext.auth.sqlclient.SqlAuthentication delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public SqlAuthentication(Object delegate) {
    super((io.vertx.ext.auth.sqlclient.SqlAuthentication)delegate);
    this.delegate = (io.vertx.ext.auth.sqlclient.SqlAuthentication)delegate;
  }

  public io.vertx.ext.auth.sqlclient.SqlAuthentication getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC auth provider implementation
   * @param client the JDBC client instance
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.sqlclient.SqlAuthentication create(io.vertx.reactivex.sqlclient.SqlClient client) { 
    io.vertx.reactivex.ext.auth.sqlclient.SqlAuthentication ret = io.vertx.reactivex.ext.auth.sqlclient.SqlAuthentication.newInstance((io.vertx.ext.auth.sqlclient.SqlAuthentication)io.vertx.ext.auth.sqlclient.SqlAuthentication.create(client.getDelegate()));
    return ret;
  }

  /**
   * Create a JDBC auth provider implementation
   * @param client the JDBC client instance
   * @param options authentication options
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.sqlclient.SqlAuthentication create(io.vertx.reactivex.sqlclient.SqlClient client, io.vertx.ext.auth.sqlclient.SqlAuthenticationOptions options) { 
    io.vertx.reactivex.ext.auth.sqlclient.SqlAuthentication ret = io.vertx.reactivex.ext.auth.sqlclient.SqlAuthentication.newInstance((io.vertx.ext.auth.sqlclient.SqlAuthentication)io.vertx.ext.auth.sqlclient.SqlAuthentication.create(client.getDelegate(), options));
    return ret;
  }

  /**
   * Hashes a password to be stored.
   *
   * See: {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param id 
   * @param params 
   * @param salt 
   * @param password 
   * @return 
   */
  public java.lang.String hash(java.lang.String id, java.util.Map<java.lang.String,java.lang.String> params, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * Hashes a password to be stored.
   *
   * See: {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param id 
   * @param salt 
   * @param password 
   * @return 
   */
  public java.lang.String hash(java.lang.String id, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, salt, password);
    return ret;
  }

  public static SqlAuthentication newInstance(io.vertx.ext.auth.sqlclient.SqlAuthentication arg) {
    return arg != null ? new SqlAuthentication(arg) : null;
  }

}
