/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.jdbc;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating {@link io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider} instances that use the Vert.x JDBC client.
 *
 * By default the hashing strategy is SHA-512. If you're already running in production this is backwards
 * compatible, however for new deployments or security upgrades it is recommended to use the PBKDF2 strategy
 * as it is the current OWASP recommendation for password storage.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCAuthentication original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.jdbc.JDBCAuthentication.class)
public class JDBCAuthentication extends io.vertx.reactivex.ext.auth.authentication.AuthenticationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCAuthentication that = (JDBCAuthentication) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCAuthentication> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCAuthentication((io.vertx.ext.auth.jdbc.JDBCAuthentication) obj),
    JDBCAuthentication::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCAuthentication delegate;
  
  public JDBCAuthentication(io.vertx.ext.auth.jdbc.JDBCAuthentication delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCAuthentication(Object delegate) {
    super((io.vertx.ext.auth.jdbc.JDBCAuthentication)delegate);
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCAuthentication)delegate;
  }

  public io.vertx.ext.auth.jdbc.JDBCAuthentication getDelegate() {
    return delegate;
  }

  /**
   * Create a JDBC auth provider implementation
   * @param client the JDBC client instance
   * @param hashStrategy legacy hashing strategy
   * @param options authentication options
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.reactivex.ext.auth.jdbc.JDBCAuthentication create(io.vertx.reactivex.ext.jdbc.JDBCClient client, io.vertx.reactivex.ext.auth.jdbc.JDBCHashStrategy hashStrategy, io.vertx.ext.auth.jdbc.JDBCAuthenticationOptions options) { 
    io.vertx.reactivex.ext.auth.jdbc.JDBCAuthentication ret = io.vertx.reactivex.ext.auth.jdbc.JDBCAuthentication.newInstance((io.vertx.ext.auth.jdbc.JDBCAuthentication)io.vertx.ext.auth.jdbc.JDBCAuthentication.create(client.getDelegate(), hashStrategy.getDelegate(), options));
    return ret;
  }

  /**
   * Create a JDBC auth provider implementation
   * @param client the JDBC client instance
   * @param options authentication options
   * @return the auth provider
   */
  public static io.vertx.reactivex.ext.auth.jdbc.JDBCAuthentication create(io.vertx.reactivex.ext.jdbc.JDBCClient client, io.vertx.ext.auth.jdbc.JDBCAuthenticationOptions options) { 
    io.vertx.reactivex.ext.auth.jdbc.JDBCAuthentication ret = io.vertx.reactivex.ext.auth.jdbc.JDBCAuthentication.newInstance((io.vertx.ext.auth.jdbc.JDBCAuthentication)io.vertx.ext.auth.jdbc.JDBCAuthentication.create(client.getDelegate(), options));
    return ret;
  }

  /**
   * Hashes a password to be stored.
   *
   * See: {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param id 
   * @param params 
   * @param salt 
   * @param password 
   * @return 
   */
  public java.lang.String hash(java.lang.String id, java.util.Map<java.lang.String,java.lang.String> params, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * Hashes a password to be stored.
   *
   * See: {@link io.vertx.reactivex.ext.auth.HashingStrategy#hash}
   * @param id 
   * @param salt 
   * @param password 
   * @return 
   */
  public java.lang.String hash(java.lang.String id, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, salt, password);
    return ret;
  }

  public static JDBCAuthentication newInstance(io.vertx.ext.auth.jdbc.JDBCAuthentication arg) {
    return arg != null ? new JDBCAuthentication(arg) : null;
  }

}
