/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.net;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The address of a socket, an inet socket address or a domain socket address.
 * <p/>
 * Use {@link io.vertx.reactivex.core.net.SocketAddress#inetSocketAddress} to create an inet socket address and {@link io.vertx.reactivex.core.net.SocketAddress#domainSocketAddress}
 * to create a domain socket address
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.SocketAddress original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.SocketAddress.class)
public class SocketAddress {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SocketAddress that = (SocketAddress) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SocketAddress> __TYPE_ARG = new TypeArg<>(    obj -> new SocketAddress((io.vertx.core.net.SocketAddress) obj),
    SocketAddress::getDelegate
  );

  private final io.vertx.core.net.SocketAddress delegate;
  
  public SocketAddress(io.vertx.core.net.SocketAddress delegate) {
    this.delegate = delegate;
  }

  public SocketAddress(Object delegate) {
    this.delegate = (io.vertx.core.net.SocketAddress)delegate;
  }

  public io.vertx.core.net.SocketAddress getDelegate() {
    return delegate;
  }

  /**
   * Create a inet socket address, <code>host</code> must be non <code>null</code> and <code>port</code> must be between <code>0</code>
   * and <code>65536</code>.
   * <br/>
   * The <code>host</code> string can be an host name or an host address.
   * <br/>
   * No name resolution will be attempted.
   * @param port the port
   * @param host the host
   * @return the created socket address
   */
  public static io.vertx.reactivex.core.net.SocketAddress inetSocketAddress(int port, java.lang.String host) { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)io.vertx.core.net.SocketAddress.inetSocketAddress(port, host));
    return ret;
  }

  /**
   * Create a domain socket address from a <code>path</code>.
   * @param path the address path
   * @return the created socket address
   */
  public static io.vertx.reactivex.core.net.SocketAddress domainSocketAddress(java.lang.String path) { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)io.vertx.core.net.SocketAddress.domainSocketAddress(path));
    return ret;
  }

  /**
   * Returns the host name when available or the IP address in string representation.
   * <br/>
   * Domain socket address returns <code>null</code>.
   * @return the host address
   */
  public java.lang.String host() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.host();
    cached_0 = ret;
    return ret;
  }

  /**
   * Returns the host name when available or <code>null</code>
   * <br/>
   * Domain socket address returns <code>null</code>.
   * @return the host name
   */
  public java.lang.String hostName() { 
    if (cached_1 != null) {
      return cached_1;
    }
    java.lang.String ret = delegate.hostName();
    cached_1 = ret;
    return ret;
  }

  /**
   * Returns the host IP address when available or <code>null</code> as a String.
   * <br/>
   * Domain socket address returns <code>null</code>.
   * @return the host address
   */
  public java.lang.String hostAddress() { 
    if (cached_2 != null) {
      return cached_2;
    }
    java.lang.String ret = delegate.hostAddress();
    cached_2 = ret;
    return ret;
  }

  /**
   * @return the address port or <code>-1</code> for a domain socket
   */
  public int port() { 
    if (cached_3 != null) {
      return cached_3;
    }
    int ret = delegate.port();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return the domain socket path or <code>null</code> for a inet socket address.
   */
  public java.lang.String path() { 
    if (cached_4 != null) {
      return cached_4;
    }
    java.lang.String ret = delegate.path();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> for an inet socket address
   */
  public boolean isInetSocket() { 
    if (cached_5 != null) {
      return cached_5;
    }
    boolean ret = delegate.isInetSocket();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return <code>true</code> for an domain socket address
   */
  public boolean isDomainSocket() { 
    if (cached_6 != null) {
      return cached_6;
    }
    boolean ret = delegate.isDomainSocket();
    cached_6 = ret;
    return ret;
  }

  /**
   * Create a inet socket address from a Java .
   * <br/>
   * No name resolution will be attempted.
   * @param address the address
   * @return the created socket address
   */
  public static io.vertx.reactivex.core.net.SocketAddress inetSocketAddress(java.net.InetSocketAddress address) { 
    io.vertx.reactivex.core.net.SocketAddress ret = io.vertx.reactivex.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)io.vertx.core.net.SocketAddress.inetSocketAddress(address));
    return ret;
  }

  private java.lang.String cached_0;
  private java.lang.String cached_1;
  private java.lang.String cached_2;
  private java.lang.Integer cached_3;
  private java.lang.String cached_4;
  private java.lang.Boolean cached_5;
  private java.lang.Boolean cached_6;
  public static SocketAddress newInstance(io.vertx.core.net.SocketAddress arg) {
    return arg != null ? new SocketAddress(arg) : null;
  }

}
