/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.core.dns;

import io.vertx.reactivex.RxHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.WriteStreamObserver;
import io.vertx.reactivex.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represent a Service-Record (SRV) which was resolved for a domain.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.dns.SrvRecord original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.dns.SrvRecord.class)
public class SrvRecord {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SrvRecord that = (SrvRecord) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SrvRecord> __TYPE_ARG = new TypeArg<>(    obj -> new SrvRecord((io.vertx.core.dns.SrvRecord) obj),
    SrvRecord::getDelegate
  );

  private final io.vertx.core.dns.SrvRecord delegate;
  
  public SrvRecord(io.vertx.core.dns.SrvRecord delegate) {
    this.delegate = delegate;
  }

  public SrvRecord(Object delegate) {
    this.delegate = (io.vertx.core.dns.SrvRecord)delegate;
  }

  public io.vertx.core.dns.SrvRecord getDelegate() {
    return delegate;
  }

  /**
   * Returns the priority for this service record.
   * @return 
   */
  public int priority() { 
    int ret = delegate.priority();
    return ret;
  }

  /**
   * Returns the weight of this service record.
   * @return 
   */
  public int weight() { 
    int ret = delegate.weight();
    return ret;
  }

  /**
   * Returns the port the service is running on.
   * @return 
   */
  public int port() { 
    int ret = delegate.port();
    return ret;
  }

  /**
   * Returns the name for the server being queried.
   * @return 
   */
  public java.lang.String name() { 
    java.lang.String ret = delegate.name();
    return ret;
  }

  /**
   * Returns the protocol for the service being queried (i.e. "_tcp").
   * @return 
   */
  public java.lang.String protocol() { 
    java.lang.String ret = delegate.protocol();
    return ret;
  }

  /**
   * Returns the service's name (i.e. "_http").
   * @return 
   */
  public java.lang.String service() { 
    java.lang.String ret = delegate.service();
    return ret;
  }

  /**
   * Returns the name of the host for the service.
   * @return 
   */
  public java.lang.String target() { 
    java.lang.String ret = delegate.target();
    return ret;
  }

  public static SrvRecord newInstance(io.vertx.core.dns.SrvRecord arg) {
    return arg != null ? new SrvRecord(arg) : null;
  }

}
