/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.PreparedQuery;
import io.vertx.reactivex.sqlclient.RowSet;
import io.vertx.reactivex.sqlclient.SqlClient;
import io.vertx.reactivex.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
extends SqlClient {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    public Transaction prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Transaction prepare(String sql) {
        return this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)((Handler)ar -> {}));
    }

    public Single<PreparedQuery> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)handler));
    }

    public void commit() {
        this.delegate.commit();
    }

    public void commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
    }

    public Completable rxCommit() {
        return AsyncResultCompletable.toCompletable(handler -> this.commit((Handler<AsyncResult<Void>>)handler));
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
    }

    public Completable rxRollback() {
        return AsyncResultCompletable.toCompletable(handler -> this.rollback((Handler<AsyncResult<Void>>)handler));
    }

    public Transaction abortHandler(Handler<Void> handler) {
        this.delegate.abortHandler(handler);
        return this;
    }

    @Override
    public Transaction query(String sql, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction query(String sql) {
        return this.query(sql, ar -> {});
    }

    @Override
    public Single<RowSet> rxQuery(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.query(sql, (Handler)handler));
    }

    @Override
    public Transaction preparedQuery(String sql, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction preparedQuery(String sql) {
        return this.preparedQuery(sql, ar -> {});
    }

    @Override
    public Single<RowSet> rxPreparedQuery(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.preparedQuery(sql, (Handler)handler));
    }

    @Override
    public Transaction preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction preparedQuery(String sql, Tuple arguments) {
        return this.preparedQuery(sql, arguments, ar -> {});
    }

    @Override
    public Single<RowSet> rxPreparedQuery(String sql, Tuple arguments) {
        return AsyncResultSingle.toSingle(handler -> this.preparedQuery(sql, arguments, (Handler)handler));
    }

    @Override
    public Transaction preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Transaction preparedBatch(String sql, List<Tuple> batch) {
        return this.preparedBatch(sql, (List)batch, ar -> {});
    }

    @Override
    public Single<RowSet> rxPreparedBatch(String sql, List<Tuple> batch) {
        return AsyncResultSingle.toSingle(handler -> this.preparedBatch(sql, (List)batch, (Handler)handler));
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

