/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.PreparedQuery;
import io.vertx.reactivex.sqlclient.Row;
import io.vertx.reactivex.sqlclient.RowSet;
import io.vertx.reactivex.sqlclient.SqlClient;
import io.vertx.reactivex.sqlclient.Transaction;
import io.vertx.reactivex.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection
extends SqlClient {
    public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg(obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection)obj), SqlConnection::getDelegate);
    private final io.vertx.sqlclient.SqlConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConnection that = (SqlConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public io.vertx.sqlclient.SqlConnection getDelegate() {
        return this.delegate;
    }

    public SqlConnection prepare(String sql, final Handler<AsyncResult<PreparedQuery>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedQuery>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedQuery> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PreparedQuery> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.prepare(sql, (Handler<AsyncResult<PreparedQuery>>)handler));
    }

    public SqlConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SqlConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Transaction begin() {
        Transaction ret = Transaction.newInstance(this.delegate.begin());
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public SqlConnection preparedQuery(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet<Row>> rxPreparedQuery(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.preparedQuery(sql, (Handler)handler));
    }

    @Override
    public SqlConnection query(String sql, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.query(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet<Row>> rxQuery(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.query(sql, (Handler)handler));
    }

    @Override
    public SqlConnection preparedQuery(String sql, Tuple arguments, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedQuery(sql, arguments.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet<Row>> rxPreparedQuery(String sql, Tuple arguments) {
        return AsyncResultSingle.toSingle(handler -> this.preparedQuery(sql, arguments, (Handler)handler));
    }

    @Override
    public SqlConnection preparedBatch(String sql, List<Tuple> batch, final Handler<AsyncResult<RowSet<Row>>> handler) {
        this.delegate.preparedBatch(sql, batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.RowSet<io.vertx.sqlclient.Row>> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture(RowSet.newInstance((io.vertx.sqlclient.RowSet)ar.result(), Row.__TYPE_ARG)));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<RowSet<Row>> rxPreparedBatch(String sql, List<Tuple> batch) {
        return AsyncResultSingle.toSingle(handler -> this.preparedBatch(sql, (List)batch, (Handler)handler));
    }

    public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
        return arg != null ? new SqlConnection(arg) : null;
    }
}

